/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.brics.execution.behavior.impl;

import de.rcenvironment.components.brics.execution.behavior.impl.AbstractBricsTaskBehavior;
import de.rcenvironment.components.brics.execution.facade.impl.BricsMultiTaskFacade;
import de.rcenvironment.components.brics.execution.validation.impl.BricsTaskComponentValidator;
import de.rcenvironment.core.component.api.ComponentException;
import de.rcenvironment.core.component.execution.api.Component;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.logging.LogFactory;

public class BricsMultiTaskBehavior
extends AbstractBricsTaskBehavior {
    private BricsMultiTaskFacade bricsMultiTaskFacade;
    private String taskId;

    @Override
    public void start() throws ComponentException {
        super.start();
        this.bricsMultiTaskFacade = this.bricsFacadeFactory.createBricsMultiTaskFacade(this.createEnv(this.compContext), this.compContext.getLog());
        try {
            this.taskId = this.bricsMultiTaskFacade.init(this.compContext.getConfigurationValue("task_name_id"), this.compContext.getConfigurationValue("mail_to"), String.valueOf(this.compContext.getConfigurationValue("mail_message")) + "(multi-task)");
        }
        catch (IOException e) {
            throw new ComponentException("Failed to initialized BRICS multi-task execution", (Throwable)e);
        }
    }

    @Override
    protected void sendTaskRequest(File inputFileDir, File outputFileDir) throws IOException {
        this.bricsMultiTaskFacade.execute(this.taskId, inputFileDir, outputFileDir);
    }

    @Override
    public void tearDown(Component.FinalComponentState state) {
        try {
            this.bricsMultiTaskFacade.end(this.taskId);
        }
        catch (IOException e) {
            LogFactory.getLog(this.getClass()).error((Object)"Failed to terminate BRICS multi-task execution", (Throwable)e);
        }
        super.tearDown(state);
    }

    @Override
    protected void initializeNewHistoryDataItem() {
        super.initializeNewHistoryDataItem();
        this.historyDataItem.setTaskMode("multi-task");
    }

    @Override
    protected Map<String, String> getConfigKeyAndErrorMessages() {
        return BricsTaskComponentValidator.CONFIG_KEY_ERROR_MESSAGES;
    }
}

