/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.brics.execution.behavior.impl;

import de.rcenvironment.components.brics.execution.behavior.impl.AbstractBricsDownloadUploadBehavior;
import de.rcenvironment.components.brics.execution.validation.impl.BricsDownloadUploadComponentValidator;
import de.rcenvironment.core.component.api.ComponentException;
import java.io.File;
import java.io.IOException;
import java.util.Map;

public class BricsMultiDownloadUploadBehavior
extends AbstractBricsDownloadUploadBehavior {
    @Override
    public void processInputs() throws ComponentException {
        this.initializeNewHistoryDataItem();
        this.writeFinalHistoryDataItem();
        this.uploadIncomingFile();
        ++this.count;
        this.downloadFileAndWriteOrClose();
    }

    @Override
    protected void initializeNewHistoryDataItem() {
        super.initializeNewHistoryDataItem();
        this.historyDataItem.setTaskMode("multi-task");
        this.historyDataItem.setTaskNameId(String.valueOf(this.taskId) + "_" + this.count);
    }

    @Override
    protected void downloadFileAndWriteOrClose() throws ComponentException {
        try {
            this.bricsDownloadUploadFacade.wait(this.taskId, this.count);
        }
        catch (IOException e) {
            throw new ComponentException("Failed to wait for input files ready to download through BRICS", (Throwable)e);
        }
        super.downloadFileAndWriteOrClose();
    }

    @Override
    protected void uploadFileFromDir(File fileDir) throws IOException {
        this.bricsDownloadUploadFacade.uploadResultFiles(this.taskId, this.count, fileDir);
    }

    @Override
    protected boolean downloadFileIntoDir(File fileDir) throws IOException {
        return this.bricsDownloadUploadFacade.downloadInputFiles(this.taskId, this.count, fileDir);
    }

    @Override
    protected Map<String, String> getConfigKeyAndErrorMessages() {
        return BricsDownloadUploadComponentValidator.CONFIG_KEY_ERROR_MESSAGES;
    }
}

