/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.brics.execution.behavior.impl;

import de.rcenvironment.components.brics.common.api.BricsComponentHistoryDataItem;
import de.rcenvironment.components.brics.execution.behavior.impl.BricsBehavior;
import de.rcenvironment.components.brics.execution.call.impl.BricsEnvironment;
import de.rcenvironment.components.brics.execution.facade.impl.BricsFacadeFactory;
import de.rcenvironment.core.component.api.ComponentException;
import de.rcenvironment.core.component.datamanagement.api.ComponentDataManagementService;
import de.rcenvironment.core.component.datamanagement.api.ComponentHistoryDataItem;
import de.rcenvironment.core.component.execution.api.Component;
import de.rcenvironment.core.component.execution.api.ComponentContext;
import de.rcenvironment.core.datamodel.api.TypedDatum;
import de.rcenvironment.core.datamodel.types.api.FileReferenceTD;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.TempFileService;
import de.rcenvironment.core.utils.common.TempFileServiceAccess;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractBricsBehavior
implements BricsBehavior {
    protected ComponentContext compContext;
    protected TempFileService tempFileService;
    protected ComponentDataManagementService compDmService;
    protected BricsFacadeFactory bricsFacadeFactory;
    protected File bricsScratchDir;
    protected BricsComponentHistoryDataItem historyDataItem;

    @Override
    public void setComponentContext(ComponentContext componentContext) {
        this.compContext = componentContext;
        this.tempFileService = TempFileServiceAccess.getInstance();
        this.compDmService = (ComponentDataManagementService)componentContext.getService(ComponentDataManagementService.class);
        this.bricsFacadeFactory = (BricsFacadeFactory)this.compContext.getService(BricsFacadeFactory.class);
    }

    protected Map<String, String> createEnv(ComponentContext componentContext) throws ComponentException {
        this.bricsScratchDir = this.createTemporaryDir();
        return BricsEnvironment.createTaskEnvironment(this.compContext, this.bricsScratchDir.getAbsolutePath());
    }

    @Override
    public void start() throws ComponentException {
        for (Map.Entry<String, String> entry : this.getConfigKeyAndErrorMessages().entrySet()) {
            this.checkUserConfiguredValue(entry.getKey(), entry.getValue());
        }
    }

    protected abstract Map<String, String> getConfigKeyAndErrorMessages();

    protected void checkUserConfiguredValue(String configKey, String errorMessage) throws ComponentException {
        String configValue = this.compContext.getConfigurationValue(configKey);
        if (configValue == null || configValue.isEmpty()) {
            throw new ComponentException(errorMessage);
        }
    }

    @Override
    public void tearDown(Component.FinalComponentState state) {
        if (this.bricsScratchDir != null) {
            try {
                this.tempFileService.disposeManagedTempDirOrFile(this.bricsScratchDir);
            }
            catch (IOException iOException) {
                this.compContext.getLog().componentError("Failed to delete BRICS scratch directory: " + this.bricsScratchDir);
            }
        }
    }

    protected void initializeNewHistoryDataItem() {
        this.historyDataItem = new BricsComponentHistoryDataItem("de.rcenvironment.bricstask");
        this.historyDataItem.setTaskNameId(this.compContext.getConfigurationValue("task_name_id"));
        this.historyDataItem.setTeamsiteFolder(this.compContext.getConfigurationValue("teamsite_folder"));
        this.historyDataItem.setRecipient(this.compContext.getConfigurationValue("mail_to"));
    }

    protected void writeFinalHistoryDataItem() {
        this.compContext.writeFinalHistoryDataItem((ComponentHistoryDataItem)this.historyDataItem);
    }

    protected File createTemporaryDir() throws ComponentException {
        try {
            return this.tempFileService.createManagedTempDir();
        }
        catch (IOException e) {
            throw new ComponentException("Failed to create required temporary directory", (Throwable)e);
        }
    }

    protected void deleteTemporaryDir(File tempDir) {
        if (tempDir != null) {
            try {
                this.tempFileService.disposeManagedTempDirOrFile(tempDir);
            }
            catch (IOException e) {
                LogFactory.getLog(this.getClass()).error((Object)"Failed to delete temporary directory", (Throwable)e);
            }
        }
    }

    protected File createTemporaryDirWithIncomingFile() throws ComponentException {
        FileReferenceTD fileRef = (FileReferenceTD)this.compContext.readInput("CPACS");
        File fileDir = this.createTemporaryDir();
        try {
            this.compDmService.copyFileReferenceTDToLocalFile(this.compContext, fileRef, new File(fileDir, fileRef.getFileName()));
        }
        catch (IOException e) {
            throw new ComponentException("Failed to retrieve incoming CPACS file from data management", (Throwable)e);
        }
        return fileDir;
    }

    protected void fetchFileFromDirAndWriteToOutput(File fileDir) throws ComponentException {
        FileReferenceTD fileRef;
        Object[] files = fileDir.listFiles();
        if (files.length != 1) {
            throw new ComponentException(StringUtils.format((String)"Expected exactly one file to receive but got %d: %s", (Object[])new Object[]{files.length, Arrays.toString(files)}));
        }
        try {
            fileRef = this.compDmService.createFileReferenceTDFromLocalFile(this.compContext, files[0], files[0].getName());
        }
        catch (IOException e) {
            throw new ComponentException("Failed to store resulting CPACS file in data management", (Throwable)e);
        }
        this.compContext.writeOutput("CPACS", (TypedDatum)fileRef);
    }
}

