/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.brics.common.api;

import de.rcenvironment.core.component.datamanagement.api.CommonComponentHistoryDataItem;
import de.rcenvironment.core.datamodel.api.TypedDatumSerializer;
import de.rcenvironment.core.utils.common.JsonUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import java.io.IOException;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ObjectNode;

public class BricsComponentHistoryDataItem
extends CommonComponentHistoryDataItem {
    private static final long serialVersionUID = -5443884702114523764L;
    private static final String FORMAT_VERSION_1 = "1";
    private static final String CURRENT_FORMAT_VERSION = "1";
    private static final String TASK_MODE = "tm";
    private static final String TASK_NAME = "tn";
    private static final String TASK_ID = "ti";
    private static final String TEAMSITE_FOLDER = "tf";
    private static final String RECIPIENT = "r";
    private String taskMode;
    private String taskNameId;
    private String teamsiteFolder;
    private String recipient;
    private String identifier;

    public BricsComponentHistoryDataItem(String identifier) {
        this.identifier = identifier;
    }

    public String getFormatVersion() {
        return StringUtils.escapeAndConcat((String[])new String[]{super.getFormatVersion(), "1"});
    }

    public void setRecipient(String recipient) {
        this.recipient = recipient;
    }

    public String getRecipient() {
        return this.recipient;
    }

    public void setTaskNameId(String taskNameId) {
        this.taskNameId = taskNameId;
    }

    public String getTaskNameId() {
        return this.taskNameId;
    }

    public void setTeamsiteFolder(String teamsiteFolder) {
        this.teamsiteFolder = teamsiteFolder;
    }

    public String getTeamsiteFolder() {
        return this.teamsiteFolder;
    }

    public void setTaskMode(String taskMode) {
        this.taskMode = taskMode;
    }

    public String getTaskMode() {
        return this.taskMode;
    }

    public String serialize(TypedDatumSerializer serializer) throws IOException {
        JsonNode rootNode;
        String data = super.serialize(serializer);
        ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
        try {
            rootNode = mapper.readTree(data);
        }
        catch (JsonProcessingException e) {
            throw new IOException(e);
        }
        ((ObjectNode)rootNode).put(TASK_MODE, this.taskMode);
        ((ObjectNode)rootNode).put(TEAMSITE_FOLDER, this.teamsiteFolder);
        ((ObjectNode)rootNode).put(TASK_ID, this.taskNameId);
        if (this.recipient != null) {
            ((ObjectNode)rootNode).put(RECIPIENT, this.recipient);
        }
        return rootNode.toString();
    }

    public static BricsComponentHistoryDataItem fromString(String historyData, TypedDatumSerializer serializer, String identifier) throws IOException {
        BricsComponentHistoryDataItem historyDataItem = new BricsComponentHistoryDataItem(identifier);
        CommonComponentHistoryDataItem.initializeCommonHistoryDataFromString((CommonComponentHistoryDataItem)historyDataItem, (String)historyData, (TypedDatumSerializer)serializer);
        BricsComponentHistoryDataItem.readReferenceFromString(historyData, historyDataItem);
        return historyDataItem;
    }

    private static void readReferenceFromString(String historyData, BricsComponentHistoryDataItem historyDataItem) throws IOException {
        ObjectNode rootNode;
        ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
        try {
            rootNode = (ObjectNode)mapper.readTree(historyData);
        }
        catch (JsonProcessingException e) {
            throw new IOException(e);
        }
        historyDataItem.taskMode = rootNode.get(TASK_MODE).getTextValue();
        historyDataItem.teamsiteFolder = rootNode.get(TEAMSITE_FOLDER).getTextValue();
        historyDataItem.taskNameId = rootNode.get(TASK_NAME).getTextValue();
        if (rootNode.has(RECIPIENT)) {
            historyDataItem.recipient = rootNode.get(RECIPIENT).getTextValue();
        }
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }
}

