/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.brics.execution.api;

import de.rcenvironment.components.brics.execution.behavior.impl.BricsBehavior;
import de.rcenvironment.components.brics.execution.behavior.impl.BricsMultiDownloadUploadBehavior;
import de.rcenvironment.components.brics.execution.behavior.impl.BricsMultiTaskBehavior;
import de.rcenvironment.components.brics.execution.behavior.impl.BricsSingleDownloadUploadBehavior;
import de.rcenvironment.components.brics.execution.behavior.impl.BricsSingleTaskBehavior;
import de.rcenvironment.core.component.api.ComponentException;
import de.rcenvironment.core.component.execution.api.Component;
import de.rcenvironment.core.component.execution.api.ComponentContext;
import de.rcenvironment.core.component.execution.api.ThreadHandler;
import de.rcenvironment.core.component.model.spi.DefaultComponent;
import org.apache.commons.logging.LogFactory;

public class BricsComponent
extends DefaultComponent {
    private static final String ERROR_MESSAGE = "Internal developer error: no behavior for brics component defined: ";
    private BricsBehavior bricsBehavior;

    public boolean treatStartAsComponentRun() {
        return this.bricsBehavior.treatStartAsComponentRun();
    }

    public void setComponentContext(ComponentContext compContext) {
        this.bricsBehavior = this.createBricsTaskBehavior(compContext);
        this.bricsBehavior.setComponentContext(compContext);
    }

    protected BricsBehavior createBricsTaskBehavior(ComponentContext compContext) {
        String compId = compContext.getComponentIdentifier();
        String multiTaskMode = compContext.getConfigurationValue("task_mode_multi");
        if (multiTaskMode != null && multiTaskMode.equals(String.valueOf(true))) {
            if (compId.contains("de.rcenvironment.bricstask")) {
                return new BricsMultiTaskBehavior();
            }
            if (compId.contains("de.rcenvironment.bricsdu")) {
                return new BricsMultiDownloadUploadBehavior();
            }
            throw new IllegalStateException(ERROR_MESSAGE + compId);
        }
        String singleTaskMode = compContext.getConfigurationValue("task_mode_single");
        if (singleTaskMode == null || singleTaskMode.equals(String.valueOf(false))) {
            LogFactory.getLog(((Object)((Object)this)).getClass()).warn((Object)"No task mode defined, use default: single");
        }
        if (compId.contains("de.rcenvironment.bricstask")) {
            return new BricsSingleTaskBehavior();
        }
        if (compId.contains("de.rcenvironment.bricsdu")) {
            return new BricsSingleDownloadUploadBehavior();
        }
        throw new IllegalStateException(ERROR_MESSAGE + compId);
    }

    public void start() throws ComponentException {
        this.bricsBehavior.start();
    }

    public void processInputs() throws ComponentException {
        this.bricsBehavior.processInputs();
    }

    public void tearDown(Component.FinalComponentState state) {
        if (this.bricsBehavior != null) {
            this.bricsBehavior.tearDown(state);
        } else if (state.equals((Object)Component.FinalComponentState.FINISHED)) {
            LogFactory.getLog(((Object)((Object)this)).getClass()).warn((Object)"Internal warning: 'bricsBehavior' not expected to be null");
        }
    }

    public void onStartInterrupted(ThreadHandler executingThreadHandler) {
        executingThreadHandler.interrupt();
    }

    public void onProcessInputsInterrupted(ThreadHandler executingThreadHandler) {
        executingThreadHandler.interrupt();
    }
}

