/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.testutils;

import de.rcenvironment.core.communication.common.LogicalNodeId;
import de.rcenvironment.core.communication.common.NodeIdentifierTestUtils;
import de.rcenvironment.core.component.datamanagement.api.ComponentHistoryDataItem;
import de.rcenvironment.core.component.testutils.ComponentContextDefaultStub;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.EndpointCharacter;
import de.rcenvironment.core.datamodel.api.TypedDatum;
import de.rcenvironment.core.datamodel.api.TypedDatumService;
import de.rcenvironment.core.datamodel.testutils.TypedDatumServiceDefaultStub;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.toolkit.utils.common.AutoCreationMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ComponentContextMock
extends ComponentContextDefaultStub {
    private static final long serialVersionUID = -8621047700219054161L;
    private final Map<String, String> testConfig = new HashMap<String, String>();
    private final Map<String, SimulatedEndpoint> simulatedInputs = new HashMap<String, SimulatedEndpoint>();
    private final Map<String, SimulatedEndpoint> simulatedOutputs = new HashMap<String, SimulatedEndpoint>();
    private Map<String, TypedDatum> inputValues;
    private AutoCreationMap<String, List<TypedDatum>> capturedOutputValues;
    private List<String> capturedOutputClosings;
    private boolean resetOutputsCalled;
    private final TypedDatumService typedDatumService;
    private final Map<Class<?>, Object> services = new HashMap();
    private int executionCount;
    private final LogicalNodeId node = NodeIdentifierTestUtils.createTestInstanceNodeSessionIdWithDisplayName((String)"ComponentContextMock").convertToDefaultLogicalNodeId();
    private ComponentHistoryDataItem historyDataItem;
    private Set<String> inputsNotConnected = new HashSet<String>();

    public ComponentContextMock() {
        this.typedDatumService = new TypedDatumServiceDefaultStub();
        this.services.put(TypedDatumService.class, this.typedDatumService);
        this.resetInputData();
        this.resetOutputData();
    }

    public <T> void addService(Class<T> clazz, Object serviceStub) {
        this.services.put(clazz, serviceStub);
    }

    @Override
    public <T> T getService(Class<T> clazz) {
        return (T)this.services.get(clazz);
    }

    @Override
    public LogicalNodeId getNodeId() {
        return this.node;
    }

    @Override
    public String getConfigurationValue(String key) {
        return this.testConfig.get(key);
    }

    @Override
    public Set<String> getConfigurationKeys() {
        return this.testConfig.keySet();
    }

    @Override
    public Set<String> getInputs() {
        return new HashSet<String>(this.simulatedInputs.keySet());
    }

    @Override
    public Set<String> getOutputs() {
        return new HashSet<String>(this.simulatedOutputs.keySet());
    }

    @Override
    public void closeAllOutputs() {
        for (String outputName : this.simulatedOutputs.keySet()) {
            this.capturedOutputClosings.add(outputName);
        }
    }

    @Override
    public void closeOutput(String outputName) {
        this.capturedOutputClosings.add(outputName);
    }

    @Override
    public void resetOutputs() {
        this.resetOutputsCalled = true;
    }

    @Override
    public Set<String> getInputsWithDatum() {
        return new HashSet<String>(this.inputValues.keySet());
    }

    @Override
    public DataType getInputDataType(String inputName) {
        return this.simulatedInputs.get(inputName).getDataType();
    }

    @Override
    public DataType getOutputDataType(String outputName) {
        return this.simulatedOutputs.get(outputName).getDataType();
    }

    @Override
    public String getOutputMetaDataValue(String outputName, String metaDataKey) {
        return (String)this.simulatedOutputs.get(outputName).getMetaData().get(metaDataKey);
    }

    @Override
    public String getInputMetaDataValue(String inputName, String metaDataKey) {
        return (String)this.simulatedInputs.get(inputName).getMetaData().get(metaDataKey);
    }

    @Override
    public void writeOutput(String outputName, TypedDatum value) {
        if (this.simulatedOutputs.get(outputName) == null) {
            throw new RuntimeException(StringUtils.format((String)"Output \"%s\" is not defined.", (Object[])new Object[]{outputName}));
        }
        if (value.getDataType() != this.simulatedOutputs.get(outputName).getDataType() && !value.getDataType().equals((Object)DataType.NotAValue) && !this.typedDatumService.getConverter().isConvertibleTo(value, this.simulatedOutputs.get(outputName).getDataType())) {
            throw new RuntimeException(StringUtils.format((String)"DataType %s of given value not convertible to defined output DataType %s", (Object[])new Object[]{value.getDataType(), this.simulatedOutputs.get(outputName).getDataType()}));
        }
        ((List)this.capturedOutputValues.get((Object)outputName)).add(value);
    }

    @Override
    public boolean isDynamicInput(String inputName) {
        return this.simulatedInputs.get(inputName).isDynamic();
    }

    @Override
    public String getDynamicOutputIdentifier(String outputName) {
        return this.simulatedOutputs.get(outputName).getEndpointId();
    }

    @Override
    public String getDynamicInputIdentifier(String inputName) {
        return this.simulatedInputs.get(inputName).getEndpointId();
    }

    @Override
    public TypedDatum readInput(String key) {
        return this.inputValues.get(key);
    }

    @Override
    public int getExecutionCount() {
        return this.executionCount;
    }

    public void setConfigurationValue(String key, String value) {
        this.testConfig.put(key, value);
    }

    public void addSimulatedInput(String name, String endpointId, DataType dataType, boolean isDynamic, Map<String, String> metaData) {
        this.simulatedInputs.put(name, new SimulatedEndpoint(endpointId, dataType, isDynamic, metaData, EndpointCharacter.SAME_LOOP));
    }

    public void addSimulatedInput(String name, String endpointId, DataType dataType, boolean isDynamic, Map<String, String> metaData, EndpointCharacter inputCharacter) {
        this.simulatedInputs.put(name, new SimulatedEndpoint(endpointId, dataType, isDynamic, metaData, inputCharacter));
    }

    public void addSimulatedOutput(String name, String endpointId, DataType dataType, boolean isDynamic, Map<String, String> metaData) {
        this.simulatedOutputs.put(name, new SimulatedEndpoint(endpointId, dataType, isDynamic, metaData, EndpointCharacter.SAME_LOOP));
    }

    public void addSimulatedOutput(String name, String endpointId, DataType dataType, boolean isDynamic, Map<String, String> metaData, EndpointCharacter outputCharacter) {
        this.simulatedOutputs.put(name, new SimulatedEndpoint(endpointId, dataType, isDynamic, metaData, outputCharacter));
    }

    @Deprecated
    public void resetEndpointData() {
        this.resetInputData();
        this.resetOutputData();
    }

    public void setInputValue(String inputName, TypedDatum datum) {
        this.inputValues.put(inputName, datum);
    }

    public List<TypedDatum> getCapturedOutput(String outputName) {
        return (List)this.capturedOutputValues.get((Object)outputName);
    }

    public List<String> getCapturedOutputClosings() {
        return this.capturedOutputClosings;
    }

    public boolean isResetOutputsCalled() {
        return this.resetOutputsCalled;
    }

    protected void resetInputData() {
        this.inputValues = new HashMap<String, TypedDatum>();
    }

    protected void resetOutputData() {
        this.capturedOutputValues = new OutputCaptureMap();
    }

    protected void resetOutputClosings() {
        this.capturedOutputClosings = new ArrayList<String>();
    }

    protected void resetOutputResets() {
        this.resetOutputsCalled = false;
    }

    protected void incrementExecutionCount() {
        ++this.executionCount;
    }

    @Override
    public void writeFinalHistoryDataItem(ComponentHistoryDataItem newHistoryDataItem) {
        this.historyDataItem = newHistoryDataItem;
    }

    public ComponentHistoryDataItem getHistoryDataItem() {
        return this.historyDataItem;
    }

    @Override
    public boolean isDynamicOutput(String outputName) {
        return this.simulatedOutputs.get(outputName).isDynamic();
    }

    @Override
    public Set<String> getInputsNotConnected() {
        return this.inputsNotConnected;
    }

    @Override
    public EndpointCharacter getInputCharacter(String inputName) {
        return this.simulatedInputs.get(inputName).getEndpointCharacter();
    }

    @Override
    public EndpointCharacter getOutputCharacter(String outputName) {
        return this.simulatedOutputs.get(outputName).getEndpointCharacter();
    }

    public void addInputNotConnected(String name) {
        this.inputsNotConnected.add(name);
    }

    @Override
    public List<String> getDynamicInputsWithIdentifier(String identifier) {
        LinkedList<String> result = new LinkedList<String>();
        for (String endpoint : this.simulatedInputs.keySet()) {
            if (!this.isDynamicInput(endpoint) || !this.getDynamicInputIdentifier(endpoint).equals(identifier)) continue;
            result.add(endpoint);
        }
        return result;
    }

    private final class OutputCaptureMap
    extends AutoCreationMap<String, List<TypedDatum>> {
        private OutputCaptureMap() {
        }

        protected List<TypedDatum> createNewEntry(String key) {
            return new ArrayList<TypedDatum>();
        }
    }

    private final class SimulatedEndpoint {
        private final String endpointId;
        private final DataType dataType;
        private final boolean isDynamic;
        private final Map<String, String> metaData;
        private final EndpointCharacter endpointCharacter;

        SimulatedEndpoint(String endpointId, DataType dataType, boolean isDynamic, Map<String, String> metaData, EndpointCharacter endpointCharacter) {
            this.endpointId = endpointId;
            this.dataType = dataType;
            this.isDynamic = isDynamic;
            this.metaData = metaData != null ? metaData : new HashMap<String, String>();
            this.endpointCharacter = endpointCharacter;
        }

        private String getEndpointId() {
            return this.endpointId;
        }

        private DataType getDataType() {
            return this.dataType;
        }

        private boolean isDynamic() {
            return this.isDynamic;
        }

        private Map<String, String> getMetaData() {
            return this.metaData;
        }

        private EndpointCharacter getEndpointCharacter() {
            return this.endpointCharacter;
        }
    }
}

