/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.wizards.toolintegration;

import de.rcenvironment.core.component.integration.ToolIntegrationContext;
import de.rcenvironment.core.gui.utils.incubator.NumericalTextConstraintListener;
import de.rcenvironment.core.gui.wizards.toolintegration.Messages;
import de.rcenvironment.core.gui.wizards.toolintegration.PathChooserButtonListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class WizardToolConfigurationDialog
extends Dialog {
    private Text toolDirectoryText;
    private final Map<String, String> config;
    private final String title;
    private Text versionText;
    private Text rootWorkingDirText;
    private Button chooseToolDirPathButton;
    private Button chooseRootDirPathButton;
    private Button defaultTempDirButton;
    private final List<Map<String, String>> allConfigs;
    private Map<String, String> oldConfig;
    private boolean isEdit;
    private final ToolIntegrationContext context;
    private Button limitInstancesButton;
    private Text limitInstancesText;

    public WizardToolConfigurationDialog(Shell parentShell, String title, List<Map<String, String>> configs, ToolIntegrationContext context) {
        super(parentShell);
        this.config = new HashMap<String, String>();
        this.config.put("limitInstallationInstances", "true");
        this.config.put("limitInstallationInstancesNumber", "10");
        this.title = title;
        this.allConfigs = configs;
        this.context = context;
        this.setShellStyle(66576);
    }

    public WizardToolConfigurationDialog(Shell parentShell, String title, Map<String, String> config, List<Map<String, String>> configs, ToolIntegrationContext context, boolean isEdit) {
        super(parentShell);
        this.config = config;
        this.oldConfig = new HashMap<String, String>();
        this.oldConfig.putAll(config);
        this.title = title;
        this.allConfigs = configs;
        this.isEdit = isEdit;
        this.context = context;
        if (config.get("limitInstallationInstances") == null && config.get("limitInstalltionInstances") == null) {
            config.put("limitInstallationInstances", "false");
            config.put("limitInstallationInstancesNumber", "10");
        }
        this.setShellStyle(66576);
    }

    protected Point getInitialSize() {
        return new Point(600, 300);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new GridLayout(1, true));
        GridData g = new GridData(1808);
        container.setLayoutData((Object)g);
        this.createPropertySettings(container);
        this.updateInitValues();
        return container;
    }

    private void updateInitValues() {
        String rwd;
        if (this.config.get("host") != null) {
            this.config.get("host");
        }
        if (this.config.get("toolDirectory") != null) {
            this.toolDirectoryText.setText(this.config.get("toolDirectory"));
        }
        if (this.config.get("version") != null) {
            this.versionText.setText(this.config.get("version"));
        }
        if ((rwd = this.config.get("rootWorkingDirectory")) == null) {
            this.defaultTempDirButton.setSelection(false);
            this.rootWorkingDirText.setEnabled(true);
            this.chooseRootDirPathButton.setEnabled(true);
        } else if (rwd.isEmpty()) {
            this.defaultTempDirButton.setSelection(true);
            this.rootWorkingDirText.setEnabled(false);
            this.chooseRootDirPathButton.setEnabled(false);
        } else {
            this.defaultTempDirButton.setSelection(false);
            this.rootWorkingDirText.setEnabled(true);
            this.rootWorkingDirText.setText(this.config.get("rootWorkingDirectory"));
            this.chooseRootDirPathButton.setEnabled(true);
        }
        String[] stringArray = this.context.getDisabledIntegrationKeys();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            if ("rootWorkingDirectory".equals(key)) {
                this.rootWorkingDirText.setEnabled(false);
                this.defaultTempDirButton.setEnabled(false);
                this.chooseRootDirPathButton.setEnabled(false);
            }
            ++n2;
        }
        if (this.config.get("limitInstallationInstances") != null) {
            this.setInstanceLimit("limitInstallationInstances");
        } else if (this.config.get("limitInstalltionInstances") != null) {
            this.setInstanceLimit("limitInstalltionInstances");
        } else {
            this.limitInstancesButton.setSelection(false);
            this.limitInstancesText.setText("");
        }
    }

    private void setInstanceLimit(String key) {
        if (Boolean.parseBoolean(this.config.get(key))) {
            this.limitInstancesButton.setSelection(true);
            this.limitInstancesText.setEnabled(true);
            this.limitInstancesText.setText(this.config.get("limitInstallationInstancesNumber"));
        } else {
            this.limitInstancesButton.setSelection(false);
            this.limitInstancesText.setEnabled(false);
            this.limitInstancesText.setText("");
        }
    }

    protected void createPropertySettings(Composite parent) {
        Composite container2 = new Composite(parent, 0);
        container2.setLayout((Layout)new GridLayout(1, false));
        GridData g2 = new GridData(4, 4, true, true);
        container2.setLayoutData((Object)g2);
        Composite propertyContainer = new Composite(container2, 0);
        propertyContainer.setLayout((Layout)new GridLayout(3, false));
        GridData g3 = new GridData(4, 4, true, true);
        propertyContainer.setLayoutData((Object)g3);
        Label toolDirLabel = new Label(propertyContainer, 0);
        toolDirLabel.setText(Messages.toolDirectoryRequired);
        this.toolDirectoryText = new Text(propertyContainer, 2048);
        GridData toolDirGridData = new GridData(768);
        this.toolDirectoryText.setLayoutData((Object)toolDirGridData);
        this.chooseToolDirPathButton = new Button(propertyContainer, 8);
        this.chooseToolDirPathButton.setText("  ...  ");
        this.chooseToolDirPathButton.addSelectionListener((SelectionListener)new PathChooserButtonListener(this.toolDirectoryText, true, this.getShell()));
        Label versionLabel = new Label(propertyContainer, 0);
        versionLabel.setText(Messages.versionRequired);
        this.versionText = new Text(propertyContainer, 2048);
        GridData versionGridData = new GridData(768);
        versionGridData.horizontalSpan = 2;
        this.versionText.setLayoutData((Object)versionGridData);
        Label workingDirLabel = new Label(propertyContainer, 0);
        workingDirLabel.setText("Working directory (absolute): ");
        this.rootWorkingDirText = new Text(propertyContainer, 2048);
        GridData rootWorkingDirGridData = new GridData(768);
        this.rootWorkingDirText.setLayoutData((Object)rootWorkingDirGridData);
        this.chooseRootDirPathButton = new Button(propertyContainer, 8);
        this.chooseRootDirPathButton.setText("  ...  ");
        this.chooseRootDirPathButton.addSelectionListener((SelectionListener)new PathChooserButtonListener(this.rootWorkingDirText, true, this.getShell()));
        new Label(propertyContainer, 0);
        this.defaultTempDirButton = new Button(propertyContainer, 32);
        GridData defaultTempDirData = new GridData(768);
        defaultTempDirData.horizontalSpan = 2;
        this.defaultTempDirButton.setText(Messages.rceTempUsed);
        this.defaultTempDirButton.setLayoutData((Object)defaultTempDirData);
        this.defaultTempDirButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                WizardToolConfigurationDialog.this.saveAllConfig();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
        this.limitInstancesButton = new Button(propertyContainer, 32);
        this.limitInstancesButton.setText(Messages.limitExecutionInstances);
        this.limitInstancesText = new Text(propertyContainer, 2048);
        GridData limitInstancesGridData = new GridData(768);
        limitInstancesGridData.horizontalSpan = 2;
        this.limitInstancesText.setLayoutData((Object)limitInstancesGridData);
        this.limitInstancesText.addVerifyListener((VerifyListener)new NumericalTextConstraintListener(this.limitInstancesText, 18));
        this.limitInstancesButton.setSelection(true);
        this.limitInstancesButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                WizardToolConfigurationDialog.this.limitInstancesText.setEnabled(WizardToolConfigurationDialog.this.limitInstancesButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
    }

    protected void initializeBounds() {
        super.initializeBounds();
    }

    private void saveAllConfig() {
        this.config.put("host", "RCE");
        this.config.put("toolDirectory", this.toolDirectoryText.getText());
        this.config.put("version", this.versionText.getText());
        this.config.put("limitInstallationInstances", "" + this.limitInstancesButton.getSelection());
        if (this.limitInstancesButton.getSelection()) {
            this.config.put("limitInstallationInstancesNumber", this.limitInstancesText.getText());
        }
        this.config.remove("limitInstalltionInstances");
        if (this.defaultTempDirButton.getSelection()) {
            this.config.put("rootWorkingDirectory", "");
        } else {
            this.config.put("rootWorkingDirectory", this.rootWorkingDirText.getText());
        }
    }

    public void create() {
        super.create();
        this.getShell().setText(this.title);
        this.validateInput();
        this.installListeners();
    }

    private void installListeners() {
        ModifyListener ml = new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                WizardToolConfigurationDialog.this.saveAllConfig();
                WizardToolConfigurationDialog.this.validateInput();
            }
        };
        this.rootWorkingDirText.addModifyListener(ml);
        this.versionText.addModifyListener(ml);
        this.toolDirectoryText.addModifyListener(ml);
        this.limitInstancesText.addModifyListener(ml);
        this.limitInstancesButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                WizardToolConfigurationDialog.this.saveAllConfig();
                WizardToolConfigurationDialog.this.validateInput();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
        new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                WizardToolConfigurationDialog.this.validateInput();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        };
        SelectionListener sl2 = new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                WizardToolConfigurationDialog.this.rootWorkingDirText.setEnabled(!WizardToolConfigurationDialog.this.defaultTempDirButton.getSelection());
                WizardToolConfigurationDialog.this.chooseRootDirPathButton.setEnabled(!WizardToolConfigurationDialog.this.defaultTempDirButton.getSelection());
                WizardToolConfigurationDialog.this.validateInput();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        };
        this.defaultTempDirButton.addSelectionListener(sl2);
    }

    protected void validateInput() {
        boolean isValid = true;
        if (this.toolDirectoryText.getText() == null || this.toolDirectoryText.getText().trim().isEmpty()) {
            isValid = false;
        }
        if (this.limitInstancesButton.getSelection() && (this.limitInstancesText.getText().trim().isEmpty() || !this.limitInstancesText.getText().matches("\\d+"))) {
            isValid = false;
        }
        if (this.versionText.getText() == null || this.versionText.getText().trim().isEmpty()) {
            isValid = false;
        }
        if (!(!isValid || this.isEdit && this.oldConfig.get("toolDirectory").equals(this.toolDirectoryText.getText()))) {
            for (Map<String, String> otherConfig : this.allConfigs) {
                if (!otherConfig.get("toolDirectory").equals(this.toolDirectoryText.getText())) continue;
                isValid = false;
            }
        }
        if (!(this.defaultTempDirButton.getSelection() || this.rootWorkingDirText.getText() != null && !this.rootWorkingDirText.getText().trim().isEmpty() && FileUtils.getFile((String[])new String[]{this.rootWorkingDirText.getText()}).isAbsolute())) {
            isValid = false;
        }
        this.getButton(0).setEnabled(isValid);
    }

    public Map<String, String> getConfig() {
        return this.config;
    }
}

