/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.wizards.toolintegration;

import de.rcenvironment.core.gui.wizards.toolintegration.Messages;
import de.rcenvironment.core.gui.wizards.toolintegration.ToolIntegrationWizard;
import de.rcenvironment.core.utils.common.StringUtils;
import java.util.Map;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class ToolIntegrationWizardDialog
extends WizardDialog {
    private static final Object LOCK_OBJECT = new Object();
    protected Button backButton;
    protected Button nextButton;
    protected Button finishButton;
    protected Button cancelButton;
    protected Button saveAsButton;
    private final boolean isEdit;

    public ToolIntegrationWizardDialog(Shell parentShell, IWizard newWizard, boolean isEdit) {
        super(parentShell, newWizard);
        this.setShellStyle(0xC70 | ToolIntegrationWizardDialog.getDefaultOrientation());
        this.isEdit = isEdit;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        ((GridLayout)parent.getLayout()).makeColumnsEqualWidth = false;
        if (this.getWizard().isHelpAvailable()) {
            this.createButton(parent, 17, IDialogConstants.HELP_LABEL, false);
        }
        if (this.getWizard().needsPreviousAndNextButtons()) {
            this.backButton = this.createButton(parent, 14, IDialogConstants.BACK_LABEL, true);
            this.nextButton = this.createButton(parent, 15, IDialogConstants.NEXT_LABEL, true);
        }
        this.saveAsButton = this.createButton(parent, 11, Messages.saveAsLabel, false);
        String buttonText = Messages.integrateLabel;
        if (this.isEdit) {
            buttonText = Messages.updateLabel;
        }
        this.finishButton = this.createButton(parent, 16, buttonText, true);
        this.cancelButton = this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, true);
    }

    public void updateButtons() {
        boolean canFlipToNextPage = false;
        boolean canFinish = true;
        IWizardPage[] iWizardPageArray = this.getWizard().getPages();
        int n = iWizardPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage p = iWizardPageArray[n2];
            canFinish &= p.isPageComplete();
            ++n2;
        }
        if (this.backButton != null) {
            this.backButton.setEnabled(this.getCurrentPage().getPreviousPage() != null);
        }
        if (this.nextButton != null) {
            canFlipToNextPage = this.getCurrentPage().canFlipToNextPage();
            this.nextButton.setEnabled(canFlipToNextPage);
            this.saveAsButton.setEnabled(canFlipToNextPage);
        }
        this.finishButton.setEnabled(canFinish);
        this.saveAsButton.setEnabled(canFinish);
        if (canFlipToNextPage && !canFinish) {
            this.getShell().setDefaultButton(this.nextButton);
        } else {
            this.getShell().setDefaultButton(this.finishButton);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 17: {
                this.helpPressed();
                break;
            }
            case 14: {
                this.backPressed();
                break;
            }
            case 15: {
                this.nextPressed();
                break;
            }
            case 16: {
                if (!this.isEdit) {
                    this.finishPressed();
                    if (!((ToolIntegrationWizard)this.getWizard()).isConfigOK() || this.getParentShell() == null) break;
                    MessageBox infoDialog = new MessageBox(this.getParentShell(), 34);
                    infoDialog.setText("Tool integrated");
                    Map<String, Object> configurationMap = ((ToolIntegrationWizard)this.getWizard()).getConfigurationMap();
                    String groupName = (String)configurationMap.get("groupName");
                    if (groupName == null || groupName.isEmpty()) {
                        groupName = "User Integrated Tools";
                    }
                    infoDialog.setMessage(StringUtils.format((String)"Tool \"%s\" was successfully integrated to group \"%s\".", (Object[])new Object[]{configurationMap.get("toolName"), groupName}));
                    infoDialog.open();
                    break;
                }
                Object infoDialog = LOCK_OBJECT;
                synchronized (infoDialog) {
                    ((ToolIntegrationWizard)this.getWizard()).removeOldIntegration();
                    this.finishPressed();
                    if (((ToolIntegrationWizard)this.getWizard()).isConfigOK() && this.getParentShell() != null) {
                        MessageBox infoDialog2 = new MessageBox(this.getParentShell(), 34);
                        infoDialog2.setText("Tool updated");
                        infoDialog2.setMessage(StringUtils.format((String)"Tool \"%s\" was successfully updated.", (Object[])new Object[]{((ToolIntegrationWizard)this.getWizard()).getConfigurationMap().get("toolName")}));
                        infoDialog2.open();
                    }
                    break;
                }
            }
            case 11: {
                DirectoryDialog dialog = new DirectoryDialog(this.getShell());
                String folder = dialog.open();
                if (folder == null) break;
                ((ToolIntegrationWizard)this.getWizard()).performSaveAs(folder);
                break;
            }
            case 1: {
                this.cancelPressed();
            }
        }
    }

    public int open() {
        int returnValue = super.open();
        ((ToolIntegrationWizard)this.getWizard()).open();
        return returnValue;
    }
}

