/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.wizards.toolintegration;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.rcenvironment.core.component.integration.ToolIntegrationConstants;
import de.rcenvironment.core.component.integration.ToolIntegrationContext;
import de.rcenvironment.core.component.integration.ToolIntegrationContextRegistry;
import de.rcenvironment.core.component.integration.ToolIntegrationService;
import de.rcenvironment.core.gui.wizards.toolintegration.RemoveToolIntegrationDialog;
import de.rcenvironment.core.utils.common.JsonUtils;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import de.rcenvironment.core.utils.incubator.ServiceRegistryAccess;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;

public class ShowIntegrationRemoveHandler
extends AbstractHandler {
    private static final Log LOGGER = LogFactory.getLog(ShowIntegrationRemoveHandler.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ServiceRegistryAccess serviceRegistryAccess = ServiceRegistry.createAccessFor((Object)((Object)this));
        ToolIntegrationService integrationService = (ToolIntegrationService)serviceRegistryAccess.getService(ToolIntegrationService.class);
        ToolIntegrationContextRegistry registry = (ToolIntegrationContextRegistry)serviceRegistryAccess.getService(ToolIntegrationContextRegistry.class);
        RemoveToolIntegrationDialog dialog = new RemoveToolIntegrationDialog(null, integrationService.getActiveComponentIds(), registry.getAllIntegrationContexts());
        if (dialog.open() == 0) {
            integrationService.setFileWatcherActive(false);
            String[] stringArray = dialog.getSelectedTools();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String selectedTool = stringArray[n2];
                Map configuration = integrationService.getToolConfiguration(selectedTool);
                ToolIntegrationContext context = null;
                if (configuration != null) {
                    if (configuration.get("integrationType") == null) {
                        context = registry.getToolIntegrationContext(ToolIntegrationConstants.COMMON_TOOL_INTEGRATION_CONTEXT_UID);
                    } else {
                        for (ToolIntegrationContext currContext : registry.getAllIntegrationContexts()) {
                            if (!currContext.getContextType().equals(configuration.get("integrationType"))) continue;
                            context = currContext;
                        }
                    }
                    if (context != null) {
                        String toolname = selectedTool.substring(context.getPrefixForComponentId().length());
                        integrationService.unregisterIntegration(toolname, context);
                        integrationService.removeTool(selectedTool, context);
                        integrationService.unpublishTool(String.valueOf(context.getRootPathToToolIntegrationDirectory()) + File.separator + context.getNameOfToolIntegrationDirectory() + File.separator + context.getToolDirectoryPrefix() + selectedTool);
                        integrationService.updatePublishedComponents(context);
                        File remove = new File(integrationService.getPathOfComponentID(selectedTool, context));
                        this.removeOrDeactive(integrationService, dialog, context, remove);
                    } else {
                        LOGGER.error((Object)"ToolintegrationContext is null.");
                    }
                }
                ++n2;
            }
        }
        integrationService.setFileWatcherActive(true);
        return null;
    }

    private void removeOrDeactive(ToolIntegrationService integrationService, RemoveToolIntegrationDialog dialog, ToolIntegrationContext context, File remove) {
        if (!dialog.getKeepOnDisk()) {
            if (remove.exists() && remove.canWrite()) {
                try {
                    FileUtils.forceDelete((File)remove);
                }
                catch (IOException e) {
                    LOGGER.error((Object)"Could not delete tool directory: ", (Throwable)e);
                }
            }
        } else if (remove.exists()) {
            ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
            try {
                Map configurationMap = (Map)mapper.readValue(new File(remove, context.getConfigurationFilename()), new HashMap().getClass());
                configurationMap.put("isActive", false);
                integrationService.writeToolIntegrationFile(configurationMap, context);
            }
            catch (IOException e) {
                LOGGER.error((Object)("Failed to set tool inactive ( " + remove + "): "), (Throwable)e);
            }
        }
    }
}

