/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.workflow.model.api;

import de.rcenvironment.core.communication.common.LogicalNodeId;
import de.rcenvironment.core.component.model.api.ComponentDescription;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.component.model.spi.PropertiesChangeSupport;
import de.rcenvironment.core.component.workflow.execution.api.EndpointChangeListener;
import de.rcenvironment.core.component.workflow.model.api.Connection;
import de.rcenvironment.core.component.workflow.model.api.WorkflowLabel;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.utils.common.StringUtils;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.logging.LogFactory;

public class WorkflowDescription
extends PropertiesChangeSupport
implements Serializable,
Cloneable {
    public static final String PROPERTY_NODES_OR_CONNECTIONS = "de.rcenvironment.wf.n_cn";
    public static final String PROPERTY_NODES = "e.rcenvironment.wf.n";
    public static final String PROPERTY_CONNECTIONS = "e.rcenvironment.wf.cn";
    public static final String PROPERTY_LABEL = "e.rcenvironment.wf.l";
    protected static final int MINUS_ONE = -1;
    private static final long serialVersionUID = 339866937554580256L;
    private final String identifier;
    private int workflowVersionNumber = 0;
    private String name;
    private String fileName;
    private String additionalInformation;
    private LogicalNodeId controllerNode;
    private boolean isControllerNodeIdTransient = false;
    private final List<WorkflowNode> nodes = new ArrayList<WorkflowNode>();
    private final List<Connection> connections = new ArrayList<Connection>();
    private List<WorkflowLabel> labels = new ArrayList<WorkflowLabel>();

    public WorkflowDescription(String identifier) {
        this.identifier = identifier;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public int getWorkflowVersion() {
        return this.workflowVersionNumber;
    }

    public void setWorkflowVersion(Integer workflowVersion) {
        this.workflowVersionNumber = workflowVersion;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getAdditionalInformation() {
        return this.additionalInformation;
    }

    public void setAdditionalInformation(String additionalInformation) {
        this.additionalInformation = additionalInformation;
    }

    public LogicalNodeId getControllerNode() {
        return this.controllerNode;
    }

    public void setControllerNode(LogicalNodeId logicalNodeId) {
        this.controllerNode = logicalNodeId;
    }

    public boolean getIsControllerNodeIdTransient() {
        return this.isControllerNodeIdTransient;
    }

    public void setIsControllerNodeIdTransient(boolean isControllerNodeIdTransient) {
        this.isControllerNodeIdTransient = isControllerNodeIdTransient;
    }

    public List<WorkflowNode> getWorkflowNodes() {
        return new ArrayList<WorkflowNode>(this.nodes);
    }

    public void sortWorkflowNodesByZIndex() {
        Collections.sort(this.nodes, new Comparator<WorkflowNode>(){

            @Override
            public int compare(WorkflowNode arg0, WorkflowNode arg1) {
                if (arg0.getZIndex() == -1) {
                    return 1;
                }
                if (arg0.getZIndex() < arg1.getZIndex()) {
                    return -1;
                }
                if (arg0.getZIndex() > arg1.getZIndex()) {
                    return 1;
                }
                return 0;
            }
        });
        int i = 0;
        while (i < this.nodes.size()) {
            this.nodes.get(i).setZIndex(i);
            ++i;
        }
    }

    public List<WorkflowLabel> getWorkflowLabels() {
        return new ArrayList<WorkflowLabel>(this.labels);
    }

    public void sortWorkflowLabelsByZIndex() {
        Collections.sort(this.labels, new Comparator<WorkflowLabel>(){

            @Override
            public int compare(WorkflowLabel arg0, WorkflowLabel arg1) {
                if (arg0.getZIndex() == -1) {
                    return 1;
                }
                if (arg0.getZIndex() < arg1.getZIndex()) {
                    return -1;
                }
                if (arg0.getZIndex() > arg1.getZIndex()) {
                    return 1;
                }
                return 0;
            }
        });
        int i = 0;
        while (i < this.labels.size()) {
            this.labels.get(i).setZIndex(i);
            ++i;
        }
    }

    public void addWorkflowLabel(WorkflowLabel label) {
        this.labels.add(label);
        this.firePropertyChange(PROPERTY_LABEL);
    }

    public void addWorkflowLabels(List<WorkflowLabel> labelsToAdd) {
        for (WorkflowLabel label : labelsToAdd) {
            this.labels.add(label);
        }
        this.firePropertyChange(PROPERTY_LABEL);
    }

    public void setWorkflowLabels(List<WorkflowLabel> labelsToSet) {
        this.labels = labelsToSet;
        this.firePropertyChange(PROPERTY_LABEL);
    }

    public WorkflowNode getWorkflowNode(String nodeId) throws IllegalArgumentException {
        for (WorkflowNode node : this.nodes) {
            if (!node.getIdentifier().equals(nodeId)) continue;
            return node;
        }
        throw new IllegalArgumentException(StringUtils.format((String)"No node with identifier %s found", (Object[])new Object[]{nodeId}));
    }

    private void addWorkflowNodeWithoutNotify(WorkflowNode node) {
        this.nodes.add(node);
        EndpointChangeListener l = new EndpointChangeListener(this);
        node.getInputDescriptionsManager().addPropertyChangeListener((PropertyChangeListener)l);
        node.getOutputDescriptionsManager().addPropertyChangeListener((PropertyChangeListener)l);
    }

    public void addWorkflowNode(WorkflowNode node) {
        this.addWorkflowNodeWithoutNotify(node);
        this.firePropertyChange(PROPERTY_NODES_OR_CONNECTIONS);
        this.firePropertyChange(PROPERTY_NODES);
    }

    public void addWorkflowNodes(List<WorkflowNode> nodesToAdd) {
        for (WorkflowNode node : nodesToAdd) {
            this.nodes.add(node);
            EndpointChangeListener l = new EndpointChangeListener(this);
            node.getInputDescriptionsManager().addPropertyChangeListener((PropertyChangeListener)l);
            node.getOutputDescriptionsManager().addPropertyChangeListener((PropertyChangeListener)l);
        }
        this.firePropertyChange(PROPERTY_NODES_OR_CONNECTIONS);
        this.firePropertyChange(PROPERTY_NODES);
    }

    public void addWorkflowNodeAndConnections(WorkflowNode nodeToAdd, List<Connection> connectionsToAdd) {
        this.addWorkflowNodeWithoutNotify(nodeToAdd);
        this.addConnectionsWithoutNotify(connectionsToAdd);
        this.firePropertyChange(PROPERTY_NODES_OR_CONNECTIONS);
        this.firePropertyChange(PROPERTY_CONNECTIONS);
        this.firePropertyChange(PROPERTY_NODES);
    }

    public void addWorkflowNodesAndConnections(List<WorkflowNode> nodesToAdd, List<Connection> connectionsToAdd) {
        for (WorkflowNode nodeToAdd : nodesToAdd) {
            this.addWorkflowNodeWithoutNotify(nodeToAdd);
        }
        this.addConnectionsWithoutNotify(connectionsToAdd);
        this.firePropertyChange(PROPERTY_NODES_OR_CONNECTIONS);
        this.firePropertyChange(PROPERTY_CONNECTIONS);
        this.firePropertyChange(PROPERTY_NODES);
    }

    public void removeWorkflowLabel(WorkflowLabel label) {
        this.labels.remove(label);
        this.firePropertyChange(PROPERTY_LABEL);
    }

    public void removeWorkflowLabels(List<WorkflowLabel> labelsToRemove) {
        for (WorkflowLabel label : labelsToRemove) {
            this.labels.remove(label);
        }
        this.firePropertyChange(PROPERTY_LABEL);
    }

    public void removeWorkflowNode(WorkflowNode node) {
        this.nodes.remove(node);
        this.firePropertyChange(PROPERTY_NODES_OR_CONNECTIONS);
        this.firePropertyChange(PROPERTY_NODES);
    }

    private List<Connection> removeWorkflowNodeAndRelatedConnectionsWithoutNotify(WorkflowNode node) {
        ArrayList<Connection> cnsToDelete = new ArrayList<Connection>();
        for (Connection cn : this.getConnections()) {
            if (!cn.getTargetNode().equals(node) && !cn.getSourceNode().equals(node)) continue;
            cnsToDelete.add(cn);
        }
        this.removeConnectionsWithoutNotify(cnsToDelete);
        this.nodes.remove(node);
        return cnsToDelete;
    }

    public List<Connection> removeWorkflowNodeAndRelatedConnections(WorkflowNode node) {
        List<Connection> cnsDeleted = this.removeWorkflowNodeAndRelatedConnectionsWithoutNotify(node);
        if (!cnsDeleted.isEmpty()) {
            this.firePropertyChange(PROPERTY_CONNECTIONS);
        }
        this.firePropertyChange(PROPERTY_NODES_OR_CONNECTIONS);
        this.firePropertyChange(PROPERTY_NODES);
        return cnsDeleted;
    }

    public List<Connection> removeWorkflowNodesAndRelatedConnections(List<WorkflowNode> nodesToRemove) {
        ArrayList<Connection> cnsDeleted = new ArrayList<Connection>();
        for (WorkflowNode node : nodesToRemove) {
            cnsDeleted.addAll(this.removeWorkflowNodeAndRelatedConnectionsWithoutNotify(node));
        }
        if (!cnsDeleted.isEmpty()) {
            this.firePropertyChange(PROPERTY_CONNECTIONS);
        }
        this.firePropertyChange(PROPERTY_NODES_OR_CONNECTIONS);
        this.firePropertyChange(PROPERTY_NODES);
        return cnsDeleted;
    }

    public List<Connection> removeWorkflowNodesAndRelatedConnectionsWithoutNotify(List<WorkflowNode> nodesToRemove) {
        ArrayList<Connection> cnsDeleted = new ArrayList<Connection>();
        for (WorkflowNode node : nodesToRemove) {
            cnsDeleted.addAll(this.removeWorkflowNodeAndRelatedConnectionsWithoutNotify(node));
        }
        return cnsDeleted;
    }

    public void removeWorkflowNodes(List<WorkflowNode> nodesToRemove) {
        for (WorkflowNode node : nodesToRemove) {
            this.nodes.remove(node);
        }
        this.firePropertyChange(PROPERTY_NODES_OR_CONNECTIONS);
        this.firePropertyChange(PROPERTY_NODES);
    }

    public void removeAllWorkflowNodes() {
        this.nodes.clear();
        this.firePropertyChange(PROPERTY_NODES_OR_CONNECTIONS);
        this.firePropertyChange(PROPERTY_NODES);
    }

    public List<Connection> getConnections() {
        return new ArrayList<Connection>(this.connections);
    }

    public void addConnection(Connection connection) {
        this.addConnectionWithoutNotify(connection);
        this.firePropertyChange(PROPERTY_NODES_OR_CONNECTIONS);
        this.firePropertyChange(PROPERTY_CONNECTIONS);
    }

    public void addConnections(List<Connection> connectionsToAdd) {
        this.addConnectionsWithoutNotify(connectionsToAdd);
        this.firePropertyChange(PROPERTY_NODES_OR_CONNECTIONS);
        this.firePropertyChange(PROPERTY_CONNECTIONS);
    }

    private void addConnectionsWithoutNotify(List<Connection> connectionsToAdd) {
        for (Connection connection : connectionsToAdd) {
            this.addConnectionWithoutNotify(connection);
        }
    }

    private void addConnectionWithoutNotify(Connection connection) {
        this.connections.add(connection);
        EndpointDescription output = connection.getOutput();
        EndpointDescription input = connection.getInput();
        this.getWorkflowNode(connection.getSourceNode().getIdentifier()).getOutputDescriptionsManager().addConnectedDataType(output.getName(), input.getDataType());
        this.getWorkflowNode(connection.getTargetNode().getIdentifier()).getInputDescriptionsManager().addConnectedDataType(input.getName(), output.getDataType());
    }

    public void removeConnection(Connection connection) {
        if (this.removeConnectionWithoutNotify(connection)) {
            this.firePropertyChange(PROPERTY_NODES_OR_CONNECTIONS);
            this.firePropertyChange(PROPERTY_CONNECTIONS);
        }
    }

    public void removeConnections(List<Connection> connectionsToRemove) {
        boolean removed = false;
        for (Connection connection : connectionsToRemove) {
            if (!this.removeConnectionWithoutNotify(connection)) continue;
            removed = true;
        }
        if (removed) {
            this.firePropertyChange(PROPERTY_NODES_OR_CONNECTIONS);
            this.firePropertyChange(PROPERTY_CONNECTIONS);
        }
    }

    private boolean removeConnectionWithoutNotify(Connection connection) {
        EndpointDescription output = connection.getOutput();
        EndpointDescription input = connection.getInput();
        connection.getSourceNode().setValid(false);
        connection.getTargetNode().setValid(false);
        this.getWorkflowNode(connection.getSourceNode().getIdentifier()).getOutputDescriptionsManager().removeConnectedDataType(output.getName(), input.getDataType());
        this.getWorkflowNode(connection.getTargetNode().getIdentifier()).getInputDescriptionsManager().removeConnectedDataType(input.getName(), output.getDataType());
        return this.connections.remove(connection);
    }

    private boolean removeConnectionsWithoutNotify(List<Connection> connectionsToRemove) {
        boolean removed = false;
        for (Connection connection : connectionsToRemove) {
            if (!this.removeConnectionWithoutNotify(connection)) continue;
            removed = true;
        }
        return removed;
    }

    public void replaceConnections(List<Connection> connectionsToAdd) {
        this.removeConnectionsWithoutNotify(this.getConnections());
        this.addConnections(connectionsToAdd);
    }

    public void copyExecutionInformationFromWorkflowDescription(WorkflowDescription wd) {
        this.setName(wd.getName());
        this.setControllerNode(wd.getControllerNode());
        this.setAdditionalInformation(wd.getAdditionalInformation());
        for (WorkflowNode node : this.getWorkflowNodes()) {
            if (wd.getWorkflowNode(node.getIdentifier()) == null) continue;
            node.getComponentDescription().setComponentInstallation(wd.getWorkflowNode(node.getIdentifier()).getComponentDescription().getComponentInstallation());
        }
    }

    public WorkflowDescription clone() {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(this);
            oos.flush();
            ByteArrayInputStream bin = new ByteArrayInputStream(bos.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bin);
            WorkflowDescription wd = (WorkflowDescription)ois.readObject();
            ois.close();
            bin.close();
            oos.close();
            bos.close();
            return wd;
        }
        catch (IOException e) {
            LogFactory.getLog(ComponentDescription.class).error((Object)"Failed to clone workflow description", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            LogFactory.getLog(ComponentDescription.class).error((Object)"Failed to clone workflow description", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

