/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.workflow.execution.internal;

import de.rcenvironment.core.communication.api.CommunicationService;
import de.rcenvironment.core.communication.api.PlatformService;
import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import de.rcenvironment.core.communication.common.LogicalNodeId;
import de.rcenvironment.core.communication.common.ResolvableNodeId;
import de.rcenvironment.core.communication.management.WorkflowHostService;
import de.rcenvironment.core.component.api.ComponentUtils;
import de.rcenvironment.core.component.api.DistributedComponentKnowledge;
import de.rcenvironment.core.component.api.DistributedComponentKnowledgeService;
import de.rcenvironment.core.component.execution.api.ExecutionControllerException;
import de.rcenvironment.core.component.execution.api.RemotableComponentExecutionControllerService;
import de.rcenvironment.core.component.workflow.execution.api.RemotableWorkflowExecutionControllerService;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowDescriptionValidationResult;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionContext;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionException;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionInformation;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionService;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowFileException;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowState;
import de.rcenvironment.core.component.workflow.execution.spi.WorkflowDescriptionLoaderCallback;
import de.rcenvironment.core.component.workflow.model.api.WorkflowDescription;
import de.rcenvironment.core.component.workflow.model.api.WorkflowDescriptionPersistenceHandler;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.component.workflow.update.api.PersistentWorkflowDescription;
import de.rcenvironment.core.component.workflow.update.api.PersistentWorkflowDescriptionUpdateService;
import de.rcenvironment.core.component.workflow.update.api.PersistentWorkflowDescriptionUpdateUtils;
import de.rcenvironment.core.notification.DistributedNotificationService;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.rpc.RemoteOperationException;
import de.rcenvironment.core.utils.incubator.DebugSettings;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncExceptionListener;
import de.rcenvironment.toolkit.modules.concurrency.api.CallablesGroup;
import de.rcenvironment.toolkit.modules.concurrency.api.TaskDescription;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledFuture;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;

public class WorkflowExecutionServiceImpl
implements WorkflowExecutionService {
    private static final String FAILED_TO_LOAD_WORKFLOW_FILE = "Failed to load workflow file: ";
    private static final Log LOG = LogFactory.getLog(WorkflowExecutionServiceImpl.class);
    private static final int ACTIVE_WORKFLOW_HEARTBEAT_NOTIFICATION_INTERVAL_MSEC = 6000;
    private final boolean verboseLogging = DebugSettings.getVerboseLoggingEnabled(this.getClass());
    private CommunicationService communicationService;
    private DistributedNotificationService notificationService;
    private PersistentWorkflowDescriptionUpdateService wfUpdateService;
    private PlatformService platformService;
    private WorkflowHostService workflowHostService;
    private RemotableWorkflowExecutionControllerService wfExeCtrlService;
    private DistributedComponentKnowledgeService componentKnowledgeService;
    private RemotableComponentExecutionControllerService componentExecutionControllerService;
    private Set<WorkflowExecutionInformation> workflowExecutionInformations;
    private Object wfExeFetchLock = new Object();
    private ScheduledFuture<?> heartbeatSendFuture;

    protected void activate(BundleContext context) {
        this.heartbeatSendFuture = ConcurrencyUtils.getAsyncTaskService().scheduleAtFixedRate(new Runnable(){

            @Override
            @TaskDescription(value="Send heartbeat for active workflows")
            public void run() {
                Set<WorkflowExecutionInformation> wfExeInfoSnapshot = this.getWorkflowExecutionInformation();
                for (WorkflowExecutionInformation wfExeInfo : wfExeInfoSnapshot) {
                    String wfExeId = wfExeInfo.getExecutionIdentifier();
                    switch (wfExeInfo.getWorkflowState()) {
                        case INIT: 
                        case STARTING: 
                        case PREPARING: 
                        case RUNNING: 
                        case PAUSING: 
                        case PAUSED: 
                        case RESUMING: 
                        case CANCELING: 
                        case CANCELING_AFTER_FAILED: {
                            if (WorkflowExecutionServiceImpl.this.verboseLogging) {
                                LOG.debug((Object)StringUtils.format((String)"Sending heartbeat notification for active workflow '%s' (%s)", (Object[])new Object[]{wfExeInfo.getInstanceName(), wfExeId}));
                            }
                            WorkflowExecutionServiceImpl.this.notificationService.send("rce.component.workflow.state:" + wfExeId, (Serializable)((Object)WorkflowState.IS_ALIVE.name()));
                            break;
                        }
                    }
                }
            }

            private Set<WorkflowExecutionInformation> getWorkflowExecutionInformation() {
                HashSet<WorkflowExecutionInformation> wfExeInfoSnapshot = new HashSet<WorkflowExecutionInformation>();
                try {
                    wfExeInfoSnapshot.addAll(WorkflowExecutionServiceImpl.this.wfExeCtrlService.getWorkflowExecutionInformations());
                }
                catch (ExecutionControllerException | RemoteOperationException e) {
                    LOG.error((Object)("Failed to fetch local workflow execution informations: " + e.getMessage()));
                }
                return wfExeInfoSnapshot;
            }
        }, 6000L);
    }

    protected void deactivate() {
        if (this.heartbeatSendFuture != null) {
            this.heartbeatSendFuture.cancel(true);
        }
    }

    @Override
    public WorkflowDescription loadWorkflowDescriptionFromFileConsideringUpdates(File wfFile, WorkflowDescriptionLoaderCallback callback) throws WorkflowFileException {
        return this.loadWorkflowDescriptionFromFileConsideringUpdates(wfFile, callback, false);
    }

    @Override
    public WorkflowDescription loadWorkflowDescriptionFromFileConsideringUpdates(File wfFile, WorkflowDescriptionLoaderCallback callback, boolean abortIfWorkflowUpdateRequired) throws WorkflowFileException {
        try {
            block18: {
                int wfVersion = this.readWorkflowVersionNumber(wfFile);
                if (wfVersion > 5) {
                    throw new WorkflowFileException(FAILED_TO_LOAD_WORKFLOW_FILE + wfFile.getAbsolutePath() + StringUtils.format((String)". Its version (%d) is newer than the expected one (%d). Most likely reason: it was opened with a newer version of RCE before.", (Object[])new Object[]{wfVersion, 5}));
                }
                Throwable throwable = null;
                Object var6_8 = null;
                try (FileInputStream fileInputStream = new FileInputStream(wfFile);){
                    boolean updateRequired;
                    PersistentWorkflowDescription persistentDescription = this.wfUpdateService.createPersistentWorkflowDescription(IOUtils.toString((InputStream)fileInputStream, (String)"UTF-8"));
                    boolean nonSilentUpdateRequired = updateRequired = this.wfUpdateService.isUpdateForWorkflowDescriptionAvailable(persistentDescription, false);
                    if (updateRequired && abortIfWorkflowUpdateRequired) {
                        throw new WorkflowFileException("The workflow file " + wfFile.getAbsolutePath() + " would require an update before execution, but the 'fail on required update' flag has been set. " + "Typically, this means that it was generated from an internal template which should be updated.");
                    }
                    if (!nonSilentUpdateRequired) {
                        updateRequired = this.wfUpdateService.isUpdateForWorkflowDescriptionAvailable(persistentDescription, true);
                    }
                    if (!updateRequired) break block18;
                    String backupFilename = null;
                    if (nonSilentUpdateRequired) {
                        backupFilename = String.valueOf(PersistentWorkflowDescriptionUpdateUtils.getFilenameForBackupFile(wfFile)) + ".wf";
                        FileUtils.copyFile((File)wfFile, (File)new File(wfFile.getParentFile().getAbsolutePath(), backupFilename));
                    }
                    try {
                        this.updateWorkflow(persistentDescription, wfFile, nonSilentUpdateRequired);
                        this.onWorkflowFileUpdated(wfFile, !nonSilentUpdateRequired, backupFilename, callback);
                    }
                    catch (IOException | RuntimeException e) {
                        if (nonSilentUpdateRequired) {
                            throw new WorkflowFileException(StringUtils.format((String)"Failed to update workflow file: %s. Backup file was generated: %s.", (Object[])new Object[]{wfFile.getAbsolutePath(), backupFilename}), e);
                        }
                        throw new WorkflowFileException(StringUtils.format((String)"Failed to update workflow file: %s.", (Object[])new Object[]{wfFile.getAbsolutePath()}), e);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            return this.loadWorkflowDescriptionFromFile(wfFile, callback);
        }
        catch (IOException | ParseException e) {
            throw new WorkflowFileException(FAILED_TO_LOAD_WORKFLOW_FILE + wfFile.getAbsolutePath(), e);
        }
    }

    private int readWorkflowVersionNumber(File wfFile) throws ParseException, IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileInputStream fileInputStream = new FileInputStream(wfFile);){
            return new WorkflowDescriptionPersistenceHandler().readWorkflowVersionNumber(fileInputStream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public WorkflowDescription loadWorkflowDescriptionFromFile(File wfFile, WorkflowDescriptionLoaderCallback callback) throws WorkflowFileException {
        try {
            WorkflowDescription wd;
            int wfVersion = this.readWorkflowVersionNumber(wfFile);
            if (wfVersion > 5) {
                throw new WorkflowFileException(FAILED_TO_LOAD_WORKFLOW_FILE + wfFile.getAbsolutePath() + StringUtils.format((String)". Its version (%d) is older than the expected one (%d). Most likely reason: Internal error on workflow update.", (Object[])new Object[]{wfVersion, 5}));
            }
            WorkflowDescriptionPersistenceHandler wdPesistenceHandler = new WorkflowDescriptionPersistenceHandler();
            try {
                Throwable throwable = null;
                Object var7_9 = null;
                try (FileInputStream fileInputStream = new FileInputStream(wfFile);){
                    wd = wdPesistenceHandler.readWorkflowDescriptionFromStream(fileInputStream);
                    return wd;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                        throw throwable;
                    }
                    if (throwable == throwable2) throw throwable;
                    throwable.addSuppressed(throwable2);
                    throw throwable;
                }
            }
            catch (WorkflowFileException e) {
                String backupFilename;
                block25: {
                    if (e.getParsedWorkflowDescription() == null) throw e;
                    if (!callback.arePartlyParsedWorkflowConsiderValid()) throw e;
                    backupFilename = String.valueOf(PersistentWorkflowDescriptionUpdateUtils.getFilenameForBackupFile(wfFile)) + ".wf";
                    FileUtils.copyFile((File)wfFile, (File)new File(wfFile.getParentFile().getAbsolutePath(), backupFilename));
                    wd = e.getParsedWorkflowDescription();
                    Throwable throwable = null;
                    Object var9_16 = null;
                    try {
                        FileOutputStream fos = new FileOutputStream(wfFile);
                        try {
                            try (ByteArrayOutputStream baos = wdPesistenceHandler.writeWorkflowDescriptionToStream(wd);){
                                baos.writeTo(fos);
                            }
                            if (fos == null) break block25;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (fos == null) throw throwable;
                            fos.close();
                            throw throwable;
                        }
                        fos.close();
                    }
                    catch (Throwable throwable4) {
                        if (throwable == null) {
                            throwable = throwable4;
                            throw throwable;
                        }
                        if (throwable == throwable4) throw throwable;
                        throwable.addSuppressed(throwable4);
                        throw throwable;
                    }
                }
                callback.onWorkflowFileParsingPartlyFailed(backupFilename);
                return wd;
            }
        }
        catch (IOException | RuntimeException | ParseException e) {
            throw new WorkflowFileException(FAILED_TO_LOAD_WORKFLOW_FILE + wfFile.getAbsolutePath(), e);
        }
    }

    private void onWorkflowFileUpdated(File wfFile, boolean silentUpdate, String backupFilename, WorkflowDescriptionLoaderCallback callback) {
        if (silentUpdate) {
            String message = StringUtils.format((String)"'%s' was updated (silently) (full path: %s)", (Object[])new Object[]{wfFile.getName(), wfFile.getAbsolutePath()});
            LOG.debug((Object)message);
            callback.onSilentWorkflowFileUpdated(message);
        } else {
            String message = StringUtils.format((String)"'%s' was updated (non-silently); backup file generated: %s (full path: %s)", (Object[])new Object[]{wfFile.getName(), backupFilename, wfFile.getAbsolutePath()});
            LOG.debug((Object)message);
            callback.onNonSilentWorkflowFileUpdated(message, backupFilename);
        }
    }

    private void updateWorkflow(PersistentWorkflowDescription persWfDescr, File file, boolean hasNonSilentUpdate) throws IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (InputStream tempInputStream = IOUtils.toInputStream((String)this.wfUpdateService.performWorkflowDescriptionUpdate(persWfDescr).getWorkflowDescriptionAsString(), (String)"UTF-8");){
            FileUtils.write((File)file, (CharSequence)IOUtils.toString((InputStream)tempInputStream));
            tempInputStream.close();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public WorkflowDescriptionValidationResult validateWorkflowDescription(WorkflowDescription workflowDescription) {
        LogicalNodeId missingControllerNodeId = null;
        HashMap<String, LogicalNodeId> missingComponentsNodeIds = new HashMap<String, LogicalNodeId>();
        LogicalNodeId controllerNode = workflowDescription.getControllerNode();
        if (controllerNode == null) {
            controllerNode = this.platformService.getLocalDefaultLogicalNodeId();
        }
        if (!this.workflowHostService.getLogicalWorkflowHostNodesAndSelf().contains(controllerNode)) {
            missingControllerNodeId = controllerNode;
        }
        DistributedComponentKnowledge compKnowledge = this.componentKnowledgeService.getCurrentComponentKnowledge();
        for (WorkflowNode node : workflowDescription.getWorkflowNodes()) {
            LogicalNodeId componentNode = node.getComponentDescription().getNode();
            if (componentNode == null) {
                componentNode = this.platformService.getLocalDefaultLogicalNodeId();
            }
            if (ComponentUtils.hasComponent((Collection)compKnowledge.getAllInstallations(), (String)node.getComponentDescription().getIdentifier(), (LogicalNodeId)componentNode)) continue;
            missingComponentsNodeIds.put(node.getName(), componentNode);
        }
        if (missingControllerNodeId == null && missingComponentsNodeIds.isEmpty()) {
            return WorkflowDescriptionValidationResult.createResultForSuccess();
        }
        return WorkflowDescriptionValidationResult.createResultForFailure(missingControllerNodeId, missingComponentsNodeIds);
    }

    @Override
    public WorkflowExecutionInformation executeWorkflowAsync(WorkflowExecutionContext wfExeCtx) throws WorkflowExecutionException, RemoteOperationException {
        WorkflowExecutionInformation workflowExecutionInformation = this.createExecutionController(wfExeCtx);
        try {
            this.performStartOnExecutionController(workflowExecutionInformation.getExecutionIdentifier(), (ResolvableNodeId)wfExeCtx.getNodeId());
        }
        catch (ExecutionControllerException e) {
            throw new WorkflowExecutionException("Failed to execute workflow", (Exception)((Object)e));
        }
        return workflowExecutionInformation;
    }

    private WorkflowExecutionInformation createExecutionController(WorkflowExecutionContext wfExeCtx) throws RemoteOperationException, WorkflowExecutionException {
        Map<String, String> authTokens = this.createAndRegisterLocalComponentExecutionAuthTokens(wfExeCtx.getWorkflowDescription());
        return this.getExecutionControllerService((ResolvableNodeId)wfExeCtx.getNodeId()).createExecutionController(wfExeCtx, authTokens, !this.platformService.matchesLocalInstance((ResolvableNodeId)wfExeCtx.getNodeId()));
    }

    private Map<String, String> createAndRegisterLocalComponentExecutionAuthTokens(WorkflowDescription workflowDescription) {
        HashMap<String, String> compIdToTokenMapping = new HashMap<String, String>();
        for (WorkflowNode wfNode : workflowDescription.getWorkflowNodes()) {
            LogicalNodeId node = wfNode.getComponentDescription().getNode();
            String token = "";
            if (node == null || this.platformService.matchesLocalInstance((ResolvableNodeId)node)) {
                token = UUID.randomUUID().toString();
                try {
                    this.componentExecutionControllerService.addComponentExecutionAuthToken(token);
                }
                catch (RemoteOperationException e) {
                    throw new IllegalStateException("Failed to add auth tokens for component execution; cause: " + e.toString());
                }
            }
            compIdToTokenMapping.put(wfNode.getIdentifier(), token);
        }
        return compIdToTokenMapping;
    }

    private void performStartOnExecutionController(String executionId, ResolvableNodeId node) throws ExecutionControllerException, RemoteOperationException {
        this.getExecutionControllerService(node).performStart(executionId);
    }

    @Override
    public void cancel(String executionId, ResolvableNodeId node) throws ExecutionControllerException, RemoteOperationException {
        this.getExecutionControllerService(node).performCancel(executionId);
    }

    @Override
    public void pause(String executionId, ResolvableNodeId node) throws ExecutionControllerException, RemoteOperationException {
        this.getExecutionControllerService(node).performPause(executionId);
    }

    @Override
    public void resume(String executionId, ResolvableNodeId node) throws ExecutionControllerException, RemoteOperationException {
        this.getExecutionControllerService(node).performResume(executionId);
    }

    @Override
    public void dispose(String executionId, ResolvableNodeId node) throws ExecutionControllerException, RemoteOperationException {
        this.getExecutionControllerService(node).performDispose(executionId);
    }

    @Override
    public WorkflowState getWorkflowState(String executionId, ResolvableNodeId node) throws ExecutionControllerException, RemoteOperationException {
        return this.getExecutionControllerService(node).getWorkflowState(executionId);
    }

    @Override
    public Long getWorkflowDataManagementId(String executionId, ResolvableNodeId node) throws ExecutionControllerException, RemoteOperationException {
        return this.getExecutionControllerService(node).getWorkflowDataManagementId(executionId);
    }

    @Override
    public Set<WorkflowExecutionInformation> getLocalWorkflowExecutionInformations() {
        try {
            return new HashSet<WorkflowExecutionInformation>(this.wfExeCtrlService.getWorkflowExecutionInformations());
        }
        catch (ExecutionControllerException | RemoteOperationException e) {
            throw new IllegalStateException("Failed to get local workflow execution information; cause: " + e.toString());
        }
    }

    @Override
    public Set<WorkflowExecutionInformation> getWorkflowExecutionInformations() {
        return this.getWorkflowExecutionInformations(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<WorkflowExecutionInformation> getWorkflowExecutionInformations(boolean forceRefresh) {
        if (!forceRefresh && this.workflowExecutionInformations != null) {
            return new HashSet<WorkflowExecutionInformation>(this.workflowExecutionInformations);
        }
        Object object = this.wfExeFetchLock;
        synchronized (object) {
            if (forceRefresh || this.workflowExecutionInformations == null) {
                HashSet<WorkflowExecutionInformation> tempWfExeInfos = new HashSet<WorkflowExecutionInformation>();
                CallablesGroup callablesGroup = ConcurrencyUtils.getFactory().createCallablesGroup(Collection.class);
                Iterator iterator = this.workflowHostService.getWorkflowHostNodesAndSelf().iterator();
                while (iterator.hasNext()) {
                    InstanceNodeSessionId node;
                    final InstanceNodeSessionId finalNode = node = (InstanceNodeSessionId)iterator.next();
                    callablesGroup.add((Callable)new Callable<Collection>(){

                        @Override
                        @TaskDescription(value="Distributed query: getWorkflowInformations()")
                        public Collection call() throws Exception {
                            RemotableWorkflowExecutionControllerService executionControllerService = WorkflowExecutionServiceImpl.this.getExecutionControllerService((ResolvableNodeId)finalNode);
                            try {
                                return executionControllerService.getWorkflowExecutionInformations();
                            }
                            catch (RemoteOperationException e) {
                                LOG.error((Object)StringUtils.format((String)"Failed to query remote workflows on node %s; cause: %s", (Object[])new Object[]{finalNode, e.toString()}));
                                return null;
                            }
                        }
                    });
                }
                List results = callablesGroup.executeParallel(new AsyncExceptionListener(){

                    public void onAsyncException(Exception e) {
                        LOG.warn((Object)"Exception during asynchrous execution", (Throwable)e);
                    }
                });
                for (Collection singleResult : results) {
                    if (singleResult == null) continue;
                    tempWfExeInfos.addAll(singleResult);
                }
                this.workflowExecutionInformations = tempWfExeInfos;
            }
            return new HashSet<WorkflowExecutionInformation>(this.workflowExecutionInformations);
        }
    }

    private RemotableWorkflowExecutionControllerService getExecutionControllerService(ResolvableNodeId node) throws RemoteOperationException {
        return (RemotableWorkflowExecutionControllerService)this.communicationService.getRemotableService(RemotableWorkflowExecutionControllerService.class, node);
    }

    protected void bindCommunicationService(CommunicationService newService) {
        this.communicationService = newService;
    }

    protected void bindNotificationService(DistributedNotificationService newService) {
        this.notificationService = newService;
    }

    protected void bindPersistentWorkflowDescriptionUpdateService(PersistentWorkflowDescriptionUpdateService newService) {
        this.wfUpdateService = newService;
    }

    protected void bindPlatformService(PlatformService newService) {
        this.platformService = newService;
    }

    protected void bindComponentExecutionControllerService(RemotableComponentExecutionControllerService newService) {
        this.componentExecutionControllerService = newService;
    }

    protected void bindWorkflowHostService(WorkflowHostService newService) {
        this.workflowHostService = newService;
    }

    protected void bindDistributedComponentKnowledgeService(DistributedComponentKnowledgeService newService) {
        this.componentKnowledgeService = newService;
    }

    protected void bindWorkflowExecutionControllerService(RemotableWorkflowExecutionControllerService newService) {
        this.wfExeCtrlService = newService;
    }
}

