/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.workflow.execution.internal;

import de.rcenvironment.core.component.execution.api.ConsoleRow;
import de.rcenvironment.core.utils.common.StringUtils;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class ConsoleRowFormatter {
    private final SimpleDateFormat timeFormat = new SimpleDateFormat("yyyy-MM-dd-HH:mm:ss,SSS");

    public String toSingleWorkflowLogFileFormat(ConsoleRow row) {
        String componentName = row.getComponentName();
        if (componentName == null || componentName.isEmpty()) {
            componentName = "-";
        }
        return StringUtils.format((String)"[%s] [%s] [%s] %s%n", (Object[])new Object[]{this.timeFormat.format(new Date(row.getTimestamp())), row.getType(), componentName, row.getPayload()});
    }

    public String toCombinedLogFileFormat(ConsoleRow row) {
        return StringUtils.format((String)"[%s] [%s] [%s] [%s] %s%n", (Object[])new Object[]{new Date(row.getTimestamp()), row.getWorkflowName(), row.getComponentName(), row.getType(), row.getPayload()});
    }

    public String toWorkflowErrorLogFileFormat(ConsoleRow row) {
        if (row.getType().equals((Object)ConsoleRow.Type.WORKFLOW_ERROR)) {
            return StringUtils.format((String)"%s %s: %s", (Object[])new Object[]{this.timeFormat.format(row.getTimestamp()), row.getType().getDisplayName(), row.getPayload()});
        }
        if (row.getComponentRun() > 0) {
            return StringUtils.format((String)"%s %s - %s [run %d]: %s", (Object[])new Object[]{this.timeFormat.format(row.getTimestamp()), row.getType().getDisplayName(), row.getComponentName(), row.getComponentRun(), row.getPayload()});
        }
        return StringUtils.format((String)"%s %s - %s: %s", (Object[])new Object[]{this.timeFormat.format(row.getTimestamp()), row.getType().getDisplayName(), row.getComponentName(), row.getPayload()});
    }

    public String toComponentCompleteLogFileFormat(ConsoleRow row) {
        return StringUtils.format((String)"[%d] %s %s: %s", (Object[])new Object[]{row.getSequenzNumber(), this.timeFormat.format(row.getTimestamp()), row.getType().getDisplayName(), row.getPayload()});
    }

    public String toComponentErrorLogFileFormat(ConsoleRow row) {
        return StringUtils.format((String)"%s %s: %s", (Object[])new Object[]{this.timeFormat.format(row.getTimestamp()), row.getType().getDisplayName(), row.getPayload()});
    }
}

