/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.workflow.execution.api;

import de.rcenvironment.core.component.model.endpoint.api.EndpointChange;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescriptionsManager;
import de.rcenvironment.core.component.workflow.model.api.Connection;
import de.rcenvironment.core.component.workflow.model.api.WorkflowDescription;
import de.rcenvironment.core.datamodel.api.DataType;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedList;
import org.apache.commons.logging.LogFactory;

public class EndpointChangeListener
implements PropertyChangeListener {
    private final WorkflowDescription workflowDesc;

    public EndpointChangeListener(WorkflowDescription newWorkflowDesc) {
        this.workflowDesc = newWorkflowDesc;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (!(event.getNewValue() instanceof EndpointChange)) {
            LogFactory.getLog(this.getClass()).debug((Object)("ignoring property change event because it is not of type " + EndpointChange.class.getSimpleName()));
            return;
        }
        EndpointChange epChange = (EndpointChange)event.getNewValue();
        if (epChange.getType() == EndpointChange.Type.Removed) {
            this.onRemoved(epChange);
        } else if (epChange.getType() == EndpointChange.Type.Modified) {
            this.onModified(epChange);
        }
    }

    private void onRemoved(EndpointChange epChange) {
        LinkedList<Connection> superfluousConnections = new LinkedList<Connection>();
        String removedEndpointId = epChange.getOldEndpointDescription().getIdentifier();
        for (Connection connection : this.workflowDesc.getConnections()) {
            boolean sourceRemoved = connection.getOutput().getIdentifier().equals(removedEndpointId);
            boolean targetRemoved = connection.getInput().getIdentifier().equals(removedEndpointId);
            if (!sourceRemoved && !targetRemoved) continue;
            superfluousConnections.add(connection);
        }
        this.workflowDesc.removeConnections(superfluousConnections);
    }

    private void onModified(EndpointChange epChange) {
        if (epChange.getEndpointDescription().getDataType() != epChange.getOldEndpointDescription().getDataType()) {
            this.onEndpointDataTypeChanged(epChange);
        } else if (!epChange.getEndpointDescription().getName().equals(epChange.getOldEndpointDescription().getName())) {
            for (Connection connection : this.workflowDesc.getConnections()) {
                if (connection.getInput().getIdentifier().equals(epChange.getEndpointDescription().getIdentifier())) {
                    connection.getInput().setName(epChange.getEndpointDescription().getName());
                    continue;
                }
                if (!connection.getOutput().getIdentifier().equals(epChange.getEndpointDescription().getIdentifier())) continue;
                connection.getOutput().setName(epChange.getEndpointDescription().getName());
            }
        }
    }

    private void onEndpointDataTypeChanged(EndpointChange epChange) {
        DataType newDataType = epChange.getEndpointDescription().getDataType();
        if (epChange.getOldEndpointDescription().isDataTypeValid(newDataType)) {
            for (Connection connection : this.workflowDesc.getConnections()) {
                if (connection.getInput().getIdentifier().equals(epChange.getEndpointDescription().getIdentifier())) {
                    EndpointDescriptionsManager outputDescManager = this.workflowDesc.getWorkflowNode(connection.getSourceNode().getIdentifier()).getComponentDescription().getOutputDescriptionsManager();
                    outputDescManager.removeConnectedDataType(connection.getOutput().getName(), epChange.getOldEndpointDescription().getDataType());
                    outputDescManager.addConnectedDataType(connection.getOutput().getName(), newDataType);
                    connection.getInput().setDataType(newDataType);
                    continue;
                }
                if (!connection.getOutput().getIdentifier().equals(epChange.getEndpointDescription().getIdentifier())) continue;
                EndpointDescriptionsManager inputDescManager = this.workflowDesc.getWorkflowNode(connection.getTargetNode().getIdentifier()).getComponentDescription().getInputDescriptionsManager();
                inputDescManager.removeConnectedDataType(connection.getInput().getName(), epChange.getOldEndpointDescription().getDataType());
                inputDescManager.addConnectedDataType(connection.getInput().getName(), newDataType);
                connection.getOutput().setDataType(newDataType);
            }
        } else {
            this.onRemoved(epChange);
        }
    }
}

