/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.sshconnection.internal;

import com.jcraft.jsch.Session;
import de.rcenvironment.core.communication.configuration.NodeConfigurationService;
import de.rcenvironment.core.communication.sshconnection.InitialSshConnectionConfig;
import de.rcenvironment.core.communication.sshconnection.SshConnectionContext;
import de.rcenvironment.core.communication.sshconnection.SshConnectionService;
import de.rcenvironment.core.communication.sshconnection.api.SshConnectionListener;
import de.rcenvironment.core.communication.sshconnection.api.SshConnectionListenerAdapter;
import de.rcenvironment.core.communication.sshconnection.api.SshConnectionSetup;
import de.rcenvironment.core.communication.sshconnection.impl.SshConnectionSetupImpl;
import de.rcenvironment.core.configuration.SecurePreferencesFactory;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncCallback;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncCallbackExceptionPolicy;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncOrderedCallbackManager;
import de.rcenvironment.toolkit.modules.concurrency.api.TaskDescription;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.StorageException;

public class SshConnectionServiceImpl
implements SshConnectionService {
    private static final String NO_SSH_CONNECTION_WITH_ID_S_CONFIGURED = "No SSH connection with id %s configured.";
    private final Map<String, SshConnectionSetup> connectionSetups;
    private final Log log = LogFactory.getLog(this.getClass());
    private final AsyncOrderedCallbackManager<SshConnectionListener> callbackManager = ConcurrencyUtils.getFactory().createAsyncOrderedCallbackManager(AsyncCallbackExceptionPolicy.LOG_AND_CANCEL_LISTENER);
    private NodeConfigurationService configurationService;

    public SshConnectionServiceImpl() {
        this.connectionSetups = new HashMap<String, SshConnectionSetup>();
    }

    @Override
    public Session getAvtiveSshSession(String connectionId) {
        SshConnectionSetup setup = this.connectionSetups.get(connectionId);
        if (setup == null) {
            this.log.warn((Object)StringUtils.format((String)NO_SSH_CONNECTION_WITH_ID_S_CONFIGURED, (Object[])new Object[]{connectionId}));
            return null;
        }
        return setup.getSession();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String addSshConnection(String displayName, String destinationHost, int port, String sshAuthUser, String keyfileLocation, boolean usePassphrase, boolean connectImmediately) {
        SshConnectionListener listenerAdapter;
        String connectionId = UUID.randomUUID().toString();
        SshConnectionSetupImpl newSetup = new SshConnectionSetupImpl(connectionId, displayName, destinationHost, port, sshAuthUser, keyfileLocation, usePassphrase, false, connectImmediately, listenerAdapter = this.defineListenerForSSHConnectionSetup());
        if (newSetup != null) {
            Map<String, SshConnectionSetup> map = this.connectionSetups;
            synchronized (map) {
                this.connectionSetups.put(connectionId, newSetup);
                final Collection<SshConnectionSetup> snapshot = Collections.unmodifiableCollection(this.connectionSetups.values());
                this.callbackManager.enqueueCallback((AsyncCallback)new AsyncCallback<SshConnectionListener>(){

                    public void performCallback(SshConnectionListener listener) {
                        listener.onCollectionChanged(snapshot);
                    }
                });
            }
        }
        return connectionId;
    }

    private SshConnectionListener defineListenerForSSHConnectionSetup() {
        SshConnectionListenerAdapter listenerAdapter = new SshConnectionListenerAdapter(){

            @Override
            public void onConnectionAttemptFailed(final SshConnectionSetup setup, final String reason, final boolean firstConsecutiveFailure, final boolean willAutoRetry) {
                SshConnectionServiceImpl.this.callbackManager.enqueueCallback((AsyncCallback)new AsyncCallback<SshConnectionListener>(){

                    public void performCallback(SshConnectionListener listener) {
                        listener.onConnectionAttemptFailed(setup, reason, firstConsecutiveFailure, willAutoRetry);
                    }
                });
            }

            @Override
            public void onConnectionClosed(final SshConnectionSetup setup, final boolean willAutoRetry) {
                SshConnectionServiceImpl.this.callbackManager.enqueueCallback((AsyncCallback)new AsyncCallback<SshConnectionListener>(){

                    public void performCallback(SshConnectionListener listener) {
                        listener.onConnectionClosed(setup, willAutoRetry);
                    }
                });
            }

            @Override
            public void onConnected(final SshConnectionSetup setup) {
                SshConnectionServiceImpl.this.callbackManager.enqueueCallback((AsyncCallback)new AsyncCallback<SshConnectionListener>(){

                    public void performCallback(SshConnectionListener listener) {
                        listener.onConnected(setup);
                    }
                });
            }

            @Override
            public void onCreated(final SshConnectionSetup setup) {
                SshConnectionServiceImpl.this.callbackManager.enqueueCallback((AsyncCallback)new AsyncCallback<SshConnectionListener>(){

                    public void performCallback(SshConnectionListener listener) {
                        listener.onCreated(setup);
                    }
                });
            }
        };
        return listenerAdapter;
    }

    @Override
    public boolean isConnected(String connectionId) {
        return this.connectionSetups.get(connectionId).isConnected();
    }

    @Override
    public Session connectSession(String connectionId) {
        String passphrase = "";
        if (this.connectionSetups.get(connectionId).getUsePassphrase()) {
            passphrase = this.retreiveSshConnectionPassword(connectionId);
        }
        return this.connectSession(connectionId, passphrase);
    }

    @Override
    public Session connectSession(String connectionId, String passphrase) {
        SshConnectionSetup sshConnectionSetup = this.connectionSetups.get(connectionId);
        if (sshConnectionSetup == null) {
            this.log.warn((Object)StringUtils.format((String)NO_SSH_CONNECTION_WITH_ID_S_CONFIGURED, (Object[])new Object[]{connectionId}));
            return null;
        }
        return sshConnectionSetup.connect(passphrase);
    }

    @Override
    public void disconnectSession(String connectionId) {
        SshConnectionSetup sshConnectionSetup = this.connectionSetups.get(connectionId);
        if (sshConnectionSetup == null) {
            this.log.warn((Object)StringUtils.format((String)NO_SSH_CONNECTION_WITH_ID_S_CONFIGURED, (Object[])new Object[]{connectionId}));
            return;
        }
        sshConnectionSetup.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disposeConnection(String connectionId) {
        final SshConnectionSetup setup = this.connectionSetups.get(connectionId);
        if (setup == null) {
            this.log.warn((Object)StringUtils.format((String)NO_SSH_CONNECTION_WITH_ID_S_CONFIGURED, (Object[])new Object[]{connectionId}));
            return;
        }
        if (setup.isConnected()) {
            setup.disconnect();
        }
        Map<String, SshConnectionSetup> map = this.connectionSetups;
        synchronized (map) {
            this.connectionSetups.remove(connectionId);
            final Collection<SshConnectionSetup> snapshot = Collections.unmodifiableCollection(this.connectionSetups.values());
            this.callbackManager.enqueueCallback((AsyncCallback)new AsyncCallback<SshConnectionListener>(){

                public void performCallback(SshConnectionListener listener) {
                    listener.onDisposed(setup);
                    listener.onCollectionChanged(snapshot);
                }
            });
        }
    }

    @Override
    public SshConnectionSetup getConnectionSetup(String connnectionId) {
        return this.connectionSetups.get(connnectionId);
    }

    @Override
    public Collection<SshConnectionSetup> getAllSshConnectionSetups() {
        return Collections.unmodifiableCollection(this.connectionSetups.values());
    }

    @Override
    public Map<String, SshConnectionSetup> getAllActiveSshConnectionSetups() {
        HashMap<String, SshConnectionSetup> activeConnections = new HashMap<String, SshConnectionSetup>();
        for (SshConnectionSetup connection : this.connectionSetups.values()) {
            if (!connection.isConnected()) continue;
            activeConnections.put(connection.getId(), connection);
        }
        return activeConnections;
    }

    public void addListener(SshConnectionListener listener) {
        this.callbackManager.addListener((Object)listener);
    }

    public void removeListener(SshConnectionListener listener) {
        this.callbackManager.removeListener((Object)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void editSshConnection(SshConnectionContext context) {
        SshConnectionListener listenerAdapter = this.defineListenerForSSHConnectionSetup();
        SshConnectionSetupImpl newSetup = new SshConnectionSetupImpl(context.getId(), context.getDisplayName(), context.getDestinationHost(), context.getPort(), context.getSshAuthUser(), context.getKeyfileLocation(), context.isUsePassphrase(), false, context.isConnectImmediately(), listenerAdapter);
        if (newSetup != null) {
            Map<String, SshConnectionSetup> map = this.connectionSetups;
            synchronized (map) {
                this.connectionSetups.put(context.getId(), newSetup);
                final Collection<SshConnectionSetup> snapshot = Collections.unmodifiableCollection(this.connectionSetups.values());
                this.callbackManager.enqueueCallback((AsyncCallback)new AsyncCallback<SshConnectionListener>(){

                    public void performCallback(SshConnectionListener listener) {
                        listener.onCollectionChanged(snapshot);
                    }
                });
            }
        }
    }

    @Override
    public Collection<String> getAllActiveSshConnectionSetupIds() {
        return this.getAllActiveSshConnectionSetups().keySet();
    }

    public void activate() {
        ConcurrencyUtils.getAsyncTaskService().execute(new Runnable(){

            @Override
            @TaskDescription(value="Client-Side Remote Access: Add pre-configured SSH connections")
            public void run() {
                SshConnectionServiceImpl.this.addInitialSshConfigs(SshConnectionServiceImpl.this.configurationService.getInitialSSHConnectionConfigs());
            }
        });
    }

    private void addInitialSshConfigs(List<InitialSshConnectionConfig> configs) {
        for (InitialSshConnectionConfig config : configs) {
            SshConnectionSetupImpl setup = new SshConnectionSetupImpl(config.getId(), config.getDisplayName(), config.getHost(), config.getPort(), config.getUser(), config.getKeyFileLocation(), config.getUsePassphrase(), false, false, this.defineListenerForSSHConnectionSetup());
            this.connectionSetups.put(config.getId(), setup);
        }
    }

    public void bindNodeConfigurationService(NodeConfigurationService service) {
        this.configurationService = service;
    }

    private void storeSshConnectionPassword(String connectionId, String password) {
        try {
            ISecurePreferences prefs = SecurePreferencesFactory.getSecurePreferencesStore();
            ISecurePreferences node = prefs.node("SSHConnectionsPasswords");
            node.put(connectionId, password, true);
        }
        catch (IOException | StorageException e) {
            this.log.error((Object)("Could not store password: " + e));
        }
    }

    private void removeSshConnectionPassword(String connectionId) {
        try {
            ISecurePreferences prefs = SecurePreferencesFactory.getSecurePreferencesStore();
            ISecurePreferences node = prefs.node("SSHConnectionsPasswords");
            node.remove(connectionId);
        }
        catch (IOException e) {
            this.log.error((Object)("Could not remove password: " + e));
        }
    }

    @Override
    public String retreiveSshConnectionPassword(String connectionId) {
        String passphrase = null;
        try {
            ISecurePreferences prefs = SecurePreferencesFactory.getSecurePreferencesStore();
            ISecurePreferences node = prefs.node("SSHConnectionsPasswords");
            passphrase = node.get(connectionId, null);
        }
        catch (IOException | StorageException e) {
            this.log.error((Object)("Could not retrieve password: " + e));
            return null;
        }
        return passphrase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAuthPhraseForSshConnection(String id, String sshAuthPassPhrase, boolean storePassphrase) {
        SshConnectionListener listenerAdapter = this.defineListenerForSSHConnectionSetup();
        SshConnectionSetup oldSetup = this.connectionSetups.get(id);
        SshConnectionSetupImpl newSetup = new SshConnectionSetupImpl(id, oldSetup.getDisplayName(), oldSetup.getHost(), oldSetup.getPort(), oldSetup.getUsername(), oldSetup.getKeyfileLocation(), oldSetup.getUsePassphrase(), storePassphrase, oldSetup.getConnectOnStartUp(), listenerAdapter);
        if (newSetup != null) {
            Map<String, SshConnectionSetup> map = this.connectionSetups;
            synchronized (map) {
                this.connectionSetups.put(id, newSetup);
                final Collection<SshConnectionSetup> snapshot = Collections.unmodifiableCollection(this.connectionSetups.values());
                this.callbackManager.enqueueCallback((AsyncCallback)new AsyncCallback<SshConnectionListener>(){

                    public void performCallback(SshConnectionListener listener) {
                        listener.onCollectionChanged(snapshot);
                    }
                });
            }
            if (storePassphrase) {
                this.storeSshConnectionPassword(id, sshAuthPassPhrase);
            } else if (oldSetup.getStorePassphrase()) {
                this.removeSshConnectionPassword(id);
            }
        }
    }
}

