/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.sshconnection.impl;

import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Logger;
import com.jcraft.jsch.Session;
import de.rcenvironment.core.communication.sshconnection.api.SshConnectionListener;
import de.rcenvironment.core.communication.sshconnection.api.SshConnectionSetup;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.ssh.jsch.JschSessionFactory;
import de.rcenvironment.core.utils.ssh.jsch.SshParameterException;
import de.rcenvironment.core.utils.ssh.jsch.SshSessionConfiguration;
import de.rcenvironment.core.utils.ssh.jsch.SshSessionConfigurationFactory;
import de.rcenvironment.core.utils.ssh.jsch.executor.JSchRCECommandLineExecutor;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.UnknownHostException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshConnectionSetupImpl
implements SshConnectionSetup {
    private SshSessionConfiguration config;
    private String id;
    private String displayName;
    private Session session;
    private SshConnectionListener listener;
    private boolean connectOnStartup;
    private boolean storePassphrase;
    private boolean usePassphrase;
    private Log log = LogFactory.getLog(this.getClass());

    public SshConnectionSetupImpl(String id, String displayName, String host, int port, String userName, String keyFileLocation, boolean usePassphrase, boolean storePassphrase, boolean connectOnStartUp, SshConnectionListener listener) {
        this.config = keyFileLocation == null || keyFileLocation.isEmpty() ? SshSessionConfigurationFactory.createSshSessionConfigurationWithAuthPhrase((String)host, (int)port, (String)userName, null) : SshSessionConfigurationFactory.createSshSessionConfigurationWithKeyFileLocation((String)host, (int)port, (String)userName, (String)keyFileLocation);
        this.id = id;
        this.connectOnStartup = connectOnStartUp;
        this.listener = listener;
        this.displayName = displayName;
        this.storePassphrase = storePassphrase;
        this.usePassphrase = usePassphrase;
        listener.onCreated(this);
    }

    @Override
    public String getHost() {
        return this.config.getDestinationHost();
    }

    @Override
    public int getPort() {
        return this.config.getPort();
    }

    @Override
    public String getUsername() {
        return this.config.getSshAuthUser();
    }

    @Override
    public String getKeyfileLocation() {
        return this.config.getSshKeyFileLocation();
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public boolean isConnected() {
        if (this.session == null) {
            return false;
        }
        boolean result = this.session.isConnected();
        if (!result) {
            this.session = null;
            this.listener.onConnectionClosed(this, false);
            this.log.warn((Object)StringUtils.format((String)"SSH session lost: host %s, port %s", (Object[])new Object[]{this.config.getDestinationHost(), this.config.getPort()}));
        }
        return result;
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Session connect(String passphrase) {
        String remoteRCEVersion;
        block28: {
            if (this.config.getSshKeyFileLocation() == null && passphrase == null) {
                this.log.warn((Object)StringUtils.format((String)"Connecting SSH session failed because no key file and no passphrase is given: host %s, port %s.", (Object[])new Object[]{this.config.getDestinationHost(), this.config.getPort()}));
                return null;
            }
            Logger logger = JschSessionFactory.createDelegateLogger((Log)LogFactory.getLog(this.getClass()));
            try {
                this.session = JschSessionFactory.setupSession((String)this.config.getDestinationHost(), (int)this.config.getPort(), (String)this.config.getSshAuthUser(), (String)this.config.getSshKeyFileLocation(), (String)passphrase, (Logger)logger);
            }
            catch (JSchException | SshParameterException e) {
                this.log.warn((Object)StringUtils.format((String)"Connecting SSH session failed: host %s, port %s: %s", (Object[])new Object[]{this.config.getDestinationHost(), this.config.getPort(), e.toString()}));
                String reason = e.getMessage();
                Throwable cause = e.getCause();
                if (cause != null && cause instanceof ConnectException) {
                    reason = "The remote instance could not be reached. Probably the hostname or port is wrong.";
                } else if (cause != null && cause instanceof UnknownHostException) {
                    reason = "No host with this name could be found.";
                } else if (reason.equals("Auth fail")) {
                    reason = "Authentication failed. Probably the username or passphrase is wrong, the wrong key file was used or the account is not enabled on the remote host.";
                } else if (reason.equals("USERAUTH fail")) {
                    reason = "Authentication failed. The wrong passphrase for the key file " + this.config.getSshKeyFileLocation() + " was used.";
                } else if (reason.startsWith("invalid privatekey")) {
                    reason = "Authentication failed. An invalid private key was used.";
                }
                this.listener.onConnectionAttemptFailed(this, reason, true, false);
                return null;
            }
            JSchRCECommandLineExecutor rceExecutor = new JSchRCECommandLineExecutor(this.session);
            try {
                rceExecutor.start("ra protocol-version");
                Throwable cause = null;
                Object var6_11 = null;
                try {
                    InputStream stdoutStream = rceExecutor.getStdout();
                    try {
                        try (InputStream stderrStream = rceExecutor.getStderr();){
                            rceExecutor.waitForTermination();
                            remoteRCEVersion = IOUtils.toString((InputStream)stdoutStream).trim();
                        }
                        if (stdoutStream == null) break block28;
                    }
                    catch (Throwable throwable) {
                        if (cause == null) {
                            cause = throwable;
                        } else if (cause != throwable) {
                            cause.addSuppressed(throwable);
                        }
                        if (stdoutStream == null) throw cause;
                        stdoutStream.close();
                        throw cause;
                    }
                    stdoutStream.close();
                }
                catch (Throwable throwable) {
                    if (cause == null) {
                        cause = throwable;
                        throw cause;
                    }
                    if (cause == throwable) throw cause;
                    cause.addSuppressed(throwable);
                    throw cause;
                }
            }
            catch (IOException | InterruptedException e1) {
                this.log.warn((Object)StringUtils.format((String)"Connecting SSH session failed: Could not retrieve version of RCE instance on host %s, port %s: %s", (Object[])new Object[]{this.config.getDestinationHost(), this.config.getPort(), e1.toString()}));
                this.session.disconnect();
                this.session = null;
                String reason = "The RCE version of the remote instance could not be retrieved. Possibly it is not an RCE instance.";
                this.listener.onConnectionAttemptFailed(this, reason, true, false);
                return null;
            }
        }
        if (!remoteRCEVersion.contains("8.0.0")) {
            this.log.warn((Object)StringUtils.format((String)"Connecting SSH session failed: Either, the RCE instance on host %s, port %s has an incompatible version, or the user %s does not have the required permissions to run remote access tools and workflows. (Detected server version information: %s, required version: %s)", (Object[])new Object[]{this.config.getDestinationHost(), this.config.getPort(), this.config.getSshAuthUser(), remoteRCEVersion, "8.0.0"}));
            this.session.disconnect();
            this.session = null;
            String reason = StringUtils.format((String)"Either, the remote RCE instance has an incompatible version, or the user %s does not have the required permissions to run remote access tools and workflows. \n\n(Detected server version information: %s, required version: %s)", (Object[])new Object[]{this.config.getSshAuthUser(), remoteRCEVersion, "8.0.0"});
            this.listener.onConnectionAttemptFailed(this, reason, true, false);
            return null;
        }
        this.listener.onConnected(this);
        return this.session;
    }

    @Override
    public void disconnect() {
        this.session.disconnect();
        this.listener.onConnectionClosed(this, false);
        this.session = null;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public boolean getConnectOnStartUp() {
        return this.connectOnStartup;
    }

    @Override
    public boolean getStorePassphrase() {
        return this.storePassphrase;
    }

    @Override
    public boolean getUsePassphrase() {
        return this.usePassphrase;
    }
}

