/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.utils.common.configuration;

import de.rcenvironment.core.gui.utils.common.configuration.ConfigurationViewerContentProvider;
import de.rcenvironment.core.gui.utils.common.configuration.Messages;
import de.rcenvironment.core.gui.utils.common.configuration.SelectionPropertyDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySheetEntry;

public class ConfigurationViewer
extends TreeViewer {
    private static final Log LOGGER = LogFactory.getLog(ConfigurationViewer.class);
    private static final float DEFAULT_PROPERTY_COLUMN_RATIO = 0.3f;
    private static final String[] COLUMN_LABELS = new String[]{Messages.propertyKey, Messages.propertyValue};
    private static final int EDIT_COLUMN_INDEX = 1;
    private static final int MAX_EDITABLE_TEXT_LENGTH = 2048;
    private final List<Object> contextMenuItems = new LinkedList<Object>();
    private final Tree tree;
    private final LayoutComposite layoutComposite;
    private MenuManager menuManager;
    private final TreeEditor treeEditor;
    private CellEditor cellEditor;
    private ICellEditorListener editorListener;
    private IStatusLineManager statusLineManager;
    private final PropertyChangeListener propertyChangeListener = new UpdatingPropertyChangeListener();

    public ConfigurationViewer(Composite parent) {
        this(parent, 0);
    }

    public ConfigurationViewer(Composite parent, int style) {
        super((Composite)new LayoutComposite(parent, 0), style | 0x10000 | 4 | 0x8000);
        this.tree = this.getTree();
        this.layoutComposite = (LayoutComposite)this.tree.getParent();
        this.tree.setLinesVisible(true);
        this.tree.setHeaderVisible(true);
        this.addColumns();
        TreeColumnLayout treeColumnLayout = new TreeColumnLayout();
        this.layoutComposite.setLayout((Layout)treeColumnLayout);
        TreeColumn[] columns = this.tree.getColumns();
        treeColumnLayout.setColumnData((Widget)columns[0], (ColumnLayoutData)new ColumnWeightData(30, 60));
        treeColumnLayout.setColumnData((Widget)columns[1], (ColumnLayoutData)new ColumnWeightData(70, 140));
        this.hookControl();
        this.treeEditor = new TreeEditor(this.tree);
        this.createEditorListener();
        this.initContextMenuManager();
    }

    protected void inputChanged(Object input, Object oldInput) {
        if (oldInput != null) {
            try {
                Method removeMethod = oldInput.getClass().getMethod("removePropertyChangeListener", PropertyChangeListener.class);
                if (removeMethod != null) {
                    removeMethod.invoke(oldInput, this.propertyChangeListener);
                }
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalArgumentException e) {
                LOGGER.error((Object)e);
            }
            catch (IllegalAccessException e) {
                LOGGER.error((Object)e);
            }
            catch (InvocationTargetException e) {
                LOGGER.error((Object)e);
            }
        }
        if (input != null) {
            try {
                Method addMethod = input.getClass().getMethod("addPropertyChangeListener", PropertyChangeListener.class);
                if (addMethod != null) {
                    addMethod.invoke(input, this.propertyChangeListener);
                }
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalArgumentException e) {
                LOGGER.error((Object)e);
            }
            catch (IllegalAccessException e) {
                LOGGER.error((Object)e);
            }
            catch (InvocationTargetException e) {
                LOGGER.error((Object)e);
            }
        }
        super.inputChanged(input, oldInput);
    }

    private void initContextMenuManager() {
        this.menuManager = new MenuManager("#PopupMenu");
        this.menuManager.setRemoveAllWhenShown(true);
        this.menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                for (Object itemObject : ConfigurationViewer.this.contextMenuItems) {
                    Object item;
                    if (itemObject instanceof IContributionItem) {
                        item = (IContributionItem)itemObject;
                        ConfigurationViewer.this.menuManager.add((IContributionItem)item);
                        continue;
                    }
                    if (itemObject instanceof VisibilityAction) {
                        item = (VisibilityAction)itemObject;
                        if (!item.isVisible()) continue;
                        ConfigurationViewer.this.menuManager.add((IAction)item);
                        continue;
                    }
                    if (itemObject instanceof IAction) {
                        item = (IAction)itemObject;
                        ConfigurationViewer.this.menuManager.add((IAction)item);
                        continue;
                    }
                    throw new AssertionError();
                }
            }
        });
        Menu menu = this.menuManager.createContextMenu((Control)this.tree);
        this.tree.setMenu(menu);
    }

    public void addContextMenuItem(IAction item) {
        this.contextMenuItems.add(item);
    }

    public void addContextMenuItem(IContributionItem item) {
        this.contextMenuItems.add(item);
    }

    protected void fireSelectionChanged(SelectionChangedEvent event) {
        IStructuredSelection structuredSelection;
        Object element;
        SelectionChangedEvent proceedEvent = event;
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection && (element = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof ConfigurationViewerContentProvider.Element) {
            IPropertyDescriptor value = ((ConfigurationViewerContentProvider.Element)element).getPropertyDescriptor();
            if (value != null) {
                SelectionChangedEvent replacementEvent;
                StructuredSelection replacementSelection = new StructuredSelection((Object)value);
                proceedEvent = replacementEvent = new SelectionChangedEvent(event.getSelectionProvider(), (ISelection)replacementSelection);
            } else {
                proceedEvent = null;
            }
        }
        if (proceedEvent != null) {
            super.fireSelectionChanged(proceedEvent);
        }
    }

    private void activateCellEditor(TreeItem item) {
        this.tree.showSelection();
        ConfigurationViewerContentProvider.Element activeProperty = (ConfigurationViewerContentProvider.Element)item.getData();
        this.cellEditor = activeProperty.createPropertyEditor((Composite)this.tree);
        if (this.cellEditor == null) {
            return;
        }
        boolean editable = true;
        Object value = activeProperty.getValue();
        if (value != null) {
            Object editorValue;
            if (this.cellEditor instanceof TextCellEditor) {
                String textValue = value.toString();
                if (textValue.length() > 2048) {
                    editable = false;
                }
                editorValue = textValue;
            } else {
                editorValue = value;
            }
            if (!editable) {
                return;
            }
            this.cellEditor.setValue(editorValue);
        }
        this.cellEditor.activate();
        Control control = this.cellEditor.getControl();
        if (control == null) {
            this.cellEditor.deactivate();
            this.cellEditor = null;
            return;
        }
        this.cellEditor.addListener(this.editorListener);
        CellEditor.LayoutData layout = this.cellEditor.getLayoutData();
        this.treeEditor.horizontalAlignment = layout.horizontalAlignment;
        this.treeEditor.grabHorizontal = layout.grabHorizontal;
        this.treeEditor.minimumWidth = layout.minimumWidth;
        this.treeEditor.setEditor(control, item, 1);
        this.setErrorMessage(this.cellEditor.getErrorMessage());
        this.cellEditor.setFocus();
    }

    private void addColumns() {
        TreeColumn[] columns = this.tree.getColumns();
        int i = 0;
        while (i < COLUMN_LABELS.length) {
            String string = COLUMN_LABELS[i];
            if (string != null) {
                TreeColumn column = i < columns.length ? columns[i] : new TreeColumn(this.tree, 0);
                column.setText(string);
                column.setResizable(i < COLUMN_LABELS.length - 1);
            }
            ++i;
        }
    }

    protected void applyEditorValue() {
        if (this.cellEditor == null) {
            return;
        }
        if (!this.cellEditor.isValueValid()) {
            this.setErrorMessage(this.cellEditor.getErrorMessage());
            return;
        }
        TreeItem treeItem = this.treeEditor.getItem();
        if (treeItem == null || treeItem.isDisposed()) {
            return;
        }
        ConfigurationViewerContentProvider.Element property = (ConfigurationViewerContentProvider.Element)treeItem.getData();
        IPropertyDescriptor propertyDescriptor = property.getPropertyDescriptor();
        Object newValue = propertyDescriptor instanceof SelectionPropertyDescriptor ? ((SelectionPropertyDescriptor)propertyDescriptor).getValue((Integer)this.cellEditor.getValue()) : this.cellEditor.getValue();
        Object oldValue = property.getValue();
        if (property instanceof ConfigurationViewerContentProvider.Leaf && oldValue != newValue || oldValue != null && !oldValue.equals(newValue)) {
            property.setValue(newValue);
            this.update(property, null);
            this.update(property.getParent(), null);
        }
    }

    private void createEditorListener() {
        this.editorListener = new ICellEditorListener(){

            public void cancelEditor() {
                ConfigurationViewer.this.deactivateCellEditor();
            }

            public void editorValueChanged(boolean oldValidState, boolean newValidState) {
            }

            public void applyEditorValue() {
                ConfigurationViewer.this.applyEditorValue();
            }
        };
    }

    private void deactivateCellEditor() {
        this.treeEditor.setEditor(null, null, 1);
        if (this.cellEditor != null) {
            this.cellEditor.deactivate();
            this.cellEditor.removeListener(this.editorListener);
            this.cellEditor = null;
        }
        this.setErrorMessage(null);
    }

    private void entrySelectionChanged() {
        SelectionChangedEvent changeEvent = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
        this.fireSelectionChanged(changeEvent);
    }

    private void handleSelect(TreeItem selection) {
        if (this.cellEditor != null) {
            this.deactivateCellEditor();
        }
        if (selection == null) {
            this.setMessage(null);
            this.setErrorMessage(null);
        } else {
            Object object = selection.getData();
            if (object instanceof ConfigurationViewerContentProvider.Element) {
                ConfigurationViewerContentProvider.Element activeProperty = (ConfigurationViewerContentProvider.Element)object;
                this.setMessage(activeProperty.getDescription());
                this.activateCellEditor(selection);
            }
            if (object instanceof IPropertySheetEntry) {
                IPropertySheetEntry activeEntry = (IPropertySheetEntry)object;
                this.setMessage(activeEntry.getDescription());
                this.activateCellEditor(selection);
            }
        }
        this.entrySelectionChanged();
    }

    private void hookControl() {
        this.tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ConfigurationViewer.this.cellEditor == null || !ConfigurationViewer.this.cellEditor.isActivated()) {
                    ConfigurationViewer.this.updateStatusLine(e.item);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                if (e.item instanceof TreeItem) {
                    ConfigurationViewer.this.handleSelect((TreeItem)e.item);
                }
            }
        });
        this.tree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent event) {
                Point pt = new Point(event.x, event.y);
                TreeItem item = ConfigurationViewer.this.tree.getItem(pt);
                if (item != null) {
                    ConfigurationViewer.this.handleSelect(item);
                }
            }
        });
        this.tree.addTreeListener(new TreeListener(){

            public void treeExpanded(TreeEvent event) {
                ConfigurationViewer.this.handleTreeExpand(event);
            }

            public void treeCollapsed(TreeEvent event) {
                ConfigurationViewer.this.handleTreeCollapse(event);
            }
        });
        this.tree.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.character == '\u001b') {
                    ConfigurationViewer.this.deactivateCellEditor();
                } else if (e.keyCode == 0x100000E) {
                    ConfigurationViewer.this.setInput(ConfigurationViewer.this.getInput());
                }
            }
        });
    }

    protected void updateStatusLine(Widget item) {
        this.setMessage(null);
        this.setErrorMessage(null);
    }

    private void setErrorMessage(String errorMessage) {
        if (this.statusLineManager != null) {
            this.statusLineManager.setErrorMessage(errorMessage);
        }
    }

    private void setMessage(String message) {
        if (this.statusLineManager != null) {
            this.statusLineManager.setMessage(message);
        }
    }

    private static final class LayoutComposite
    extends Composite {
        private boolean first = true;
        private Integer widthHint = 0;

        LayoutComposite(Composite parent, int style) {
            super(parent, style);
        }

        public Point computeSize(int wHint, int hHint, boolean changed) {
            if (wHint != -1) {
                if (!this.first) {
                    this.widthHint = wHint;
                }
                this.first = false;
            }
            if (this.widthHint != null) {
                wHint = Math.min(this.widthHint, this.getClientArea().width);
            }
            Point result = super.computeSize(wHint, hHint, changed);
            if (this.first && wHint == -1) {
                this.widthHint = result.x;
            }
            result.x = 0;
            return result;
        }
    }

    public class UpdatingPropertyChangeListener
    implements PropertyChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if (!ConfigurationViewer.this.tree.isDisposed()) {
                ConfigurationViewer.this.tree.update();
            }
        }
    }

    public static interface VisibilityAction
    extends IAction {
        public void setVisible(boolean var1);

        public boolean isVisible();
    }
}

