/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.start.validators.internal;

import de.rcenvironment.core.configuration.ConfigurationService;
import de.rcenvironment.core.start.common.validation.api.InstanceValidationResult;
import de.rcenvironment.core.start.common.validation.api.InstanceValidationResultFactory;
import de.rcenvironment.core.start.common.validation.spi.DefaultInstanceValidator;
import java.io.File;

public class OriginalProfileDirectoryAccessibleValidator
extends DefaultInstanceValidator {
    private static ConfigurationService configService;

    public InstanceValidationResult validate() {
        File originalProfileDir = configService.getOriginalProfileDirectory();
        if (!(originalProfileDir.exists() && originalProfileDir.isDirectory() && originalProfileDir.canRead() && originalProfileDir.canWrite())) {
            String errorMessage = "The specified profile folder " + originalProfileDir.getAbsolutePath() + " is either not readable or not writeable. Probably the proper permissions are not granted to your user account." + " Choose another profile directory. (See the user guide for more information about the profile directory.)";
            return InstanceValidationResultFactory.createResultForFailureWhichRequiresInstanceShutdown((String)"Profile folder not accessible.", (String)errorMessage, (String)errorMessage);
        }
        return InstanceValidationResultFactory.createResultForPassed((String)"Original profile directory is accessible.");
    }

    protected void bindConfigurationService(ConfigurationService configIn) {
        configService = configIn;
    }
}

