/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.datamanagement.internal;

import de.rcenvironment.core.authorization.AuthorizationException;
import de.rcenvironment.core.communication.api.PlatformService;
import de.rcenvironment.core.datamanagement.RemotableFileDataService;
import de.rcenvironment.core.datamanagement.backend.DataBackend;
import de.rcenvironment.core.datamanagement.backend.MetaDataBackendService;
import de.rcenvironment.core.datamanagement.commons.BinaryReference;
import de.rcenvironment.core.datamanagement.commons.DataReference;
import de.rcenvironment.core.datamanagement.commons.DistributableInputStream;
import de.rcenvironment.core.datamanagement.commons.MetaData;
import de.rcenvironment.core.datamanagement.commons.MetaDataSet;
import de.rcenvironment.core.datamanagement.internal.BackendSupport;
import de.rcenvironment.core.datamodel.api.CompressionFormat;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.TempFileServiceAccess;
import de.rcenvironment.core.utils.common.rpc.RemoteOperationException;
import de.rcenvironment.core.utils.common.security.AllowRemoteAccess;
import de.rcenvironment.toolkit.modules.concurrency.api.TaskDescription;
import de.rcenvironment.toolkit.utils.common.IdGenerator;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;

public class RemotableFileDataServiceImpl
implements RemotableFileDataService {
    protected static final String PASSED_USER_IS_NOT_VALID = "Passed user representation is not valid.";
    private static final Log LOGGER = LogFactory.getLog(RemotableFileDataServiceImpl.class);
    private static final int UPLOAD_TEMP_FILE_STREAM_BUFFER_SIZE = 65536;
    private static final int UPLOAD_SESSION_ID_LENGTH = 32;
    protected PlatformService platformService;
    protected BundleContext context;
    private Map<String, UploadHolder> uploads = Collections.synchronizedMap(new HashMap());

    protected void activate(BundleContext bundleContext) {
        this.context = bundleContext;
    }

    protected void bindPlatformService(PlatformService newPlatformService) {
        this.platformService = newPlatformService;
    }

    @Override
    @AllowRemoteAccess
    public void deleteReference(String binaryReferenceKey) throws AuthorizationException {
        DataBackend dataService = BackendSupport.getDataBackend();
        URI location = dataService.suggestLocation(UUID.fromString(binaryReferenceKey));
        dataService.delete(location);
    }

    @Override
    @AllowRemoteAccess
    public InputStream getStreamFromDataReference(DataReference dataReference, Boolean calledFromRemote) throws AuthorizationException {
        DataBackend dataBackend = BackendSupport.getDataBackend();
        String gzipReferenceKey = null;
        for (BinaryReference br : dataReference.getBinaryReferences()) {
            if (!br.getCompression().equals((Object)CompressionFormat.GZIP)) continue;
            gzipReferenceKey = br.getBinaryReferenceKey();
        }
        URI location = BackendSupport.getDataBackend().suggestLocation(UUID.fromString(gzipReferenceKey));
        DistributableInputStream stream = new DistributableInputStream(dataReference, (InputStream)dataBackend.get(location));
        if (calledFromRemote.booleanValue()) {
            try {
                stream.getLocalInputStream().close();
            }
            catch (IOException e) {
                LogFactory.getLog(RemotableFileDataServiceImpl.class).error((Object)"Failed to close local, transient input stream before sent to another node", (Throwable)e);
            }
        }
        return stream;
    }

    @Override
    @AllowRemoteAccess
    public DataReference newReferenceFromStream(InputStream inputStream, MetaDataSet metaDataSet) {
        UUID uuid = UUID.randomUUID();
        DataBackend dataBackend = BackendSupport.getDataBackend();
        URI location = dataBackend.suggestLocation(uuid);
        dataBackend.put(location, inputStream);
        BinaryReference binaryReference = new BinaryReference(uuid.toString(), CompressionFormat.GZIP, "1");
        HashSet<BinaryReference> binaryReferences = new HashSet<BinaryReference>();
        binaryReferences.add(binaryReference);
        DataReference dataReference = new DataReference(uuid.toString(), this.platformService.getLocalDefaultLogicalNodeId(), binaryReferences);
        MetaDataBackendService metaDataBackend = BackendSupport.getMetaDataBackend();
        if (metaDataSet.getValue(new MetaData("rce.common.component_run_id", true, true)) != null) {
            metaDataBackend.addDataReferenceToComponentRun(Long.valueOf(metaDataSet.getValue(new MetaData("rce.common.component_run_id", true, true))), dataReference);
        } else if (metaDataSet.getValue(new MetaData("rce.common.workflow_run_id", true, true)) != null) {
            metaDataBackend.addDataReferenceToWorkflowRun(Long.valueOf(metaDataSet.getValue(new MetaData("rce.common.workflow_run_id", true, true))), dataReference);
        } else if (metaDataSet.getValue(new MetaData("rce.common.component_instance_id", true, true)) != null) {
            metaDataBackend.addDataReferenceToComponentInstance(Long.valueOf(metaDataSet.getValue(new MetaData("rce.common.component_instance_id", true, true))), dataReference);
        } else {
            LOGGER.warn((Object)"Data reference could not be added because not component run id, workflow run id or component instance id was given");
        }
        return dataReference;
    }

    @Override
    @AllowRemoteAccess
    public String initializeUpload() throws IOException {
        String id = IdGenerator.fastRandomHexString((int)32);
        UploadHolder upload = new UploadHolder();
        this.uploads.put(id, upload);
        return id;
    }

    @Override
    @AllowRemoteAccess
    public long appendToUpload(String id, byte[] data) throws IOException {
        UploadHolder upload = this.safeGetUploadById(id);
        return upload.appendData(data);
    }

    @Override
    @AllowRemoteAccess
    public void finishUpload(String id, final MetaDataSet metaDataSet) throws IOException {
        final UploadHolder upload = this.safeGetUploadById(id);
        final File tempFile = upload.finishAndGetFile();
        if (tempFile == null) {
            throw new IOException("Internal error: upload stream was valid, but no file set");
        }
        ConcurrencyUtils.getAsyncTaskService().execute(new Runnable(){

            @Override
            @TaskDescription(value="Generate data reference from upload")
            public void run() {
                try {
                    BufferedInputStream fis = new BufferedInputStream(new FileInputStream(tempFile), 65536);
                    try {
                        DataReference reference = RemotableFileDataServiceImpl.this.newReferenceFromStream(fis, metaDataSet);
                        upload.setDataReference(reference);
                    }
                    finally {
                        IOUtils.closeQuietly((InputStream)fis);
                    }
                }
                catch (IOException e) {
                    upload.setAsyncException(e);
                }
            }
        });
    }

    @Override
    @AllowRemoteAccess
    public DataReference pollUploadForDataReference(String id) throws IOException {
        UploadHolder upload = this.safeGetUploadById(id);
        DataReference reference = upload.getDataReference();
        if (reference != null) {
            this.uploads.remove(id);
            return reference;
        }
        if (upload.getAsyncException() != null) {
            this.uploads.remove(id);
            throw upload.getAsyncException();
        }
        return null;
    }

    private UploadHolder safeGetUploadById(String id) throws IOException {
        UploadHolder upload = this.uploads.get(id);
        if (upload == null) {
            throw new IOException("Invalid upload id");
        }
        return upload;
    }

    @Override
    @AllowRemoteAccess
    public DataReference uploadInSingleStep(byte[] data, MetaDataSet metaDataSet) throws IOException, RemoteOperationException {
        UploadHolder upload = new UploadHolder();
        upload.appendData(data);
        File tempFile = upload.finishAndGetFile();
        if (tempFile == null) {
            throw new IOException("Internal error: upload stream was valid, but no file set");
        }
        BufferedInputStream fis = new BufferedInputStream(new FileInputStream(tempFile), 65536);
        DataReference reference = this.newReferenceFromStream(fis, metaDataSet);
        upload.setDataReference(reference);
        IOUtils.closeQuietly((InputStream)fis);
        return upload.getDataReference();
    }

    private static class UploadHolder {
        private File tempFile = TempFileServiceAccess.getInstance().createTempFileFromPattern("upload.*.tmp");
        private OutputStream outputStream = new BufferedOutputStream(new FileOutputStream(this.tempFile), 65536);
        private long totalBytesWritten = 0L;
        private DataReference dataReference;
        private IOException asyncException;

        UploadHolder() throws IOException {
        }

        public long appendData(byte[] data) throws IOException {
            this.outputStream.write(data);
            this.totalBytesWritten += (long)data.length;
            return this.totalBytesWritten;
        }

        public File finishAndGetFile() throws IOException {
            this.outputStream.close();
            this.outputStream = null;
            return this.tempFile;
        }

        public synchronized void setDataReference(DataReference dataReference) throws IOException {
            this.dataReference = dataReference;
            TempFileServiceAccess.getInstance().disposeManagedTempDirOrFile(this.tempFile);
            this.tempFile = null;
        }

        public synchronized DataReference getDataReference() {
            return this.dataReference;
        }

        public synchronized void setAsyncException(IOException asyncException) {
            this.asyncException = asyncException;
        }

        public synchronized IOException getAsyncException() {
            return this.asyncException;
        }
    }
}

