/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.datamanagement.internal;

import de.rcenvironment.core.communication.api.CommunicationService;
import de.rcenvironment.core.communication.common.CommunicationException;
import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import de.rcenvironment.core.communication.common.LogicalNodeId;
import de.rcenvironment.core.communication.common.ResolvableNodeId;
import de.rcenvironment.core.communication.management.WorkflowHostService;
import de.rcenvironment.core.datamanagement.MetaDataService;
import de.rcenvironment.core.datamanagement.RemotableMetaDataService;
import de.rcenvironment.core.datamanagement.commons.WorkflowRun;
import de.rcenvironment.core.datamanagement.commons.WorkflowRunDescription;
import de.rcenvironment.core.datamanagement.commons.WorkflowRunTimline;
import de.rcenvironment.core.datamodel.api.FinalComponentRunState;
import de.rcenvironment.core.datamodel.api.FinalComponentState;
import de.rcenvironment.core.datamodel.api.TimelineIntervalType;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.rpc.RemoteOperationException;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncExceptionListener;
import de.rcenvironment.toolkit.modules.concurrency.api.CallablesGroup;
import de.rcenvironment.toolkit.modules.concurrency.api.TaskDescription;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;

public class MetaDataServiceImpl
implements MetaDataService {
    private CommunicationService communicationService;
    private WorkflowHostService workflowHostService;
    private final Log log = LogFactory.getLog(this.getClass());

    @Override
    public Long addComponentRun(Long componentInstanceId, String nodeId, Integer count, Long starttime, ResolvableNodeId storageNodeId) throws CommunicationException {
        try {
            return this.getRemoteMetaDataService(storageNodeId).addComponentRun(componentInstanceId, nodeId, count, starttime);
        }
        catch (RemoteOperationException e) {
            throw new CommunicationException(String.valueOf(StringUtils.format((String)"Failed to add component run from remote node @%s: ", (Object[])new Object[]{storageNodeId})) + e.getMessage());
        }
    }

    @Override
    public void addInputDatum(Long componentRunId, Long typedDatumId, Long endpointInstanceId, Integer count, ResolvableNodeId storageNodeId) throws CommunicationException {
        try {
            this.getRemoteMetaDataService(storageNodeId).addInputDatum(componentRunId, typedDatumId, endpointInstanceId, count);
        }
        catch (RemoteOperationException e) {
            throw new CommunicationException(String.valueOf(StringUtils.format((String)"Failed to add input datum from remote node @%s: ", (Object[])new Object[]{storageNodeId})) + e.getMessage());
        }
    }

    @Override
    public Long addOutputDatum(Long componentRunId, Long endpointInstanceId, String datum, Integer count, ResolvableNodeId storageNodeId) throws CommunicationException {
        try {
            return this.getRemoteMetaDataService(storageNodeId).addOutputDatum(componentRunId, endpointInstanceId, datum, count);
        }
        catch (RemoteOperationException e) {
            throw new CommunicationException(String.valueOf(StringUtils.format((String)"Failed to add output datum from remote node @%s: ", (Object[])new Object[]{storageNodeId})) + e.getMessage());
        }
    }

    @Override
    public void addComponentRunProperties(Long componentRunId, Map<String, String> properties, ResolvableNodeId storageNodeId) throws CommunicationException {
        try {
            this.getRemoteMetaDataService(storageNodeId).addComponentRunProperties(componentRunId, properties);
        }
        catch (RemoteOperationException e) {
            throw new CommunicationException(String.valueOf(StringUtils.format((String)"Failed to add component run properties from remote node @%s: ", (Object[])new Object[]{storageNodeId})) + e.getMessage());
        }
    }

    @Override
    public Long addTimelineInterval(Long workflowRunId, TimelineIntervalType intervalType, long starttime, Long relatedComponentId, ResolvableNodeId storageNodeId) throws CommunicationException {
        try {
            return this.getRemoteMetaDataService(storageNodeId).addTimelineInterval(workflowRunId, intervalType, starttime, relatedComponentId);
        }
        catch (RemoteOperationException e) {
            throw new CommunicationException(String.valueOf(StringUtils.format((String)"Failed to add timeline interval from remote node @%s: ", (Object[])new Object[]{storageNodeId})) + e.getMessage());
        }
    }

    @Override
    public void setTimelineIntervalFinished(Long timelineIntervalId, long endtime, ResolvableNodeId storageNodeId) throws CommunicationException {
        try {
            this.getRemoteMetaDataService(storageNodeId).setTimelineIntervalFinished(timelineIntervalId, endtime);
        }
        catch (RemoteOperationException e) {
            throw new CommunicationException(String.valueOf(StringUtils.format((String)"Failed to set endtime of timeline interval from remote node @%s: ", (Object[])new Object[]{storageNodeId})) + e.getMessage());
        }
    }

    @Override
    public void setOrUpdateHistoryDataItem(Long componentRunId, String historyDataItem, ResolvableNodeId storageNodeId) throws CommunicationException {
        try {
            this.getRemoteMetaDataService(storageNodeId).setOrUpdateHistoryDataItem(componentRunId, historyDataItem);
        }
        catch (RemoteOperationException e) {
            throw new CommunicationException(String.valueOf(StringUtils.format((String)"Failed to update history data item from remote node @%s: ", (Object[])new Object[]{storageNodeId})) + e.getMessage());
        }
    }

    @Override
    public void setComponentRunFinished(Long componentRunId, Long endtime, FinalComponentRunState finalState, ResolvableNodeId storageNodeId) throws CommunicationException {
        try {
            this.getRemoteMetaDataService(storageNodeId).setComponentRunFinished(componentRunId, endtime, finalState);
        }
        catch (RemoteOperationException e) {
            throw new CommunicationException(String.valueOf(StringUtils.format((String)"Failed to set endtime of component run from remote node @%s: ", (Object[])new Object[]{storageNodeId})) + e.getMessage());
        }
    }

    @Override
    public void setComponentInstanceFinalState(Long componentInstanceId, FinalComponentState finalState, ResolvableNodeId storageNodeId) throws CommunicationException {
        try {
            this.getRemoteMetaDataService(storageNodeId).setComponentInstanceFinalState(componentInstanceId, finalState);
        }
        catch (RemoteOperationException e) {
            throw new CommunicationException(String.valueOf(StringUtils.format((String)"Failed to set final state of component instance from remote node @%s: ", (Object[])new Object[]{storageNodeId})) + e.getMessage());
        }
    }

    @Override
    public Set<WorkflowRunDescription> getWorkflowRunDescriptions() throws CommunicationException {
        HashSet<WorkflowRunDescription> descriptions = new HashSet<WorkflowRunDescription>();
        CallablesGroup callablesGroup = ConcurrencyUtils.getFactory().createCallablesGroup(Set.class);
        for (final InstanceNodeSessionId remoteInstanceSessionId : this.workflowHostService.getWorkflowHostNodesAndSelf()) {
            callablesGroup.add((Callable)new Callable<Set>(){

                @Override
                @TaskDescription(value="Distributed query: getWorkflowDescriptions()")
                public Set<WorkflowRunDescription> call() throws Exception {
                    Set<WorkflowRunDescription> workflowRunDescriptions = MetaDataServiceImpl.this.getRemoteMetaDataService((ResolvableNodeId)remoteInstanceSessionId).getWorkflowRunDescriptions();
                    workflowRunDescriptions = this.fixInconsistentControllerNodeIds(remoteInstanceSessionId, workflowRunDescriptions);
                    return workflowRunDescriptions;
                }

                private Set<WorkflowRunDescription> fixInconsistentControllerNodeIds(InstanceNodeSessionId remoteNodeId, Set<WorkflowRunDescription> workflowRunDescriptions) {
                    boolean hasInconsistenControllerNodeIds = false;
                    for (WorkflowRunDescription wrd : workflowRunDescriptions) {
                        LogicalNodeId controllerNodeId = wrd.getControllerLogicalNodeId();
                        LogicalNodeId dmNodeId = wrd.getStorageLogicalNodeId();
                        if (remoteInstanceSessionId.isSameInstanceNodeAs((ResolvableNodeId)controllerNodeId) && remoteInstanceSessionId.isSameInstanceNodeAs((ResolvableNodeId)dmNodeId)) continue;
                        hasInconsistenControllerNodeIds = true;
                    }
                    if (hasInconsistenControllerNodeIds) {
                        HashSet<WorkflowRunDescription> newSet = new HashSet<WorkflowRunDescription>();
                        for (WorkflowRunDescription wrd : workflowRunDescriptions) {
                            LogicalNodeId controllerNodeId = wrd.getControllerLogicalNodeId();
                            LogicalNodeId dmNodeId = wrd.getStorageLogicalNodeId();
                            if (!remoteInstanceSessionId.isSameInstanceNodeAs((ResolvableNodeId)controllerNodeId) || !remoteInstanceSessionId.isSameInstanceNodeAs((ResolvableNodeId)dmNodeId)) {
                                MetaDataServiceImpl.this.log.warn((Object)StringUtils.format((String)"Replacing an inconsistent controller and/or storage node id (%s, %s) in workflow run #%d received from node %s - most likely, the remote node's id has changed since the workflow was run", (Object[])new Object[]{controllerNodeId, dmNodeId, wrd.getWorkflowRunID(), remoteNodeId}));
                                newSet.add(WorkflowRunDescription.cloneAndReplaceNodeIds(wrd, remoteInstanceSessionId.getInstanceNodeIdString()));
                                continue;
                            }
                            newSet.add(wrd);
                        }
                        workflowRunDescriptions = newSet;
                    }
                    return workflowRunDescriptions;
                }
            });
        }
        List results = callablesGroup.executeParallel(new AsyncExceptionListener(){

            public void onAsyncException(Exception e) {
                MetaDataServiceImpl.this.log.warn((Object)("Failed to query a node for workflow data management information: " + e.toString()));
            }
        });
        for (Collection singleResult : results) {
            if (singleResult == null) continue;
            descriptions.addAll(singleResult);
        }
        return descriptions;
    }

    @Override
    public WorkflowRun getWorkflowRun(Long workflowRunId, ResolvableNodeId storageNodeId) throws CommunicationException {
        try {
            return this.getRemoteMetaDataService(storageNodeId).getWorkflowRun(workflowRunId);
        }
        catch (RemoteOperationException e) {
            throw new CommunicationException(String.valueOf(StringUtils.format((String)"Failed to get workflow run from remote node @%s: ", (Object[])new Object[]{storageNodeId})) + e.getMessage());
        }
    }

    @Override
    public WorkflowRunTimline getWorkflowTimeline(Long workflowRunId, ResolvableNodeId storageNodeId) throws CommunicationException {
        try {
            return this.getRemoteMetaDataService(storageNodeId).getWorkflowTimeline(workflowRunId);
        }
        catch (RemoteOperationException e) {
            throw new CommunicationException(String.valueOf(StringUtils.format((String)"Failed to get workflow timeline from remote node @%s: ", (Object[])new Object[]{storageNodeId})) + e.getMessage());
        }
    }

    @Override
    public Boolean deleteWorkflowRun(Long workflowRunId, ResolvableNodeId storageNodeId) throws CommunicationException {
        try {
            return this.getRemoteMetaDataService(storageNodeId).deleteWorkflowRun(workflowRunId);
        }
        catch (RemoteOperationException e) {
            throw new CommunicationException(String.valueOf(StringUtils.format((String)"Failed to delete worklfow run from remote node @%s: ", (Object[])new Object[]{storageNodeId})) + e.getMessage());
        }
    }

    @Override
    public Boolean deleteWorkflowRunFiles(Long workflowRunId, ResolvableNodeId storageNodeId) throws CommunicationException {
        try {
            return this.getRemoteMetaDataService(storageNodeId).deleteWorkflowRunFiles(workflowRunId);
        }
        catch (RemoteOperationException e) {
            throw new CommunicationException(String.valueOf(StringUtils.format((String)"Failed to delete files of worklfow run from remote node @%s: ", (Object[])new Object[]{storageNodeId})) + e.getMessage());
        }
    }

    protected void activate(BundleContext bundleContext) {
    }

    protected void bindCommunicationService(CommunicationService newCommunicationService) {
        this.communicationService = newCommunicationService;
    }

    protected void bindWorkflowHostService(WorkflowHostService newWorkflowHostService) {
        this.workflowHostService = newWorkflowHostService;
    }

    private RemotableMetaDataService getRemoteMetaDataService(ResolvableNodeId nodeId) throws RemoteOperationException {
        return (RemotableMetaDataService)this.communicationService.getRemotableService(RemotableMetaDataService.class, nodeId);
    }
}

