/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.start.gui.internal;

import de.rcenvironment.core.gui.resources.api.ImageManager;
import de.rcenvironment.core.gui.resources.api.ImageSource;
import de.rcenvironment.core.gui.resources.api.StandardImages;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ContributionItemFactory;
import org.eclipse.ui.actions.NewWizardMenu;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.actions.CommandAction;
import org.eclipse.ui.internal.registry.ActionSetRegistry;
import org.eclipse.ui.internal.registry.IActionSetDescriptor;
import org.eclipse.ui.services.IServiceLocator;

public class ApplicationActionBarAdvisor
extends ActionBarAdvisor {
    private static final Log LOGGER = LogFactory.getLog(ApplicationActionBarAdvisor.class);
    private NewWizardMenu newWizardMenu;
    private ActionFactory.IWorkbenchAction closeAction;
    private ActionFactory.IWorkbenchAction closeAllAction;
    private ActionFactory.IWorkbenchAction saveAction;
    private ActionFactory.IWorkbenchAction saveAsAction;
    private ActionFactory.IWorkbenchAction saveAllAction;
    private ActionFactory.IWorkbenchAction refreshAction;
    private ActionFactory.IWorkbenchAction printAction;
    private CommandAction restartAction;
    private ActionFactory.IWorkbenchAction importAction;
    private ActionFactory.IWorkbenchAction exportAction;
    private ActionFactory.IWorkbenchAction propertiesAction;
    private ActionFactory.IWorkbenchAction exitAction;
    private ActionFactory.IWorkbenchAction undoAction;
    private ActionFactory.IWorkbenchAction redoAction;
    private ActionFactory.IWorkbenchAction cutAction;
    private ActionFactory.IWorkbenchAction copyAction;
    private ActionFactory.IWorkbenchAction pasteAction;
    private ActionFactory.IWorkbenchAction deleteAction;
    private ActionFactory.IWorkbenchAction selectAllAction;
    private ActionFactory.IWorkbenchAction findReplaceAction;
    private ActionFactory.IWorkbenchAction newWorkbenchWindowAction;
    private ActionFactory.IWorkbenchAction newEditorWindowAction;
    private ActionFactory.IWorkbenchAction editActionSetAction;
    private ActionFactory.IWorkbenchAction savePerspectiveAction;
    private ActionFactory.IWorkbenchAction resetPerspectiveAction;
    private ActionFactory.IWorkbenchAction closePerspectiveAction;
    private ActionFactory.IWorkbenchAction closeAllPerspectivesAction;
    private ActionFactory.IWorkbenchAction preferenceAction;
    private ActionFactory.IWorkbenchAction showPartPaneMenuAction;
    private ActionFactory.IWorkbenchAction showViewMenuAction;
    private ActionFactory.IWorkbenchAction maximizePartAction;
    private ActionFactory.IWorkbenchAction minimizePartAction;
    private ActionFactory.IWorkbenchAction activateEditorAction;
    private ActionFactory.IWorkbenchAction nextEditorAction;
    private ActionFactory.IWorkbenchAction prevEditorAction;
    private ActionFactory.IWorkbenchAction switchToEditorAction;
    private ActionFactory.IWorkbenchAction openEditorDropDownAction;
    private ActionFactory.IWorkbenchAction nextPartAction;
    private ActionFactory.IWorkbenchAction prevPartAction;
    private ActionFactory.IWorkbenchAction nextPerspectiveAction;
    private ActionFactory.IWorkbenchAction prevPerspectiveAction;
    private ActionFactory.IWorkbenchAction helpAction;
    private ActionFactory.IWorkbenchAction dynamicHelpAction;
    private ActionFactory.IWorkbenchAction aboutAction;
    private ActionFactory.IWorkbenchAction newWizardDropDownAction;
    private IWorkbenchWindow workbenchWindow;

    public ApplicationActionBarAdvisor(IActionBarConfigurer configurer) {
        super(configurer);
    }

    protected void makeActions(IWorkbenchWindow window) {
        this.workbenchWindow = window;
        this.newWizardMenu = new NewWizardMenu(window);
        this.closeAction = ActionFactory.CLOSE.create(window);
        this.register((IAction)this.closeAction);
        this.closeAllAction = ActionFactory.CLOSE_ALL.create(window);
        this.register((IAction)this.closeAllAction);
        this.saveAction = ActionFactory.SAVE.create(window);
        this.register((IAction)this.saveAction);
        this.saveAsAction = ActionFactory.SAVE_AS.create(window);
        this.register((IAction)this.saveAsAction);
        this.saveAllAction = ActionFactory.SAVE_ALL.create(window);
        this.register((IAction)this.saveAllAction);
        this.refreshAction = ActionFactory.REFRESH.create(window);
        this.register((IAction)this.refreshAction);
        this.printAction = ActionFactory.PRINT.create(window);
        this.register((IAction)this.printAction);
        this.restartAction = new CommandAction((IServiceLocator)window, "org.eclipse.ui.file.restartWorkbench");
        this.restartAction.setId("restart");
        this.restartAction.setText("Restart");
        this.register((IAction)this.restartAction);
        this.importAction = ActionFactory.IMPORT.create(window);
        this.register((IAction)this.importAction);
        this.exportAction = ActionFactory.EXPORT.create(window);
        this.register((IAction)this.exportAction);
        this.propertiesAction = ActionFactory.PROPERTIES.create(window);
        this.register((IAction)this.propertiesAction);
        this.exitAction = ActionFactory.QUIT.create(window);
        this.register((IAction)this.exitAction);
        this.undoAction = ActionFactory.UNDO.create(window);
        this.register((IAction)this.undoAction);
        this.redoAction = ActionFactory.REDO.create(window);
        this.register((IAction)this.redoAction);
        this.cutAction = ActionFactory.CUT.create(window);
        this.register((IAction)this.cutAction);
        this.copyAction = ActionFactory.COPY.create(window);
        this.register((IAction)this.copyAction);
        this.pasteAction = ActionFactory.PASTE.create(window);
        this.register((IAction)this.pasteAction);
        this.deleteAction = ActionFactory.DELETE.create(window);
        this.deleteAction.setImageDescriptor(ImageManager.getInstance().getImageDescriptor((ImageSource)StandardImages.DELETE_16));
        this.register((IAction)this.deleteAction);
        this.selectAllAction = ActionFactory.SELECT_ALL.create(window);
        this.register((IAction)this.selectAllAction);
        this.findReplaceAction = ActionFactory.FIND.create(window);
        this.register((IAction)this.findReplaceAction);
        this.newWorkbenchWindowAction = ActionFactory.OPEN_NEW_WINDOW.create(window);
        this.newWorkbenchWindowAction.setText("&New Window");
        this.register((IAction)this.newWorkbenchWindowAction);
        this.newEditorWindowAction = ActionFactory.NEW_EDITOR.create(window);
        this.register((IAction)this.newEditorWindowAction);
        this.editActionSetAction = ActionFactory.EDIT_ACTION_SETS.create(window);
        this.register((IAction)this.editActionSetAction);
        this.savePerspectiveAction = ActionFactory.SAVE_PERSPECTIVE.create(window);
        this.register((IAction)this.savePerspectiveAction);
        this.resetPerspectiveAction = ActionFactory.RESET_PERSPECTIVE.create(window);
        this.register((IAction)this.resetPerspectiveAction);
        this.closePerspectiveAction = ActionFactory.CLOSE_PERSPECTIVE.create(window);
        this.register((IAction)this.closePerspectiveAction);
        this.closeAllPerspectivesAction = ActionFactory.CLOSE_ALL_PERSPECTIVES.create(window);
        this.register((IAction)this.closeAllPerspectivesAction);
        this.showPartPaneMenuAction = ActionFactory.SHOW_PART_PANE_MENU.create(window);
        this.register((IAction)this.showPartPaneMenuAction);
        this.showViewMenuAction = ActionFactory.SHOW_VIEW_MENU.create(window);
        this.register((IAction)this.showViewMenuAction);
        this.maximizePartAction = ActionFactory.MAXIMIZE.create(window);
        this.register((IAction)this.maximizePartAction);
        this.minimizePartAction = ActionFactory.MINIMIZE.create(window);
        this.register((IAction)this.minimizePartAction);
        this.activateEditorAction = ActionFactory.ACTIVATE_EDITOR.create(window);
        this.register((IAction)this.activateEditorAction);
        this.nextEditorAction = ActionFactory.NEXT_EDITOR.create(window);
        this.register((IAction)this.nextEditorAction);
        this.prevEditorAction = ActionFactory.PREVIOUS_EDITOR.create(window);
        this.register((IAction)this.prevEditorAction);
        ActionFactory.linkCycleActionPair((ActionFactory.IWorkbenchAction)this.nextEditorAction, (ActionFactory.IWorkbenchAction)this.prevEditorAction);
        this.switchToEditorAction = ActionFactory.SHOW_OPEN_EDITORS.create(window);
        this.register((IAction)this.switchToEditorAction);
        this.openEditorDropDownAction = ActionFactory.SHOW_WORKBOOK_EDITORS.create(window);
        this.register((IAction)this.openEditorDropDownAction);
        this.nextPartAction = ActionFactory.NEXT_PART.create(window);
        this.register((IAction)this.nextPartAction);
        this.prevPartAction = ActionFactory.PREVIOUS_PART.create(window);
        this.register((IAction)this.prevPartAction);
        ActionFactory.linkCycleActionPair((ActionFactory.IWorkbenchAction)this.nextPartAction, (ActionFactory.IWorkbenchAction)this.prevPartAction);
        this.nextPerspectiveAction = ActionFactory.NEXT_PERSPECTIVE.create(window);
        this.register((IAction)this.nextPerspectiveAction);
        this.prevPerspectiveAction = ActionFactory.PREVIOUS_PERSPECTIVE.create(window);
        this.register((IAction)this.prevPerspectiveAction);
        ActionFactory.linkCycleActionPair((ActionFactory.IWorkbenchAction)this.nextPerspectiveAction, (ActionFactory.IWorkbenchAction)this.prevPerspectiveAction);
        this.preferenceAction = ActionFactory.PREFERENCES.create(window);
        this.register((IAction)this.preferenceAction);
        this.helpAction = ActionFactory.HELP_CONTENTS.create(window);
        this.register((IAction)this.helpAction);
        this.dynamicHelpAction = ActionFactory.DYNAMIC_HELP.create(window);
        this.register((IAction)this.dynamicHelpAction);
        this.aboutAction = ActionFactory.ABOUT.create(window);
        this.aboutAction.setImageDescriptor(ImageManager.getInstance().getImageDescriptor((ImageSource)StandardImages.RCE_LOGO_16));
        this.register((IAction)this.aboutAction);
        this.newWizardDropDownAction = IDEActionFactory.NEW_WIZARD_DROP_DOWN.create(window);
        this.register((IAction)this.newWizardDropDownAction);
        this.removeUnwanted();
    }

    private void removeUnwanted() {
        Properties unwanted = new Properties();
        try {
            unwanted.load(ApplicationActionBarAdvisor.class.getResourceAsStream("unwanted.properties"));
        }
        catch (IOException e) {
            LOGGER.error((Object)"Failed to remove unwanted elements from UI:", (Throwable)e);
            return;
        }
        String actionSetsValue = unwanted.getProperty("org.eclipse.ui.actionSets");
        if (actionSetsValue != null && !actionSetsValue.trim().isEmpty()) {
            String[] actionSets = actionSetsValue.split(",");
            ActionSetRegistry actionSetRegistry = WorkbenchPlugin.getDefault().getActionSetRegistry();
            String[] stringArray = actionSets;
            int n = actionSets.length;
            int n2 = 0;
            while (n2 < n) {
                String actionSetId = stringArray[n2];
                IActionSetDescriptor actionSetDescriptor = actionSetRegistry.findActionSet(actionSetId.trim());
                if (actionSetDescriptor != null) {
                    IExtension ext = actionSetDescriptor.getConfigurationElement().getDeclaringExtension();
                    actionSetRegistry.removeExtension(ext, new Object[]{actionSetDescriptor});
                }
                ++n2;
            }
        }
    }

    protected void fillMenuBar(IMenuManager menuBar) {
        String newId = ActionFactory.NEW.getId();
        MenuManager newMenu = new MenuManager("New", newId);
        newMenu.add((IContributionItem)new Separator(newId));
        newMenu.add((IContributionItem)this.newWizardMenu);
        newMenu.add((IContributionItem)new Separator("additions"));
        MenuManager fileMenu = new MenuManager("&File", "file");
        fileMenu.add((IContributionItem)newMenu);
        fileMenu.add((IContributionItem)new GroupMarker("new.ext"));
        fileMenu.add((IContributionItem)new Separator());
        fileMenu.add((IAction)this.closeAction);
        fileMenu.add((IAction)this.closeAllAction);
        fileMenu.add((IContributionItem)new GroupMarker("close.ext"));
        fileMenu.add((IContributionItem)new Separator());
        fileMenu.add((IAction)this.saveAction);
        fileMenu.add((IAction)this.saveAsAction);
        fileMenu.add((IAction)this.saveAllAction);
        fileMenu.add((IContributionItem)new Separator());
        fileMenu.add((IAction)this.refreshAction);
        fileMenu.add((IContributionItem)new GroupMarker("save.ext"));
        fileMenu.add((IContributionItem)new Separator());
        fileMenu.add((IContributionItem)new Separator());
        fileMenu.add((IAction)this.restartAction);
        fileMenu.add((IContributionItem)new Separator());
        fileMenu.add((IContributionItem)new GroupMarker("import.ext"));
        fileMenu.add((IContributionItem)new Separator("additions"));
        fileMenu.add((IContributionItem)new Separator());
        fileMenu.add((IAction)this.propertiesAction);
        fileMenu.add(ContributionItemFactory.REOPEN_EDITORS.create(this.workbenchWindow));
        fileMenu.add((IContributionItem)new GroupMarker("mru"));
        fileMenu.add((IContributionItem)new Separator());
        fileMenu.add((IAction)this.exitAction);
        fileMenu.add((IContributionItem)new GroupMarker("fileEnd"));
        menuBar.add((IContributionItem)fileMenu);
        MenuManager editMenu = new MenuManager("&Edit", "edit");
        editMenu.add((IContributionItem)new GroupMarker("editStart"));
        editMenu.add((IAction)this.undoAction);
        editMenu.add((IAction)this.redoAction);
        fileMenu.add((IContributionItem)new GroupMarker("undo.ext"));
        editMenu.add((IContributionItem)new Separator());
        editMenu.add((IAction)this.cutAction);
        editMenu.add((IAction)this.copyAction);
        editMenu.add((IAction)this.pasteAction);
        fileMenu.add((IContributionItem)new GroupMarker("cut.ext"));
        editMenu.add((IContributionItem)new Separator());
        editMenu.add((IAction)this.deleteAction);
        editMenu.add((IContributionItem)new Separator());
        editMenu.add((IAction)this.selectAllAction);
        editMenu.add((IContributionItem)new Separator());
        editMenu.add((IAction)this.findReplaceAction);
        editMenu.add((IContributionItem)new GroupMarker("find.ext"));
        editMenu.add((IContributionItem)new GroupMarker("additions"));
        editMenu.add((IContributionItem)new GroupMarker("editEnd"));
        menuBar.add((IContributionItem)editMenu);
        menuBar.add((IContributionItem)new GroupMarker("additions"));
        MenuManager windowMenu = new MenuManager("&Window", "window");
        windowMenu.add((IAction)this.newWorkbenchWindowAction);
        windowMenu.add((IAction)this.newEditorWindowAction);
        windowMenu.add((IContributionItem)new Separator());
        this.addOpenPerspectiveAction(windowMenu);
        this.addShowViewAction(windowMenu);
        windowMenu.add((IContributionItem)new Separator());
        windowMenu.add((IAction)this.editActionSetAction);
        windowMenu.add((IAction)this.savePerspectiveAction);
        windowMenu.add((IAction)this.resetPerspectiveAction);
        windowMenu.add((IAction)this.closePerspectiveAction);
        windowMenu.add((IAction)this.closeAllPerspectivesAction);
        windowMenu.add((IContributionItem)new Separator());
        this.addKeyboardShortcuts(windowMenu);
        windowMenu.add((IContributionItem)new Separator("additions"));
        windowMenu.add((IContributionItem)new Separator("additionsend"));
        windowMenu.add((IAction)this.preferenceAction);
        windowMenu.add(ContributionItemFactory.OPEN_WINDOWS.create(this.workbenchWindow));
        menuBar.add((IContributionItem)windowMenu);
        MenuManager helpMenu = new MenuManager("&Help", "help");
        helpMenu.add((IContributionItem)new GroupMarker("helpStart"));
        helpMenu.add((IAction)this.helpAction);
        helpMenu.add((IAction)this.dynamicHelpAction);
        helpMenu.add((IContributionItem)new Separator("additions"));
        helpMenu.add((IContributionItem)new GroupMarker("helpEnd"));
        helpMenu.add((IContributionItem)new Separator());
        helpMenu.add((IAction)this.aboutAction);
        menuBar.add((IContributionItem)helpMenu);
    }

    protected void fillCoolBar(ICoolBarManager coolBar) {
        coolBar.add((IContributionItem)new GroupMarker("group.file"));
        ToolBarManager fileToolBar = new ToolBarManager(0x820000);
        fileToolBar.add((IContributionItem)new Separator("new.group"));
        fileToolBar.add((IAction)this.newWizardDropDownAction);
        fileToolBar.add((IContributionItem)new GroupMarker("new.ext"));
        fileToolBar.add((IContributionItem)new GroupMarker("save.group"));
        fileToolBar.add((IAction)this.saveAction);
        fileToolBar.add((IAction)this.saveAllAction);
        fileToolBar.add((IContributionItem)new GroupMarker("save.ext"));
        fileToolBar.add((IContributionItem)new GroupMarker("print.ext"));
        fileToolBar.add((IContributionItem)new Separator("additions"));
        coolBar.add((IContributionItem)new ToolBarContributionItem((IToolBarManager)fileToolBar, "org.eclipse.ui.workbench.file"));
        coolBar.add((IContributionItem)new GroupMarker("additions"));
    }

    private void addShowViewAction(MenuManager parentMenu) {
        MenuManager subMenu = new MenuManager("&Show View", "showView");
        subMenu.add(ContributionItemFactory.VIEWS_SHORTLIST.create(this.workbenchWindow));
        parentMenu.add((IContributionItem)subMenu);
    }

    private void addOpenPerspectiveAction(MenuManager parentMenu) {
        MenuManager subMenu = new MenuManager("&Open Perspective", "openPerspective");
        subMenu.add(ContributionItemFactory.PERSPECTIVES_SHORTLIST.create(this.workbenchWindow));
        parentMenu.add((IContributionItem)subMenu);
    }

    private void addKeyboardShortcuts(MenuManager parentMenu) {
        MenuManager subMenu = new MenuManager("&Shortcuts", "shortcuts");
        parentMenu.add((IContributionItem)subMenu);
        subMenu.add((IAction)this.showPartPaneMenuAction);
        subMenu.add((IAction)this.showViewMenuAction);
        subMenu.add((IContributionItem)new Separator());
        subMenu.add((IAction)this.maximizePartAction);
        subMenu.add((IAction)this.minimizePartAction);
        subMenu.add((IContributionItem)new Separator());
        subMenu.add((IAction)this.activateEditorAction);
        subMenu.add((IAction)this.nextEditorAction);
        subMenu.add((IAction)this.prevEditorAction);
        subMenu.add((IAction)this.switchToEditorAction);
        subMenu.add((IAction)this.openEditorDropDownAction);
        subMenu.add((IContributionItem)new Separator());
        subMenu.add((IAction)this.nextPartAction);
        subMenu.add((IAction)this.prevPartAction);
        subMenu.add((IContributionItem)new Separator());
        subMenu.add((IAction)this.nextPerspectiveAction);
        subMenu.add((IAction)this.prevPerspectiveAction);
    }
}

