/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.switchcmp.gui;

import de.rcenvironment.components.switchcmp.common.SwitchComponentHistoryDataItem;
import de.rcenvironment.core.component.api.ComponentUtils;
import de.rcenvironment.core.component.datamanagement.api.DefaultComponentHistoryDataItem;
import de.rcenvironment.core.datamodel.api.TypedDatumSerializer;
import de.rcenvironment.core.datamodel.api.TypedDatumService;
import de.rcenvironment.core.gui.datamanagement.browser.spi.CommonHistoryDataItemSubtreeBuilderUtils;
import de.rcenvironment.core.gui.datamanagement.browser.spi.ComponentHistoryDataItemSubtreeBuilder;
import de.rcenvironment.core.gui.datamanagement.browser.spi.DMBrowserNode;
import de.rcenvironment.core.gui.datamanagement.browser.spi.DMBrowserNodeType;
import de.rcenvironment.core.gui.resources.api.ImageManager;
import de.rcenvironment.core.gui.resources.api.ImageSource;
import de.rcenvironment.core.gui.resources.api.StandardImages;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import de.rcenvironment.core.utils.incubator.ServiceRegistryAccess;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class SwitchHistoryDataItemSubtreeBuilder
implements ComponentHistoryDataItemSubtreeBuilder {
    private static final Image COMPONENT_ICON;

    static {
        String bundleName = "de.rcenvironment.components.switch.common";
        String iconName = "switch_16.png";
        URL url = ComponentUtils.readIconURL((String)bundleName, (String)iconName);
        COMPONENT_ICON = url != null ? ImageDescriptor.createFromURL((URL)url).createImage() : null;
    }

    public String[] getSupportedHistoryDataItemIdentifier() {
        return new String[]{"de.rcenvironment.switchcmp"};
    }

    public Serializable deserializeHistoryDataItem(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        return (Serializable)ois.readObject();
    }

    public void buildInitialHistoryDataItemSubtree(Serializable historyDataItem, DMBrowserNode parentNode) {
        SwitchComponentHistoryDataItem historyData;
        ServiceRegistryAccess registryAccess = ServiceRegistry.createAccessFor((Object)this);
        TypedDatumSerializer serializer = ((TypedDatumService)registryAccess.getService(TypedDatumService.class)).getSerializer();
        if (historyDataItem instanceof String) {
            try {
                historyData = SwitchComponentHistoryDataItem.fromString((String)((String)((Object)historyDataItem)), (TypedDatumSerializer)serializer, (String)"de.rcenvironment.switchcmp");
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        } else {
            String exceptionInformationText = "";
            exceptionInformationText = historyDataItem != null ? StringUtils.format((String)"Parsing history data point failed: Expected type %s, but was of type %s", (Object[])new Object[]{String.class.getCanonicalName(), historyDataItem.getClass().getCanonicalName()}) : StringUtils.format((String)"Parsing history data point failed: Expected type %s, actual type not available.", (Object[])new Object[]{String.class.getCanonicalName()});
            throw new IllegalArgumentException(exceptionInformationText);
        }
        CommonHistoryDataItemSubtreeBuilderUtils.buildDefaultHistoryDataItemSubtrees((DefaultComponentHistoryDataItem)historyData, (DMBrowserNode)parentNode);
        DMBrowserNode conditionNode = DMBrowserNode.addNewChildNode((String)"Condition", (DMBrowserNodeType)DMBrowserNodeType.Custom, (DMBrowserNode)parentNode);
        conditionNode.setIcon(ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.QUESTION_MARK_16));
        DMBrowserNode actualConditionnode = DMBrowserNode.addNewLeafNode((String)("Actual: " + org.apache.commons.lang3.StringUtils.abbreviate((String)historyData.getActualCondition(), (int)30)), (DMBrowserNodeType)DMBrowserNodeType.CommonText, (DMBrowserNode)conditionNode);
        actualConditionnode.setFileContentAndName(historyData.getActualCondition(), "Actual condition");
        DMBrowserNode templateConditionnode = DMBrowserNode.addNewLeafNode((String)("Pattern: " + org.apache.commons.lang3.StringUtils.abbreviate((String)historyData.getConditionPattern(), (int)30)), (DMBrowserNodeType)DMBrowserNodeType.CommonText, (DMBrowserNode)conditionNode);
        templateConditionnode.setFileContentAndName(historyData.getConditionPattern(), "Condition pattern");
    }

    public Image getComponentIcon(String historyDataItemIdentifier) {
        return COMPONENT_ICON;
    }
}

