/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.switchcmp.gui;

import de.rcenvironment.components.switchcmp.common.SwitchComponentConstants;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.component.model.endpoint.api.EndpointMetaDataDefinition;
import de.rcenvironment.core.component.workflow.model.spi.ComponentInstanceProperties;
import de.rcenvironment.core.datamodel.api.EndpointActionType;
import de.rcenvironment.core.datamodel.api.EndpointType;
import de.rcenvironment.core.gui.utils.common.configuration.VariableNameVerifyListener;
import de.rcenvironment.core.gui.workflow.editor.properties.EndpointEditDialog;
import de.rcenvironment.core.gui.workflow.editor.properties.EndpointSelectionPane;
import de.rcenvironment.core.gui.workflow.editor.properties.WorkflowNodeCommand;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class SwitchConditionInputSelectionPane
extends EndpointSelectionPane {
    public SwitchConditionInputSelectionPane(String title, EndpointType direction, String dynEndpointIdToManage, WorkflowNodeCommand.Executor executor) {
        super(title, direction, dynEndpointIdToManage, new String[0], new String[0], executor);
    }

    protected void onAddClicked() {
        SwitchConditionEndpointEditDialog dialog = new SwitchConditionEndpointEditDialog(Display.getDefault().getActiveShell(), EndpointActionType.ADD, this.configuration, this.endpointType, this.dynEndpointIdToManage, false, this.endpointManager.getDynamicEndpointDefinition(this.dynEndpointIdToManage).getMetaDataDefinition(), new HashMap<String, String>());
        this.onAddClicked(dialog);
    }

    protected void onEditClicked() {
        String name = (String)this.table.getSelection()[0].getData();
        boolean isStaticEndpoint = this.endpointManager.getEndpointDescription(name).getEndpointDefinition().isStatic();
        EndpointDescription endpoint = this.endpointManager.getEndpointDescription(name);
        Map newMetaData = this.cloneMetaData(endpoint.getMetaData());
        SwitchConditionEndpointEditDialog dialog = new SwitchConditionEndpointEditDialog(Display.getDefault().getActiveShell(), EndpointActionType.EDIT, this.configuration, this.endpointType, this.dynEndpointIdToManage, isStaticEndpoint, endpoint.getEndpointDefinition().getMetaDataDefinition(), newMetaData);
        this.onEditClicked(name, dialog, newMetaData);
    }

    private class SwitchConditionEndpointEditDialog
    extends EndpointEditDialog {
        SwitchConditionEndpointEditDialog(Shell parentShell, EndpointActionType actionType, ComponentInstanceProperties configuration, EndpointType direction, String id, boolean isStatic, EndpointMetaDataDefinition metaData, Map<String, String> metadataValues) {
            super(parentShell, actionType, configuration, direction, id, isStatic, metaData, metadataValues);
        }

        protected void createEndpointSettings(Composite parent) {
            super.createEndpointSettings(parent);
            this.textfieldName.addListener(25, (Listener)new VariableNameVerifyListener(1, this.textfieldName));
        }

        protected void validateInput() {
            super.validateInput();
            String text = this.textfieldName.getText();
            this.getButton(0).setEnabled(this.getButton(0).isEnabled() && text != null && !text.isEmpty() && !Character.isDigit(text.charAt(0)) && !Arrays.asList(SwitchComponentConstants.OPERATORS).contains(text));
        }
    }
}

