/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.trustmanager;

import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.gsi.util.CertificateUtil;
import org.globus.gsi.util.KeyStoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TrustedCertPathFinder {
    private static Log logger = LogFactory.getLog(TrustedCertPathFinder.class.getCanonicalName());

    private TrustedCertPathFinder() {
    }

    private static CertPath isTrustedCert(KeyStore keyStore, X509Certificate x509Certificate, List<X509Certificate> trustedCertPath) throws CertPathValidatorException {
        Collection<? extends Certificate> caCerts;
        X509CertSelector certSelector = new X509CertSelector();
        certSelector.setCertificate(x509Certificate);
        try {
            caCerts = KeyStoreUtil.getTrustedCertificates(keyStore, certSelector);
        }
        catch (KeyStoreException e) {
            throw new CertPathValidatorException("Error accessing trusted certificate store", e);
        }
        if (caCerts.size() > 0) {
            trustedCertPath.add(x509Certificate);
            try {
                CertificateFactory certFac = CertificateFactory.getInstance("X.509");
                return certFac.generateCertPath(trustedCertPath);
            }
            catch (CertificateException e) {
                throw new CertPathValidatorException("Error generating trusted certificate path", e);
            }
        }
        return null;
    }

    public static CertPath findTrustedCertPath(KeyStore keyStore, CertPath certPath) throws CertPathValidatorException {
        Collection<? extends Certificate> caCerts;
        ArrayList<X509Certificate> trustedCertPath = new ArrayList<X509Certificate>();
        List<? extends Certificate> certs = certPath.getCertificates();
        int index = 0;
        int certsSize = certs.size();
        Certificate certificate = certs.get(index);
        if (!(certificate instanceof X509Certificate)) {
            throw new CertPathValidatorException("Certificate of type " + X509Certificate.class.getName() + " required");
        }
        X509Certificate x509Certificate = (X509Certificate)certificate;
        while (index < certsSize) {
            CertPath finalCertPath = TrustedCertPathFinder.isTrustedCert(keyStore, x509Certificate, trustedCertPath);
            if (finalCertPath != null) {
                return finalCertPath;
            }
            if (index + 1 >= certsSize) break;
            Certificate issuerCertificate = certs.get(++index);
            x509Certificate = TrustedCertPathFinder.checkCertificate(trustedCertPath, x509Certificate, issuerCertificate);
        }
        X509CertSelector selector = new X509CertSelector();
        selector.setSubject(x509Certificate.getIssuerX500Principal());
        try {
            caCerts = KeyStoreUtil.getTrustedCertificates(keyStore, selector);
        }
        catch (KeyStoreException e) {
            throw new CertPathValidatorException(e);
        }
        if (caCerts.size() < 1) {
            throw new CertPathValidatorException("No trusted path can be constructed");
        }
        boolean foundTrustRoot = false;
        for (Certificate certificate2 : caCerts) {
            if (!(certificate2 instanceof X509Certificate)) {
                logger.warn("Skipped a certificate: not an X509Certificate");
                continue;
            }
            try {
                trustedCertPath.add(TrustedCertPathFinder.checkCertificate(trustedCertPath, x509Certificate, certificate2));
                foundTrustRoot = true;
                break;
            }
            catch (CertPathValidatorException e) {
                logger.warn("Failed to validate signature of certificate with subject DN '" + x509Certificate.getSubjectDN() + "' against a CA certificate with issuer DN '" + ((X509Certificate)certificate2).getSubjectDN() + "'");
            }
        }
        if (!foundTrustRoot) {
            throw new CertPathValidatorException("No trusted path can be constructed");
        }
        try {
            CertificateFactory certFac = CertificateFactory.getInstance("X.509");
            return certFac.generateCertPath(trustedCertPath);
        }
        catch (CertificateException e) {
            throw new CertPathValidatorException("Error generating trusted certificate path", e);
        }
    }

    private static X509Certificate checkCertificate(List<X509Certificate> trustedCertPath, X509Certificate x509Certificate, Certificate issuerCertificate) throws CertPathValidatorException {
        String issuerCertDN;
        X509Certificate x509IssuerCertificate = (X509Certificate)issuerCertificate;
        String issuerDN = CertificateUtil.toGlobusID(x509Certificate.getIssuerX500Principal());
        if (!issuerDN.equals(issuerCertDN = CertificateUtil.toGlobusID(x509IssuerCertificate.getSubjectX500Principal()))) {
            throw new IllegalArgumentException("Incorrect certificate path, certificate in chain can only be issuer of previous certificate");
        }
        PublicKey publicKey = x509IssuerCertificate.getPublicKey();
        try {
            x509Certificate.verify(publicKey);
        }
        catch (CertificateException e) {
            throw new CertPathValidatorException("Signature validation on the certificate " + x509Certificate.getSubjectDN(), e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CertPathValidatorException("Signature validation on the certificate " + x509Certificate.getSubjectDN(), e);
        }
        catch (InvalidKeyException e) {
            throw new CertPathValidatorException("Signature validation on the certificate " + x509Certificate.getSubjectDN(), e);
        }
        catch (NoSuchProviderException e) {
            throw new CertPathValidatorException("Signature validation on the certificate " + x509Certificate.getSubjectDN(), e);
        }
        catch (SignatureException e) {
            throw new CertPathValidatorException("Signature validation on the certificate " + x509Certificate.getSubjectDN(), e);
        }
        trustedCertPath.add(x509Certificate);
        return x509IssuerCertificate;
    }
}

