/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.stores;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.gsi.stores.AbstractResourceSecurityWrapper;
import org.globus.gsi.stores.ResourceStoreException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ResourceSecurityWrapperStore<T extends AbstractResourceSecurityWrapper<V>, V> {
    private Collection<V> rootObjects;
    private PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
    private Map<String, T> wrapperMap = new HashMap<String, T>();
    private Log logger = LogFactory.getLog(ResourceSecurityWrapperStore.class.getCanonicalName());

    public Map<String, T> getWrapperMap() {
        return this.wrapperMap;
    }

    public void loadWrappers(String[] locations) throws ResourceStoreException {
        for (String location : locations) {
            File file = new File(location);
            FileSystemResource resource = new FileSystemResource(file);
            try {
                this.loadWrappers(resource.getURL().toExternalForm());
            }
            catch (IOException ioe) {
                throw new ResourceStoreException(ioe);
            }
        }
    }

    public void loadWrappers(String locationPattern) throws ResourceStoreException {
        HashSet<V> updatedList = new HashSet<V>();
        boolean changed = false;
        HashMap<String, T> newWrapperMap = new HashMap<String, T>();
        if (locationPattern == null) {
            this.rootObjects = updatedList;
            this.wrapperMap = newWrapperMap;
            return;
        }
        if (locationPattern.indexOf(",") >= 0) {
            String[] locationPatterns = locationPattern.split(",");
            boolean tmpChanged = false;
            for (String lp : locationPatterns) {
                if (!tmpChanged) {
                    tmpChanged = this.loadResources(lp, updatedList, newWrapperMap);
                }
                changed = tmpChanged;
            }
        } else {
            changed = this.loadResources(locationPattern, updatedList, newWrapperMap);
        }
        if (!changed && this.rootObjects != null && this.wrapperMap.size() != newWrapperMap.size()) {
            changed = true;
        }
        if (changed) {
            this.rootObjects = updatedList;
        }
        this.wrapperMap = newWrapperMap;
    }

    private boolean loadResources(String locationPattern, Set<V> updatedList, Map<String, T> newWrapperMap) throws ResourceStoreException {
        boolean changed = false;
        try {
            Resource[] resources;
            for (Resource resource : resources = this.resolver.getResources(locationPattern)) {
                URI uri = resource.getURI();
                if (!resource.isReadable()) {
                    this.getLog().warn("Cannot read: " + uri.toASCIIString());
                    continue;
                }
                changed = this.load(resource, updatedList, newWrapperMap);
            }
        }
        catch (IOException e) {
            throw new ResourceStoreException(e);
        }
        return changed;
    }

    private boolean load(Resource resource, Set<V> currentRoots, Map<String, T> newWrapperMap) throws ResourceStoreException {
        if (!resource.isReadable()) {
            throw new ResourceStoreException("Cannot read file");
        }
        try {
            if (resource.getFile().isDirectory()) {
                File directory = resource.getFile();
                currentRoots.addAll(this.addCredentials(directory, newWrapperMap));
                return true;
            }
        }
        catch (IOException e) {
            this.logger.debug("Not a filesystem resource", e);
        }
        try {
            String resourceUri = resource.getURL().toExternalForm();
            AbstractResourceSecurityWrapper fbo = (AbstractResourceSecurityWrapper)this.wrapperMap.get(resourceUri);
            if (fbo == null) {
                fbo = this.create(resource);
            }
            Object target = fbo.create(resource);
            newWrapperMap.put(resourceUri, fbo);
            currentRoots.add(target);
            return true;
        }
        catch (IOException e) {
            throw new ResourceStoreException(e);
        }
    }

    private Set<V> addCredentials(File directory, Map<String, T> newWrapperMap) throws ResourceStoreException {
        FilenameFilter filter = this.getDefaultFilenameFilter();
        String[] children = directory.list(filter);
        HashSet<Object> roots = new HashSet<Object>();
        try {
            for (String child : children) {
                File childFile = new File(directory, child);
                if (childFile.isDirectory()) {
                    roots.addAll(this.addCredentials(childFile, newWrapperMap));
                    continue;
                }
                FileSystemResource resource = new FileSystemResource(childFile);
                String resourceUri = resource.getURI().toASCIIString();
                AbstractResourceSecurityWrapper fbo = (AbstractResourceSecurityWrapper)this.wrapperMap.get(resourceUri);
                if (fbo == null) {
                    fbo = this.create(new FileSystemResource(childFile));
                }
                Object target = fbo.create(resource);
                newWrapperMap.put(resourceUri, fbo);
                roots.add(target);
            }
            return roots;
        }
        catch (IOException e) {
            throw new ResourceStoreException(e);
        }
    }

    public abstract T create(Resource var1) throws ResourceStoreException;

    public abstract FilenameFilter getDefaultFilenameFilter();

    public Collection<V> getCollection() {
        return this.rootObjects;
    }

    protected abstract Log getLog();
}

