/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.datamanagement.internal;

import de.rcenvironment.core.communication.common.CommunicationException;
import de.rcenvironment.core.communication.common.ResolvableNodeId;
import de.rcenvironment.core.component.datamanagement.api.ComponentDataManagementUtil;
import de.rcenvironment.core.component.datamanagement.api.ComponentHistoryDataItem;
import de.rcenvironment.core.component.execution.api.ComponentContext;
import de.rcenvironment.core.datamanagement.FileDataService;
import de.rcenvironment.core.datamanagement.commons.MetaData;
import de.rcenvironment.core.datamanagement.commons.MetaDataSet;
import de.rcenvironment.core.datamodel.api.TypedDatumSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class WorkflowHistoryServiceImpl {
    private static final MetaData METADATA_CLASS_NAME = new MetaData("rce.history.classname", true, true);
    private static final MetaData METADATA_USER_INFO_TEXT = new MetaData("rce.history.infotext", true, true);
    private static final MetaData METADATA_HISTORY_TIMESTAMP = new MetaData("rce.history.orderingindex", true, true);
    private TypedDatumSerializer typedDatumSerializer;
    private FileDataService fileDataService;

    public WorkflowHistoryServiceImpl(TypedDatumSerializer typedDatumSerializer, FileDataService fileDataService) {
        this.typedDatumSerializer = typedDatumSerializer;
        this.fileDataService = fileDataService;
    }

    public void addHistoryDataPoint(Serializable historyData, String userInfoText, ComponentContext componentContext, long timestamp) throws IOException {
        MetaDataSet mds = new MetaDataSet();
        ComponentDataManagementUtil.setComponentMetaData((MetaDataSet)mds, (ComponentContext)componentContext);
        WorkflowHistoryServiceImpl.setHistoryMetaData(mds, historyData, userInfoText, timestamp);
        InputStream historyDataInputStream = this.getHistoryDataPointAsInputStreamInputStream(historyData);
        try {
            this.fileDataService.newReferenceFromStream(historyDataInputStream, mds, (ResolvableNodeId)componentContext.getDefaultStorageNodeId());
        }
        catch (CommunicationException | InterruptedException e) {
            throw new IOException(e);
        }
    }

    private static void setHistoryMetaData(MetaDataSet mds, Serializable historyData, String userInfoText, long timestamp) {
        if (historyData instanceof ComponentHistoryDataItem) {
            mds.setValue(METADATA_CLASS_NAME, ((ComponentHistoryDataItem)historyData).getIdentifier());
        } else {
            mds.setValue(METADATA_CLASS_NAME, historyData.getClass().getCanonicalName());
        }
        mds.setValue(METADATA_USER_INFO_TEXT, userInfoText);
        mds.setValue(METADATA_HISTORY_TIMESTAMP, Long.toString(timestamp));
    }

    private InputStream getHistoryDataPointAsInputStreamInputStream(Serializable historyData) throws IOException {
        if (historyData instanceof ComponentHistoryDataItem) {
            historyData = ((ComponentHistoryDataItem)historyData).serialize(this.typedDatumSerializer);
        }
        ByteArrayOutputStream baOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baOutputStream);
        oos.writeObject(historyData);
        return new ByteArrayInputStream(baOutputStream.toByteArray());
    }
}

