/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.view.properties;

import de.rcenvironment.core.component.model.endpoint.api.EndpointDatum;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionInformation;
import de.rcenvironment.core.datamodel.api.TypedDatum;
import de.rcenvironment.core.datamodel.types.api.DirectoryReferenceTD;
import de.rcenvironment.core.datamodel.types.api.FileReferenceTD;
import de.rcenvironment.core.gui.workflow.Activator;
import de.rcenvironment.core.gui.workflow.view.properties.InputModel;
import de.rcenvironment.core.gui.workflow.view.properties.InputQueueDialog;
import java.util.Deque;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;

public class InputQueueDialogController {
    private static final String SETTINGS_KEY_SROLLLOCK = "de.rcenvironment.rce.gui.workflow.view.properties.settinngs.scrolllock";
    private static InputQueueDialogController instance;
    private String workflowId;
    private String componentId;
    private String inputName;
    private InputModel inputModel;
    private InputQueueDialog dialog;
    private IDialogSettings dialogSettings;
    private int tableItemCount = 0;
    private boolean isScrollLocked;

    public InputQueueDialogController(WorkflowExecutionInformation workflowInfo, String componentId, String inputName) {
        instance = this;
        this.workflowId = workflowInfo.getExecutionIdentifier();
        this.componentId = componentId;
        this.inputName = inputName;
        this.dialogSettings = Activator.getInstance().getDialogSettings();
        this.inputModel = InputModel.getInstance();
        this.dialog = new InputQueueDialog(Display.getCurrent().getActiveShell());
        this.dialog.create();
        this.initialize();
    }

    public static InputQueueDialogController getInstance() {
        return instance;
    }

    public int open() {
        return this.dialog.open();
    }

    public void redrawTable() {
        Table table = this.dialog.getInputQueueTableViewer().getTable();
        if (!table.isDisposed()) {
            this.dialog.getInputQueueTableViewer().setInput(this.inputModel.getInputs(this.workflowId, this.componentId, this.inputName));
            if (!this.isScrollLocked && table.getItemCount() > this.tableItemCount) {
                table.setTopIndex(table.getItemCount());
                this.tableItemCount = table.getItemCount();
            }
        }
    }

    private void initialize() {
        this.dialog.getShell().setText(this.inputName);
        this.dialog.getInputQueueTableViewer().setLabelProvider((IBaseLabelProvider)new InputQueueLabelProvider());
        this.dialog.getInputQueueTableViewer().setContentProvider((IContentProvider)new InputQueueContentProvider());
        this.redrawTable();
        this.isScrollLocked = this.dialogSettings.getBoolean(SETTINGS_KEY_SROLLLOCK);
        this.dialog.getScrollLockButton().setSelection(this.isScrollLocked);
        this.dialog.getScrollLockButton().addListener(13, new Listener(){

            public void handleEvent(Event event) {
                InputQueueDialogController.this.isScrollLocked = InputQueueDialogController.this.dialog.getScrollLockButton().getSelection();
                InputQueueDialogController.this.dialogSettings.put(InputQueueDialogController.SETTINGS_KEY_SROLLLOCK, InputQueueDialogController.this.isScrollLocked);
            }
        });
    }

    class InputQueueContentProvider
    implements IStructuredContentProvider {
        InputQueueContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Deque) {
                return ((Deque)inputElement).toArray();
            }
            return new Object[0];
        }
    }

    class InputQueueLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        InputQueueLabelProvider() {
        }

        public Image getColumnImage(Object object, int columnIndex) {
            return null;
        }

        public String getColumnText(Object object, int columnIndex) {
            String text = "-";
            if (object instanceof EndpointDatum) {
                TypedDatum input = ((EndpointDatum)object).getValue();
                switch (input.getDataType()) {
                    case FileReference: {
                        text = ((FileReferenceTD)input).getFileName();
                        break;
                    }
                    case DirectoryReference: {
                        text = ((DirectoryReferenceTD)input).getDirectoryName();
                        break;
                    }
                    default: {
                        text = input.toString();
                    }
                }
            }
            return text;
        }
    }
}

