/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.execute;

import de.rcenvironment.core.communication.common.LogicalNodeId;
import de.rcenvironment.core.communication.common.ResolvableNodeId;
import de.rcenvironment.core.component.api.ComponentUtils;
import de.rcenvironment.core.component.api.DistributedComponentKnowledge;
import de.rcenvironment.core.component.api.DistributedComponentKnowledgeService;
import de.rcenvironment.core.component.model.api.ComponentDescription;
import de.rcenvironment.core.component.model.api.ComponentInstallation;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.gui.workflow.execute.Messages;
import de.rcenvironment.core.gui.workflow.execute.NodeIdentifierConfigurationHelper;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import de.rcenvironment.core.utils.incubator.ServiceRegistryAccess;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;

final class TargetNodeEditingSupport
extends EditingSupport {
    private static final int ERROR = -1;
    private final NodeIdentifierConfigurationHelper nodeIdConfigHelper;
    private final int column;
    private final ColumnViewer viewer;
    private final LogicalNodeId localNode;
    private Map<String, List<String>> values = new HashMap<String, List<String>>();
    private Map<String, List<LogicalNodeId>> nodes = new HashMap<String, List<LogicalNodeId>>();
    private DistributedComponentKnowledge compKnowledge;
    private final ServiceRegistryAccess serviceRegistryAccess;
    private Map<String, Map<LogicalNodeId, Integer>> matchingNodeInfo = new HashMap<String, Map<LogicalNodeId, Integer>>();
    private Map<WorkflowNode, Boolean> hasVersionErrorMap = new HashMap<WorkflowNode, Boolean>();
    private Map<WorkflowNode, ComponentDescription> initialComponentDescriptions = new HashMap<WorkflowNode, ComponentDescription>();

    TargetNodeEditingSupport(NodeIdentifierConfigurationHelper nodeIdConfigHelper, LogicalNodeId localNode, ColumnViewer viewer, int column) {
        super(viewer);
        this.nodeIdConfigHelper = nodeIdConfigHelper;
        this.column = column;
        this.viewer = viewer;
        this.localNode = localNode;
        this.serviceRegistryAccess = ServiceRegistry.createAccessFor((Object)((Object)this));
        this.compKnowledge = ((DistributedComponentKnowledgeService)this.serviceRegistryAccess.getService(DistributedComponentKnowledgeService.class)).getCurrentComponentKnowledge();
    }

    protected boolean canEdit(Object arg0) {
        return this.column == 1;
    }

    protected CellEditor getCellEditor(Object element) {
        if (!(element instanceof WorkflowNode)) {
            return null;
        }
        ComboBoxCellEditor editor = new ComboBoxCellEditor((Composite)((TableViewer)this.viewer).getTable(), this.getValues((WorkflowNode)element).toArray(new String[0]));
        return editor;
    }

    protected boolean isNodeExactMatchRegardingComponentVersion(WorkflowNode node) {
        return this.isNodeExactMatchRegardingComponentVersion(node, node.getComponentDescription().getNode());
    }

    protected boolean isNodeExactMatchRegardingInitialComponentVersion(WorkflowNode node) {
        return this.isNodeExactMatchRegardingComponentVersion(node, this.initialComponentDescriptions.get(node).getNode());
    }

    protected boolean isNodeExactMatchRegardingComponentVersion(WorkflowNode wfNode, LogicalNodeId node) {
        if (node == null) {
            node = this.localNode;
        }
        return this.matchingNodeInfo.get(wfNode.getIdentifier()).containsKey(node) && this.matchingNodeInfo.get(wfNode.getIdentifier()).get(node).equals(0);
    }

    protected Object getValue(Object element) {
        Integer result = null;
        if (!(element instanceof WorkflowNode) || this.column != 1) {
            return result;
        }
        LogicalNodeId node = ((WorkflowNode)element).getComponentDescription().getNode();
        if (this.isNodeExactMatchRegardingComponentVersion((WorkflowNode)element)) {
            result = node.equals(this.localNode) ? Integer.valueOf(0) : Integer.valueOf(this.nodes.get(((WorkflowNode)element).getIdentifier()).indexOf(node));
        } else {
            LogicalNodeId p;
            Iterator<LogicalNodeId> iterator = this.nodes.get(((WorkflowNode)element).getIdentifier()).iterator();
            if (iterator.hasNext() && node.equals(p = iterator.next())) {
                result = this.nodes.get(((WorkflowNode)element).getIdentifier()).indexOf(p);
            }
        }
        if (result == null && !this.nodes.isEmpty()) {
            result = 0;
        }
        return result;
    }

    protected void setValue(Object element, Object value) {
        ComponentInstallation installation;
        int intValue = (Integer)value;
        if (intValue >= 0 && (installation = this.nodes.get(((WorkflowNode)element).getIdentifier()).get(intValue) == null || this.nodes.get(((WorkflowNode)element).getIdentifier()).get(intValue).equals(this.localNode) ? ComponentUtils.getComponentInstallationForNode((String)((WorkflowNode)element).getComponentDescription().getIdentifier(), (Collection)this.compKnowledge.getLocalInstallations(), (LogicalNodeId)this.localNode) : ComponentUtils.getComponentInstallationForNode((String)((WorkflowNode)element).getComponentDescription().getIdentifier(), (Collection)this.compKnowledge.getPublishedInstallationsOnNode((ResolvableNodeId)this.nodes.get(((WorkflowNode)element).getIdentifier()).get(intValue)), (LogicalNodeId)this.nodes.get(((WorkflowNode)element).getIdentifier()).get(intValue))) != null) {
            ((WorkflowNode)element).getComponentDescription().setComponentInstallationAndUpdateConfiguration(installation);
        }
    }

    public int setRemoteValue(WorkflowNode node) {
        ComponentInstallation installation = null;
        int comboindex = -1;
        List<LogicalNodeId> nodeIdentifierList = this.nodes.get(node.getIdentifier());
        ArrayList<Integer> remoteIndexList = new ArrayList<Integer>();
        int i = 0;
        while (i < nodeIdentifierList.size()) {
            if (this.nodes.get(node.getIdentifier()).get(i) != null && !this.nodes.get(node.getIdentifier()).get(i).equals(this.localNode) && this.isNodeExactMatchRegardingComponentVersion(node, this.nodes.get(node.getIdentifier()).get(i)) && this.isNodeExactMatchRegardingInitialComponentVersion(node)) {
                remoteIndexList.add(i);
            }
            ++i;
        }
        if (!remoteIndexList.isEmpty()) {
            Random random = new Random();
            int randomIndex = (Integer)remoteIndexList.get(random.nextInt(remoteIndexList.size()));
            installation = ComponentUtils.getComponentInstallationForNode((String)node.getComponentDescription().getIdentifier(), (Collection)this.compKnowledge.getPublishedInstallationsOnNode((ResolvableNodeId)this.nodes.get(node.getIdentifier()).get(randomIndex)), (LogicalNodeId)this.nodes.get(node.getIdentifier()).get(randomIndex));
            comboindex = randomIndex;
            this.setValue(node, randomIndex);
        }
        if (installation != null) {
            node.getComponentDescription().setComponentInstallationAndUpdateConfiguration(installation);
        }
        return comboindex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> getValues(WorkflowNode wfNode) {
        this.compKnowledge = ((DistributedComponentKnowledgeService)this.serviceRegistryAccess.getService(DistributedComponentKnowledgeService.class)).getCurrentComponentKnowledge();
        if (!wfNode.isInit()) {
            this.initialComponentDescriptions.put(wfNode, wfNode.getComponentDescription().clone());
            wfNode.setInit(true);
        }
        boolean hasVersionError = false;
        if (this.hasVersionErrorMap.containsKey(wfNode) && this.hasVersionErrorMap.get(wfNode).equals(true)) {
            hasVersionError = true;
        }
        Map<String, List<LogicalNodeId>> map = this.nodes;
        synchronized (map) {
            if (!this.nodes.containsKey(wfNode.getIdentifier())) {
                this.nodes.put(wfNode.getIdentifier(), new ArrayList());
            }
            this.nodes.get(wfNode.getIdentifier()).clear();
        }
        if (!hasVersionError) {
            this.matchingNodeInfo.put(wfNode.getIdentifier(), this.nodeIdConfigHelper.getTargetPlatformsForComponent(wfNode.getComponentDescription()));
        } else {
            this.matchingNodeInfo.put(wfNode.getIdentifier(), this.nodeIdConfigHelper.getTargetPlatformsForComponent(this.initialComponentDescriptions.get(wfNode)));
        }
        ArrayList<LogicalNodeId> sortedTargetNodes = new ArrayList<LogicalNodeId>(this.matchingNodeInfo.get(wfNode.getIdentifier()).keySet());
        this.nodeIdConfigHelper.sortNodes(sortedTargetNodes);
        ArrayList<String> nodeValues = new ArrayList<String>(this.nodes.size());
        if (sortedTargetNodes.contains(this.localNode)) {
            nodeValues.add(this.enhanceNodeNameWithVersionInformation(wfNode, String.valueOf(this.localNode.getAssociatedDisplayName()) + " " + Messages.localPlatformSelectionTitle, this.localNode));
            this.nodes.get(wfNode.getIdentifier()).add(null);
        }
        for (LogicalNodeId n : sortedTargetNodes) {
            if (n == null) {
                LogFactory.getLog(((Object)((Object)this)).getClass()).error((Object)"NULL NodeIdentifier!");
                continue;
            }
            String nodeName = n.getAssociatedDisplayName();
            if (n.equals(this.localNode)) continue;
            nodeValues.add(this.enhanceNodeNameWithVersionInformation(wfNode, nodeName, n));
            this.nodes.get(wfNode.getIdentifier()).add(n);
        }
        this.values.put(wfNode.getIdentifier(), nodeValues);
        return nodeValues;
    }

    private String enhanceNodeNameWithVersionInformation(WorkflowNode wfNode, String nodeName, LogicalNodeId node) {
        if (this.matchingNodeInfo.get(wfNode.getIdentifier()).get(node).equals(-1)) {
            nodeName = String.valueOf(nodeName) + " " + Messages.older;
        } else if (this.matchingNodeInfo.get(wfNode.getIdentifier()).get(node).equals(1)) {
            nodeName = String.valueOf(nodeName) + " " + Messages.newer;
        }
        return nodeName;
    }

    public Map<WorkflowNode, Boolean> getHasVersionErrorMap() {
        return this.hasVersionErrorMap;
    }
}

