/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.editor.documentation;

import de.rcenvironment.core.component.integration.ToolIntegrationDocumentationService;
import de.rcenvironment.core.gui.utils.common.EditorsHelper;
import de.rcenvironment.core.gui.workflow.editor.documentation.ToolIntegrationDocumentationChooserDialog;
import de.rcenvironment.core.utils.common.rpc.RemoteOperationException;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import de.rcenvironment.core.utils.incubator.ServiceRegistryPublisherAccess;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;

public final class ToolIntegrationDocumentationGUIHelper {
    private static ToolIntegrationDocumentationGUIHelper instance = new ToolIntegrationDocumentationGUIHelper();
    private static AtomicBoolean isCurrentlyLoading = new AtomicBoolean(false);

    public void showComponentDocumentation(String toolIdentifier) {
        ServiceRegistryPublisherAccess serviceRegistryAccess = ServiceRegistry.createPublisherAccessFor((Object)this);
        ToolIntegrationDocumentationService tids = (ToolIntegrationDocumentationService)serviceRegistryAccess.getService(ToolIntegrationDocumentationService.class);
        Map componentInstallationsWithDocumentation = tids.getComponentDocumentationList(toolIdentifier);
        if (componentInstallationsWithDocumentation.size() == 1) {
            Map.Entry documentationEntry = componentInstallationsWithDocumentation.entrySet().iterator().next();
            String hashValue = (String)documentationEntry.getKey();
            String nodeID = (String)documentationEntry.getValue();
            this.setupJob(toolIdentifier, tids, hashValue, nodeID);
        } else if (componentInstallationsWithDocumentation.size() > 1) {
            ToolIntegrationDocumentationChooserDialog chooser = new ToolIntegrationDocumentationChooserDialog(new Shell(Display.getCurrent()), componentInstallationsWithDocumentation, toolIdentifier);
            chooser.create();
            if (chooser.open() == 0 && chooser.getSelectedHash() != null) {
                String hashValue = chooser.getSelectedHash();
                String nodeID = (String)componentInstallationsWithDocumentation.get(hashValue);
                this.setupJob(toolIdentifier, tids, hashValue, nodeID);
            }
        } else {
            MessageBox noDocumentationBox = new MessageBox(Display.getDefault().getActiveShell());
            noDocumentationBox.setText("No Documentation");
            noDocumentationBox.setMessage("Documentation for selected tool not available in the current network.");
            noDocumentationBox.open();
        }
    }

    private void setupJob(final String toolIdentifier, final ToolIntegrationDocumentationService tids, final String hashValue, final String nodeID) {
        Job job = new Job("Tool Documentation"){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask("Fetching tool documentation", 2);
                ToolIntegrationDocumentationGUIHelper.this.downloadAndOpenDocumentation(toolIdentifier, tids, nodeID, hashValue, monitor);
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    private void downloadAndOpenDocumentation(String identifier, ToolIntegrationDocumentationService tids, String nodeID, String hashValue, IProgressMonitor monitor) {
        File[] listFiles;
        if (isCurrentlyLoading.get()) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    MessageBox alreadyLoading = new MessageBox(Display.getDefault().getActiveShell());
                    alreadyLoading.setText("Loading Documentation");
                    alreadyLoading.setMessage("Another documentation is aready loading.");
                    alreadyLoading.open();
                }
            });
            return;
        }
        isCurrentlyLoading.set(true);
        monitor.worked(1);
        File documentationDir = null;
        try {
            documentationDir = tids.getToolDocumentation(identifier, nodeID, hashValue);
        }
        catch (RemoteOperationException | IOException e1) {
            monitor.worked(1);
            isCurrentlyLoading.set(false);
            Display.getDefault().asyncExec(new Runnable((Exception)e1){
                private final /* synthetic */ Exception val$e1;
                {
                    this.val$e1 = exception;
                }

                @Override
                public void run() {
                    MessageBox errorDownload = new MessageBox(Display.getDefault().getActiveShell());
                    errorDownload.setText("Download failed");
                    errorDownload.setMessage("Download of the documentation failed.\nCause: " + this.val$e1.getMessage());
                    errorDownload.open();
                }
            });
            return;
        }
        monitor.worked(1);
        if (documentationDir != null && (listFiles = documentationDir.listFiles()) != null && listFiles.length > 0) {
            File toOpen = null;
            File[] fileArray = listFiles;
            int n = listFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.isFile()) {
                    toOpen = f;
                    break;
                }
                ++n2;
            }
            if (toOpen != null) {
                final File openFile = toOpen;
                openFile.setReadOnly();
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            EditorsHelper.openExternalFileInEditor((File)openFile, (Runnable[])new Runnable[0]);
                        }
                        catch (PartInitException e) {
                            LogFactory.getLog(ToolIntegrationDocumentationGUIHelper.class).error((Object)"Could not open documentation: ", (Throwable)e);
                        }
                    }
                });
            }
        }
        isCurrentlyLoading.set(false);
    }

    public static ToolIntegrationDocumentationGUIHelper getInstance() {
        return instance;
    }
}

