/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.configuration.bootstrap.profile;

import de.rcenvironment.core.configuration.bootstrap.profile.BaseProfile;
import de.rcenvironment.core.configuration.bootstrap.profile.CommonProfileException;
import de.rcenvironment.core.configuration.bootstrap.profile.CommonProfileUtils;
import de.rcenvironment.core.configuration.bootstrap.profile.ProfileException;
import de.rcenvironment.core.configuration.bootstrap.profile.ProfileUtils;
import java.io.File;

public class Profile
extends BaseProfile {
    public static final Integer PROFILE_VERSION_NUMBER = 1;
    public static final String PROFILE_SHUTDOWN_DATA_SUBDIR = "internal";

    public Profile(File profileDirectory) throws ProfileException {
        this(profileDirectory, PROFILE_VERSION_NUMBER, true, false);
    }

    public Profile(File profileDirectory, boolean create) throws ProfileException {
        this(profileDirectory, PROFILE_VERSION_NUMBER, create, false);
    }

    public Profile(File profileDirectory, boolean create, boolean allowLegacyProfile) throws ProfileException {
        this(profileDirectory, PROFILE_VERSION_NUMBER, create, allowLegacyProfile);
    }

    public Profile(File profileDirectory, int version, boolean create) throws ProfileException {
        this(profileDirectory, version, create, false);
    }

    public Profile(File profileDirectory, int version, boolean create, boolean allowLegacyProfile) throws ProfileException {
        super(profileDirectory, version);
        if (profileDirectory.getName().equals("common")) {
            throw new ProfileException("Error: The profile \"common\" can not be used as it is reserved for cross-profile settings");
        }
        super.init(create, allowLegacyProfile);
    }

    public boolean hasValidVersion() {
        return this.version == PROFILE_VERSION_NUMBER;
    }

    public String toString() {
        return this.getName();
    }

    public void markAsDefaultProfile() throws ProfileException {
        try {
            CommonProfileUtils.markAsDefaultProfile(this);
        }
        catch (CommonProfileException e) {
            throw new ProfileException(e.getMessage(), e);
        }
    }

    public void markAsRecentlyUsed() throws ProfileException {
        try {
            CommonProfileUtils.markAsRecentlyUsed(this);
        }
        catch (CommonProfileException e) {
            throw new ProfileException(e.getMessage(), e);
        }
    }

    public String getLocationDependentName() {
        File profileParentDir;
        try {
            profileParentDir = ProfileUtils.getProfilesParentDirectory();
        }
        catch (ProfileException profileException) {
            profileParentDir = null;
        }
        if (profileParentDir != null && profileParentDir.equals(this.getProfileDirectory().getParentFile())) {
            return this.getName();
        }
        return this.getProfileDirectory().getAbsolutePath();
    }
}

