/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.internal;

import java.lang.reflect.Proxy;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.Factory;
import org.easymock.ConstructorArgs;
import org.easymock.internal.ClassProxyFactory;
import org.easymock.internal.MocksControl;
import org.easymock.internal.ObjectMethodsFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassExtensionHelper {
    private static final ThreadLocal<ConstructorArgs> currentConstructorArgs = new ThreadLocal();

    private ClassExtensionHelper() {
    }

    public static void setCurrentConstructorArgs(ConstructorArgs args) {
        currentConstructorArgs.set(args);
    }

    public static ConstructorArgs getCurrentConstructorArgs() {
        return currentConstructorArgs.get();
    }

    public static ClassProxyFactory.MockMethodInterceptor getInterceptor(Object mock) {
        Factory factory = (Factory)mock;
        return (ClassProxyFactory.MockMethodInterceptor)factory.getCallback(0);
    }

    public static MocksControl getControl(Object mock) {
        try {
            ObjectMethodsFilter handler;
            if (Proxy.isProxyClass(mock.getClass())) {
                handler = (ObjectMethodsFilter)Proxy.getInvocationHandler(mock);
            } else if (Enhancer.isEnhanced(mock.getClass())) {
                handler = (ObjectMethodsFilter)ClassExtensionHelper.getInterceptor(mock).getHandler();
            } else {
                throw new IllegalArgumentException("Not a mock: " + mock.getClass().getName());
            }
            return handler.getDelegate().getControl();
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Not a mock: " + mock.getClass().getName());
        }
    }

    public static <T, V extends T> Class<T> getMockedType(V proxy) {
        if (Proxy.isProxyClass(proxy.getClass())) {
            return proxy.getClass().getInterfaces()[0];
        }
        return proxy.getClass().getSuperclass();
    }
}

