/*
 * Decompiled with CFR 0.152.
 */
package nu.psnet.quickimage.editors;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import nu.psnet.quickimage.QuickImagePlugin;
import nu.psnet.quickimage.core.ImageOrganizer;
import nu.psnet.quickimage.core.QManager;
import nu.psnet.quickimage.widgets.QStatusCanvas;
import nu.psnet.quickimage.widgets.QuickImageCanvas;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;

public class QuickImageEditor
extends EditorPart {
    private ToolItem previous;
    private ToolItem next;
    private ToolItem rotate;
    private ToolItem zoomIn;
    private ToolItem zoomOut;
    private ToolItem zoomOrg;
    private ToolItem zoomFit;
    private ToolItem view;
    private Image viewThumb;
    private Image viewFullsize;
    private Composite parent;
    private String iconsdir = null;
    private QManager manager;

    public void createPartControl(Composite parent) {
        this.parent = parent;
        this.manager = new QManager();
        this.manager.setImageOrganizer(new ImageOrganizer(this.manager, parent.getDisplay()));
        this.manager.setImageEditor(this);
        try {
            this.iconsdir = String.valueOf(Platform.resolve((URL)QuickImagePlugin.getDefault().getBundle().getEntry("/")).getFile()) + "icons" + File.separator;
        }
        catch (IOException iOException) {}
        IEditorInput editorInput = this.getEditorInput();
        if (editorInput instanceof FileEditorInput) {
            FileEditorInput fileEditorInput = (FileEditorInput)this.getEditorInput();
            IEditorInput file = this.getEditorInput();
            this.setPartName(file.getName());
            this.manager.getImageOrganizer().setPath(fileEditorInput.getPath().removeLastSegments(1).toOSString(), fileEditorInput.getName());
        } else if (editorInput.getAdapter(ILocationProvider.class) != null) {
            ILocationProvider location = (ILocationProvider)editorInput.getAdapter(ILocationProvider.class);
            IPath path = location.getPath((Object)editorInput);
            this.setPartName(editorInput.getName());
            this.manager.getImageOrganizer().setPath(path.removeLastSegments(1).toOSString(), editorInput.getName());
        } else if (editorInput instanceof IStorageEditorInput) {
            IStorageEditorInput storageEditorInput = (IStorageEditorInput)editorInput;
            try {
                IStorage storage = storageEditorInput.getStorage();
                this.setPartName(storage.getName());
                this.manager.getImageOrganizer().setStorage(storage);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        } else if (editorInput.getAdapter(IFile.class) != null) {
            IFile file = (IFile)editorInput.getAdapter(IFile.class);
            this.setPartName(file.getName());
            this.manager.getImageOrganizer().setPath(file.getLocation().removeLastSegments(1).toOSString(), file.getName());
        }
        this.initElements();
        this.manager.getImageOrganizer().setActiveView(1);
        this.manager.getImageCanvas().setIconsPath(this.iconsdir);
        this.manager.getImageCanvas().updateFullsizeData();
        this.manager.getStatusCanvas().updateWithCurrent();
    }

    private void initElements() {
        FormLayout layout = new FormLayout();
        Composite compos = new Composite(this.parent, 0);
        compos.setLayout((Layout)layout);
        compos.setLayoutData((Object)new FormData());
        FormData toolbarData = new FormData();
        this.manager.setImageCanvas(new QuickImageCanvas(this.manager, compos, 0));
        this.manager.setStatusCanvas(new QStatusCanvas(this.manager, compos, 0));
        ToolBar toolBar = new ToolBar(compos, 0x800000);
        toolBar.setLayoutData((Object)toolbarData);
        this.previous = new ToolItem(toolBar, 0x800000);
        this.previous.setToolTipText("Previous Image");
        this.previous.setImage(new Image((Device)this.parent.getDisplay(), String.valueOf(this.iconsdir) + "previous.gif"));
        this.previous.setSelection(true);
        this.next = new ToolItem(toolBar, 0x800000);
        this.next.setToolTipText("Next Image");
        this.next.setImage(new Image((Device)this.parent.getDisplay(), String.valueOf(this.iconsdir) + "next.gif"));
        this.rotate = new ToolItem(toolBar, 0x800000);
        this.rotate.setToolTipText("Rotate");
        this.rotate.setImage(new Image((Device)this.parent.getDisplay(), String.valueOf(this.iconsdir) + "rotate.gif"));
        this.viewThumb = new Image((Device)this.parent.getDisplay(), String.valueOf(this.iconsdir) + "thumb.gif");
        this.viewFullsize = new Image((Device)this.parent.getDisplay(), String.valueOf(this.iconsdir) + "fullsize.gif");
        this.view = new ToolItem(toolBar, 0x800000);
        this.view.setToolTipText("view Thumbnails");
        this.view.setImage(this.viewThumb);
        new ToolItem(toolBar, 2);
        this.zoomIn = new ToolItem(toolBar, 0x800000);
        this.zoomIn.setToolTipText("zoom in");
        this.zoomIn.setImage(new Image((Device)this.parent.getDisplay(), String.valueOf(this.iconsdir) + "zoom_in.gif"));
        this.zoomOut = new ToolItem(toolBar, 0x800000);
        this.zoomOut.setToolTipText("zoom out");
        this.zoomOut.setImage(new Image((Device)this.parent.getDisplay(), String.valueOf(this.iconsdir) + "zoom_out.gif"));
        this.zoomOrg = new ToolItem(toolBar, 0x800000);
        this.zoomOrg.setToolTipText("zoom original size");
        this.zoomOrg.setImage(new Image((Device)this.parent.getDisplay(), String.valueOf(this.iconsdir) + "zoom_100.gif"));
        this.zoomFit = new ToolItem(toolBar, 32);
        this.zoomFit.setToolTipText("fit image in window");
        this.zoomFit.setImage(new Image((Device)this.parent.getDisplay(), String.valueOf(this.iconsdir) + "zoom_fit.gif"));
        FormData canvasData = new FormData();
        this.manager.getImageCanvas().setLayoutData(canvasData);
        FormData statusData = new FormData();
        this.manager.getStatusCanvas().setLayoutData(statusData);
        canvasData.top = new FormAttachment((Control)toolBar, 0);
        canvasData.bottom = new FormAttachment(100, -18);
        canvasData.right = new FormAttachment(100, 0);
        canvasData.left = new FormAttachment(0, 0);
        toolbarData.top = new FormAttachment(0, 0);
        toolbarData.left = new FormAttachment(0, 0);
        toolbarData.right = new FormAttachment(100, 0);
        statusData.top = new FormAttachment((Control)this.manager.getImageCanvas(), 0);
        statusData.bottom = new FormAttachment(100, 0);
        statusData.right = new FormAttachment(100, 0);
        statusData.left = new FormAttachment(0, 0);
        this.rotate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QuickImageEditor.this.zoomFit.setSelection(false);
                QuickImageEditor.this.manager.getImageCanvas().rotate();
            }
        });
        this.previous.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QuickImageEditor.this.clickedPrevious(e);
            }
        });
        this.next.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QuickImageEditor.this.clickedNext(e);
            }
        });
        this.view.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QuickImageEditor.this.toggleView();
            }
        });
        this.zoomIn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QuickImageEditor.this.zoomFit.setSelection(false);
                QuickImageEditor.this.manager.getImageCanvas().zoomIn();
            }
        });
        this.zoomOut.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QuickImageEditor.this.zoomFit.setSelection(false);
                QuickImageEditor.this.manager.getImageCanvas().zoomOut();
            }
        });
        this.zoomFit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QuickImageEditor.this.manager.getImageCanvas().zoomFit();
            }
        });
        this.zoomOrg.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QuickImageEditor.this.zoomFit.setSelection(false);
                QuickImageEditor.this.manager.getImageCanvas().zoomOriginal();
            }
        });
        this.manager.getImageCanvas().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                if (QuickImageEditor.this.zoomFit.getSelection()) {
                    QuickImageEditor.this.manager.getImageCanvas().zoomFit();
                }
            }
        });
        this.previous.setEnabled(this.manager.getImageOrganizer().hasPrevious());
        this.next.setEnabled(this.manager.getImageOrganizer().hasNext());
        if (this.manager.getImageOrganizer().isSingle()) {
            this.next.setEnabled(false);
            this.previous.setEnabled(false);
            this.view.setEnabled(false);
        }
    }

    public void dispose() {
        this.manager.getImageOrganizer().dispose();
        this.manager.getImageCanvas().dispose();
        this.manager.getStatusCanvas().dispose();
        super.dispose();
    }

    public void toggleView() {
        if (this.manager.getImageOrganizer().getActiveView() == 1) {
            this.previous.setEnabled(false);
            this.next.setEnabled(false);
            this.rotate.setEnabled(false);
            this.manager.getImageOrganizer().setActiveView(0);
            this.manager.getImageOrganizer().setCurrentToSelected();
            this.view.setImage(this.viewFullsize);
            this.view.setToolTipText("View Fullsize");
            this.view.setEnabled(false);
            this.view.setEnabled(true);
            this.zoomIn.setEnabled(false);
            this.zoomOut.setEnabled(false);
            this.zoomFit.setEnabled(false);
            this.zoomOrg.setEnabled(false);
        } else {
            this.previous.setEnabled(this.manager.getImageOrganizer().hasPrevious());
            this.next.setEnabled(this.manager.getImageOrganizer().hasNext());
            this.rotate.setEnabled(true);
            this.manager.getImageOrganizer().setActiveView(1);
            this.view.setImage(this.viewThumb);
            this.view.setToolTipText("View Thumbnails");
            this.manager.getImageCanvas().updateFullsizeData();
            this.view.setEnabled(false);
            this.view.setEnabled(true);
            this.zoomIn.setEnabled(true);
            this.zoomOut.setEnabled(true);
            this.zoomFit.setSelection(false);
            this.zoomFit.setEnabled(true);
            this.zoomOrg.setEnabled(true);
        }
        this.manager.getImageCanvas().updateThumbData();
    }

    private void clickedPrevious(SelectionEvent e) {
        this.manager.getImageOrganizer().getPrevious();
        this.manager.getImageCanvas().updateFullsizeData();
        this.manager.getStatusCanvas().updateWithCurrent();
        this.setPartName(this.manager.getImageOrganizer().getCurrent().getDisplayName());
        this.previous.setEnabled(this.manager.getImageOrganizer().hasPrevious());
        this.next.setEnabled(this.manager.getImageOrganizer().hasNext());
    }

    private void clickedNext(SelectionEvent e) {
        this.manager.getImageOrganizer().getNext();
        this.manager.getImageCanvas().updateFullsizeData();
        this.manager.getStatusCanvas().updateWithCurrent();
        this.setPartName(this.manager.getImageOrganizer().getCurrent().getDisplayName());
        this.previous.setEnabled(this.manager.getImageOrganizer().hasPrevious());
        this.next.setEnabled(this.manager.getImageOrganizer().hasNext());
    }

    public void setPartName(String s) {
        super.setPartName(s);
    }

    public void init(IEditorSite site, IEditorInput input) {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
    }

    public void setFocus() {
        if (this.manager.getImageCanvas() != null) {
            this.manager.getImageCanvas().setFocus();
        }
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public String getIconsdir() {
        return this.iconsdir;
    }

    public void setIconsdir(String iconsdir) {
        this.iconsdir = iconsdir;
    }
}

