/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.ui.internal.viewers.SelectSingleFilePage;
import org.eclipse.wst.xsd.ui.internal.editor.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.util.ViewUtility;
import org.eclipse.wst.xsd.ui.internal.wizards.XSDLocationChoicePage;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.util.XSDParser;

public class XSDSelectIncludeFileWizard
extends Wizard
implements INewWizard {
    boolean isInclude;
    XSDSchema mainSchema;
    XSDSchema externalSchema;
    XSDLocationChoicePage choicePage;
    XSDSelectSingleFilePage filePage;
    XSDURLPage urlPage;
    IFile resultFile;
    String resultURL;
    String namespace = "";
    static /* synthetic */ Class class$0;

    public XSDSelectIncludeFileWizard(XSDSchema mainSchema, boolean isInclude, String title, String desc, ViewerFilter filter, IStructuredSelection selection) {
        this.setWindowTitle(title);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.xsd.ui.internal.editor.XSDEditorPlugin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setDefaultPageImageDescriptor(ImageDescriptor.createFromFile((Class)clazz, (String)"icons/NewXSD.png"));
        this.setNeedsProgressMonitor(true);
        this.choicePage = new XSDLocationChoicePage();
        this.filePage = new XSDSelectSingleFilePage(PlatformUI.getWorkbench(), selection, true);
        this.filePage.setTitle(title);
        this.filePage.setDescription(desc);
        this.filePage.addFilter(filter);
        this.urlPage = new XSDURLPage();
        this.urlPage.setTitle(title);
        this.urlPage.setDescription(XSDEditorPlugin.getXSDString("_UI_FILEDIALOG_SELECT_XML_URL"));
        this.mainSchema = mainSchema;
        this.isInclude = isInclude;
    }

    public void init(IWorkbench aWorkbench, IStructuredSelection aSelection) {
    }

    public void addPages() {
        this.addPage((IWizardPage)this.choicePage);
        this.addPage((IWizardPage)this.filePage);
        this.addPage((IWizardPage)this.urlPage);
    }

    public IWizardPage getNextPage(IWizardPage currentPage) {
        Object nextPage = null;
        if (currentPage == this.choicePage) {
            nextPage = this.choicePage.isURL() ? this.urlPage : this.filePage;
        }
        return nextPage;
    }

    public boolean canFinish() {
        if (!this.choicePage.isURL()) {
            return this.filePage.isPageComplete();
        }
        return true;
    }

    public boolean performFinish() {
        if (this.choicePage.isURL()) {
            try {
                this.getContainer().run(false, true, this.urlPage.getRunnable());
                this.resultURL = this.urlPage.getURL();
            }
            catch (Exception exception) {
                return false;
            }
            return true;
        }
        this.resultFile = this.filePage.getFile();
        return true;
    }

    public XSDSchema getExternalSchema() {
        return this.externalSchema;
    }

    public IFile getResultFile() {
        return this.resultFile;
    }

    public String getURL() {
        return this.resultURL;
    }

    public String getNamespace() {
        return this.namespace;
    }

    protected String doLoadExternalModel(IProgressMonitor monitor, String xsdModelFile, String xsdFileName) {
        String errorMessage = null;
        String currentNameSpace = this.mainSchema.getTargetNamespace();
        monitor.beginTask("Loading XML Schema", 100);
        monitor.worked(50);
        XSDParser parser = new XSDParser();
        parser.parse(xsdModelFile);
        this.externalSchema = parser.getSchema();
        if (this.externalSchema != null) {
            String extNamespace;
            this.namespace = extNamespace = this.externalSchema.getTargetNamespace();
            if (this.externalSchema.getDiagnostics() != null && this.externalSchema.getDiagnostics().size() > 0) {
                errorMessage = XSDEditorPlugin.getPlugin().getString("_UI_INCORRECT_XML_SCHEMA", xsdFileName);
            } else if (this.isInclude) {
                if (extNamespace != null && currentNameSpace != null && !extNamespace.equals(currentNameSpace)) {
                    errorMessage = XSDEditorPlugin.getPlugin().getString("_UI_DIFFERENT_NAME_SPACE", xsdFileName);
                }
            } else if (extNamespace != null && currentNameSpace != null && extNamespace.equals(currentNameSpace)) {
                errorMessage = XSDEditorPlugin.getPlugin().getString("_UI_SAME_NAME_SPACE", xsdFileName);
            }
        } else {
            errorMessage = XSDEditorPlugin.getPlugin().getString("_UI_INCORRECT_XML_SCHEMA", xsdFileName);
        }
        monitor.subTask("Finish Loading");
        monitor.worked(80);
        return errorMessage;
    }

    class XSDSelectSingleFilePage
    extends SelectSingleFilePage {
        public XSDSelectSingleFilePage(IWorkbench workbench, IStructuredSelection selection, boolean isFileMandatory) {
            super(workbench, selection, isFileMandatory);
        }

        private boolean openExternalSchema() {
            IFile iFile = this.getFile();
            if (iFile == null) {
                return false;
            }
            this.setErrorMessage(null);
            String xsdModelFile = iFile.getLocationURI().toString();
            String xsdFileName = iFile.getName();
            String errorMessage = XSDSelectIncludeFileWizard.this.doLoadExternalModel((IProgressMonitor)new NullProgressMonitor(), xsdModelFile, xsdFileName);
            if (errorMessage != null) {
                this.setErrorMessage(errorMessage);
                return false;
            }
            return true;
        }

        public boolean isPageComplete() {
            if (XSDSelectIncludeFileWizard.this.choicePage.isURL()) {
                return true;
            }
            if (super.isPageComplete()) {
                return this.openExternalSchema();
            }
            return super.isPageComplete();
        }
    }

    class XSDURLPage
    extends WizardPage {
        Text urlField;
        String saveString;

        public XSDURLPage() {
            super("URLPage");
        }

        public void createControl(Composite parent) {
            Composite client = ViewUtility.createComposite(parent, 2);
            ViewUtility.setComposite(client);
            ViewUtility.createLabel(client, XSDEditorPlugin.getXSDString("_UI_LABEL_URL"));
            ViewUtility.createLabel(client, "");
            this.urlField = ViewUtility.createTextField(client, 50);
            this.saveString = "http://";
            this.urlField.setText(this.saveString);
            this.setControl((Control)client);
        }

        public String getURL() {
            return this.urlField.getText();
        }

        private boolean openExternalSchema(IProgressMonitor monitor) {
            String text = this.urlField.getText();
            if (text.equals("")) {
                this.setErrorMessage(XSDEditorPlugin.getXSDString("_UI_SPECIFY_URL"));
                return false;
            }
            if (!text.startsWith("http://")) {
                this.setErrorMessage(XSDEditorPlugin.getXSDString("_UI_URL_START_WITH"));
                return false;
            }
            this.setErrorMessage(null);
            String errorMessage = XSDSelectIncludeFileWizard.this.doLoadExternalModel(monitor, text, text);
            if (errorMessage != null) {
                this.setErrorMessage(errorMessage);
                return false;
            }
            return true;
        }

        public IRunnableWithProgress getRunnable() {
            return new IRunnableWithProgress(this){
                final /* synthetic */ XSDURLPage this$1;
                {
                    this.this$1 = xSDURLPage;
                }

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    if (monitor == null) {
                        monitor = new NullProgressMonitor();
                    }
                    monitor.beginTask("", 6);
                    boolean ok = XSDURLPage.access$0(this.this$1, monitor);
                    if (!ok) {
                        throw new InvocationTargetException(new Error());
                    }
                    monitor.done();
                }
            };
        }

        static /* synthetic */ boolean access$0(XSDURLPage xSDURLPage, IProgressMonitor iProgressMonitor) {
            return xSDURLPage.openExternalSchema(iProgressMonitor);
        }
    }
}

