/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region.virtual;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.broker.region.Subscription;
import org.apache.activemq.broker.region.virtual.VirtualTopic;
import org.apache.activemq.broker.region.virtual.VirtualTopicInterceptor;
import org.apache.activemq.command.Message;
import org.apache.activemq.filter.BooleanExpression;
import org.apache.activemq.filter.MessageEvaluationContext;
import org.apache.activemq.filter.NonCachedMessageEvaluationContext;
import org.apache.activemq.plugin.SubQueueSelectorCacheBroker;
import org.apache.activemq.selector.SelectorParser;
import org.apache.activemq.util.LRUCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectorAwareVirtualTopicInterceptor
extends VirtualTopicInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(SelectorAwareVirtualTopicInterceptor.class);
    LRUCache<String, BooleanExpression> expressionCache = new LRUCache();
    private SubQueueSelectorCacheBroker selectorCachePlugin;

    public SelectorAwareVirtualTopicInterceptor(Destination next, VirtualTopic virtualTopic) {
        super(next, virtualTopic);
    }

    @Override
    protected boolean shouldDispatch(Broker broker, Message message, Destination dest) throws IOException {
        boolean matches = false;
        NonCachedMessageEvaluationContext msgContext = new NonCachedMessageEvaluationContext();
        msgContext.setDestination(dest.getActiveMQDestination());
        msgContext.setMessageReference((MessageReference)message);
        List<Subscription> subs = dest.getConsumers();
        for (Subscription sub : subs) {
            if (!sub.matches((MessageReference)message, (MessageEvaluationContext)msgContext)) continue;
            matches = true;
            break;
        }
        if (!matches) {
            matches = this.tryMatchingCachedSubs(broker, dest, (MessageEvaluationContext)msgContext);
        }
        return matches;
    }

    private boolean tryMatchingCachedSubs(Broker broker, Destination dest, MessageEvaluationContext msgContext) {
        Set<String> selectors;
        boolean matches = false;
        LOG.debug("No active consumer match found. Will try cache if configured...");
        SubQueueSelectorCacheBroker cache = this.getSubQueueSelectorCacheBrokerPlugin(broker);
        if (cache != null && (selectors = cache.getSelector(dest.getActiveMQDestination().getQualifiedName())) != null) {
            for (String selector : selectors) {
                try {
                    BooleanExpression expression = this.getExpression(selector);
                    matches = expression.matches(msgContext);
                    if (!matches) continue;
                    return true;
                }
                catch (Exception e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return matches;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BooleanExpression getExpression(String selector) throws Exception {
        BooleanExpression result;
        LRUCache<String, BooleanExpression> lRUCache = this.expressionCache;
        synchronized (lRUCache) {
            result = (BooleanExpression)this.expressionCache.get((Object)selector);
            if (result == null) {
                result = this.compileSelector(selector);
                this.expressionCache.put((Object)selector, (Object)result);
            }
        }
        return result;
    }

    private SubQueueSelectorCacheBroker getSubQueueSelectorCacheBrokerPlugin(Broker broker) {
        if (this.selectorCachePlugin == null) {
            this.selectorCachePlugin = (SubQueueSelectorCacheBroker)broker.getAdaptor(SubQueueSelectorCacheBroker.class);
        }
        return this.selectorCachePlugin;
    }

    private BooleanExpression compileSelector(String selectorExpression) throws Exception {
        return SelectorParser.parse((String)selectorExpression);
    }
}

