/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.datamanagement.backend.metadata.derby.internal;

import de.rcenvironment.core.utils.common.StringUtils;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;

final class PooledConnectionInvocationHandler
implements InvocationHandler {
    private final Connection connection;
    private int count = 0;

    PooledConnectionInvocationHandler(Connection connection) {
        this.connection = connection;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        boolean execute = true;
        if (method.getName().equals("increment")) {
            ++this.count;
            execute = false;
        } else if (method.getName().equals("decrement")) {
            --this.count;
            execute = false;
        } else if (method.getName().equals("close")) {
            --this.count;
            if (this.count > 0) {
                execute = false;
            }
        }
        if (this.count == 0) {
            try {
                if (!this.connection.isClosed()) {
                    this.connection.close();
                }
            }
            catch (SQLException e) {
                throw new RuntimeException("Failed to close connection.", e);
            }
        }
        if (execute) {
            try {
                return method.invoke((Object)this.connection, args);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new RuntimeException(StringUtils.format((String)"Failed to execute database query. %s", (Object[])new Object[]{e.getMessage()}));
            }
        }
        return null;
    }
}

