/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.script.gui;

import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescriptionsManager;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.EndpointType;
import de.rcenvironment.core.gui.workflow.editor.properties.DefaultEndpointPropertySection;
import de.rcenvironment.core.gui.workflow.editor.properties.EndpointSelectionPane;
import de.rcenvironment.core.gui.workflow.editor.properties.Messages;
import de.rcenvironment.core.gui.workflow.editor.properties.WorkflowNodeCommand;
import de.rcenvironment.core.gui.workflow.editor.properties.WorkflowNodePropertySection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class ScriptEndpointSection
extends DefaultEndpointPropertySection {
    private EndpointSelectionPane inputPane = new EndpointSelectionPane(Messages.inputs, EndpointType.INPUT, "default", new String[]{"or"}, new String[0], (WorkflowNodeCommand.Executor)this);
    private Button orGroupCheckbox;

    public ScriptEndpointSection() {
        EndpointSelectionPane outputPane = new EndpointSelectionPane(Messages.outputs, EndpointType.OUTPUT, "default", new String[0], new String[0], (WorkflowNodeCommand.Executor)this);
        this.setColumns(2);
        this.setPanes(new EndpointSelectionPane[]{this.inputPane, outputPane});
    }

    public void createCompositeContent(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createCompositeContent(parent, aTabbedPropertySheetPage);
        TabbedPropertySheetWidgetFactory toolkit = aTabbedPropertySheetPage.getWidgetFactory();
        Composite noteComposite = toolkit.createComposite(this.endpointsComposite);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        noteComposite.setLayoutData((Object)gridData);
        noteComposite.setLayout((Layout)new GridLayout(1, false));
        this.orGroupCheckbox = new Button(noteComposite, 32);
        this.orGroupCheckbox.setText("Execute on each new input value");
        this.orGroupCheckbox.setData("property.control", (Object)"xor");
        this.orGroupCheckbox.setBackground(Display.getCurrent().getSystemColor(1));
        Label noteLabel = new Label(noteComposite, 8);
        noteLabel.setText("(ie inputs have an 'xor' relation instead of an 'and' relation)");
    }

    public void aboutToBeShown() {
        super.aboutToBeShown();
        this.inputPane.refresh();
    }

    protected WorkflowNodePropertySection.Synchronizer createSynchronizer() {
        return new ScriptWidgetsSynchronizer();
    }

    protected WorkflowNodePropertySection.Updater createUpdater() {
        return new ScriptWidgetsUpdater();
    }

    private void switchDynamicInputIds(boolean xor) {
        if (xor) {
            this.switchDynamicInputsId("or");
        } else {
            this.switchDynamicInputsId("default");
        }
    }

    private void switchDynamicInputsId(String toDynamicInputId) {
        this.inputPane.updateDynamicEndpointIdToManage(toDynamicInputId);
        EndpointDescriptionsManager inputDescriptionsManager = this.getConfiguration().getInputDescriptionsManager();
        for (EndpointDescription ep : inputDescriptionsManager.getEndpointDescriptions()) {
            inputDescriptionsManager.removeDynamicEndpointDescriptionQuietely(ep.getName());
            ep.getMetaData().remove("inputExecutionConstraint_4aae3eea");
            inputDescriptionsManager.addDynamicEndpointDescription(toDynamicInputId, ep.getName(), ep.getDataType(), ep.getMetaData(), ep.getIdentifier());
            if (ep.getConnectedDataTypes().isEmpty()) continue;
            inputDescriptionsManager.addConnectedDataType(ep.getName(), (DataType)ep.getConnectedDataTypes().get(0));
        }
    }

    private class ScriptWidgetsSynchronizer
    extends WorkflowNodePropertySection.DefaultSynchronizer {
        private ScriptWidgetsSynchronizer() {
            super((WorkflowNodePropertySection)ScriptEndpointSection.this);
        }

        protected void handlePropertyChange(Control control, String key, String newValue, String oldValue) {
            if (key.equals("xor")) {
                ScriptEndpointSection.this.switchDynamicInputIds(Boolean.parseBoolean(newValue));
            }
            super.handlePropertyChange(control, key, newValue, oldValue);
        }
    }

    private class ScriptWidgetsUpdater
    extends WorkflowNodePropertySection.DefaultUpdater {
        private ScriptWidgetsUpdater() {
            super((WorkflowNodePropertySection)ScriptEndpointSection.this);
        }

        public void updateControl(Control control, String propertyName, String newValue, String oldValue) {
            if (propertyName.equals("xor") && Boolean.parseBoolean(newValue)) {
                ScriptEndpointSection.this.inputPane.updateDynamicEndpointIdToManage("or");
            }
            super.updateControl(control, propertyName, newValue, oldValue);
        }
    }
}

