/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search2.internal.ui;

import com.ibm.icu.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.LegacyActionTools;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.search.internal.ui.OpenSearchDialogAction;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.ui.IQueryListener;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.ISearchResultPage;
import org.eclipse.search.ui.ISearchResultViewPart;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search2.internal.ui.CancelSearchAction;
import org.eclipse.search2.internal.ui.InternalSearchUI;
import org.eclipse.search2.internal.ui.OpenSearchPreferencesAction;
import org.eclipse.search2.internal.ui.PinSearchViewAction;
import org.eclipse.search2.internal.ui.SearchAgainAction;
import org.eclipse.search2.internal.ui.SearchHistoryDropDownAction;
import org.eclipse.search2.internal.ui.SearchMessages;
import org.eclipse.search2.internal.ui.SearchPageRegistry;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ContributionItemFactory;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.operations.UndoRedoActionGroup;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.PageBookView;
import org.eclipse.ui.part.PageSwitcher;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public class SearchView
extends PageBookView
implements ISearchResultViewPart,
IQueryListener {
    private static final String MEMENTO_TYPE = "view";
    private static final String MEMENTO_KEY_IS_PINNED = "isPinned";
    private static final String MEMENTO_KEY_LAST_ACTIVATION = "org.eclipse.search.lastActivation";
    private static final String MEMENTO_KEY_RESTORE = "org.eclipse.search.restore";
    private HashMap fPartsToPages = new HashMap();
    private HashMap fPagesToParts = new HashMap();
    private HashMap fSearchViewStates;
    private SearchPageRegistry fSearchViewPageService = new SearchPageRegistry();
    private SearchHistoryDropDownAction fSearchesDropDownAction;
    private ISearchResult fCurrentSearch;
    private DummyPart fDefaultPart;
    private SearchAgainAction fSearchAgainAction;
    private CancelSearchAction fCancelAction;
    private PinSearchViewAction fPinSearchViewAction;
    private UndoRedoActionGroup fUndoRedoActionGroup;
    private IMemento fPageState;
    private boolean fIsPinned = false;
    private int fActivationCount = 0;
    private String fDefaultPartName;
    private Composite fPageContent;
    private Link fDescription;
    private Composite fDescriptionComposite;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public static void createContextMenuGroups(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("group.new"));
        menu.add((IContributionItem)new GroupMarker("group.goto"));
        menu.add((IContributionItem)new GroupMarker("group.open"));
        menu.add((IContributionItem)new Separator("group.show"));
        menu.add((IContributionItem)new GroupMarker("group.removeMatches"));
        menu.add((IContributionItem)new Separator("group.edit"));
        menu.add((IContributionItem)new Separator("group.reorganize"));
        menu.add((IContributionItem)new GroupMarker("group.generate"));
        menu.add((IContributionItem)new Separator("group.search"));
        menu.add((IContributionItem)new Separator("group.build"));
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new Separator("group.viewerSetup"));
        menu.add((IContributionItem)new Separator("group.properties"));
    }

    private static void createViewMenuGroups(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("group.viewerSetup"));
        menu.add((IContributionItem)new Separator("group.new"));
        menu.add((IContributionItem)new GroupMarker("group.goto"));
        menu.add((IContributionItem)new GroupMarker("group.open"));
        menu.add((IContributionItem)new Separator("group.show"));
        menu.add((IContributionItem)new Separator("group.edit"));
        menu.add((IContributionItem)new GroupMarker("group.removeMatches"));
        menu.add((IContributionItem)new Separator("group.reorganize"));
        menu.add((IContributionItem)new GroupMarker("group.generate"));
        menu.add((IContributionItem)new Separator("group.search"));
        menu.add((IContributionItem)new Separator("group.build"));
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new Separator("group.filtering"));
        menu.add((IContributionItem)new Separator("group.properties"));
    }

    public static void createToolBarGroups(IToolBarManager toolbar) {
        toolbar.add((IContributionItem)new Separator("group.new"));
        toolbar.add((IContributionItem)new GroupMarker("group.goto"));
        toolbar.add((IContributionItem)new GroupMarker("group.open"));
        toolbar.add((IContributionItem)new Separator("group.show"));
        toolbar.add((IContributionItem)new Separator("group.build"));
        toolbar.add((IContributionItem)new Separator("group.reorganize"));
        toolbar.add((IContributionItem)new Separator("group.edit"));
        toolbar.add((IContributionItem)new GroupMarker("group.removeMatches"));
        toolbar.add((IContributionItem)new GroupMarker("group.generate"));
        toolbar.add((IContributionItem)new Separator("additions"));
        toolbar.add((IContributionItem)new Separator("group.viewerSetup"));
        toolbar.add((IContributionItem)new Separator("group.properties"));
        toolbar.add((IContributionItem)new Separator("group.search"));
    }

    public SearchView() {
        this.fSearchViewStates = new HashMap();
    }

    public SearchPageRegistry getSearchPageRegistry() {
        return this.fSearchViewPageService;
    }

    public void partActivated(IWorkbenchPart part) {
        super.partActivated(part);
        if (part == this) {
            InternalSearchUI.getInstance().getSearchViewManager().searchViewActivated(this);
        }
    }

    protected IPage createDefaultPage(PageBook book) {
        EmptySearchView page = new EmptySearchView();
        page.createControl((Composite)book);
        this.initPage(page);
        DummyPart part = new DummyPart();
        this.fPartsToPages.put(part, page);
        this.fPagesToParts.put(page, part);
        this.fDefaultPart = part;
        return page;
    }

    protected PageBookView.PageRec doCreatePage(IWorkbenchPart part) {
        IPageBookViewPage page = (IPageBookViewPage)this.fPartsToPages.get(part);
        this.initPage(page);
        page.createControl((Composite)this.getPageBook());
        PageBookView.PageRec rec = new PageBookView.PageRec(part, (IPage)page);
        return rec;
    }

    protected void doDestroyPage(IWorkbenchPart part, PageBookView.PageRec pageRecord) {
        IPage page = pageRecord.page;
        page.dispose();
        pageRecord.dispose();
        this.fPartsToPages.remove(part);
    }

    protected IWorkbenchPart getBootstrapPart() {
        return null;
    }

    protected boolean isImportant(IWorkbenchPart part) {
        return part instanceof DummyPart;
    }

    public void showSearchResult(ISearchResult search) {
        ISearchResultPage newPage = null;
        if (search != null && (newPage = this.fSearchViewPageService.findPageForSearchResult(search, true)) == null) {
            String format = SearchMessages.SearchView_error_noResultPage;
            String message = MessageFormat.format((String)format, (Object[])new Object[]{search.getClass().getName()});
            SearchPlugin.log((IStatus)new Status(4, SearchPlugin.getID(), 0, message, null));
            return;
        }
        this.internalShowSearchPage(newPage, search);
    }

    public void showEmptySearchPage(String pageId) {
        ISearchResultPage newPage = this.fSearchViewPageService.findPageForPageId(pageId, true);
        this.internalShowSearchPage(newPage, null);
    }

    private void internalShowSearchPage(ISearchResultPage page, ISearchResult search) {
        ISearchResultPage currentPage = (ISearchResultPage)this.getCurrentPage();
        if (this.fCurrentSearch != null && currentPage != null) {
            this.fSearchViewStates.put(this.fCurrentSearch, currentPage.getUIState());
            currentPage.setInput(null, null);
        }
        this.fCurrentSearch = search;
        if (page != null) {
            if (page != currentPage) {
                DummyPart part = (DummyPart)this.fPagesToParts.get(page);
                if (part == null) {
                    part = new DummyPart();
                    this.fPagesToParts.put(page, part);
                    this.fPartsToPages.put(part, page);
                    page.setViewPart(this);
                }
                part.setLastActivation(++this.fActivationCount);
                this.partActivated(part);
            }
            Object uiState = search != null ? this.fSearchViewStates.get(search) : null;
            page.setInput(search, uiState);
        }
        this.updatePartName();
        this.updateLabel();
        this.updateCancelAction();
        this.updateHelpContextID(page);
    }

    private void updateHelpContextID(ISearchResultPage page) {
        String helpContextId = null;
        String pageId = null;
        if (page != null) {
            pageId = page.getID();
        }
        if (pageId != null) {
            helpContextId = this.fSearchViewPageService.getHelpContextId(pageId);
        }
        if (helpContextId == null) {
            helpContextId = "org.eclipse.search.new_search_view_context";
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.fPageContent.getParent(), helpContextId);
    }

    public void updateLabel() {
        ISearchResultPage page = this.getActivePage();
        String label = "";
        if (page != null) {
            label = LegacyActionTools.escapeMnemonics((String)page.getLabel());
        }
        if (!this.fPageContent.isDisposed()) {
            if (label.length() == 0) {
                if (this.fDescriptionComposite != null) {
                    this.fDescriptionComposite.dispose();
                    this.fDescriptionComposite = null;
                    this.fPageContent.layout();
                }
            } else if (this.fDescriptionComposite == null) {
                this.fDescriptionComposite = new Composite(this.fPageContent, 0);
                this.fDescriptionComposite.moveAbove(null);
                GridLayout layout = new GridLayout();
                layout.marginHeight = 0;
                layout.marginWidth = 0;
                layout.verticalSpacing = 0;
                this.fDescriptionComposite.setLayout((Layout)layout);
                this.fDescriptionComposite.setLayoutData((Object)new GridData(4, 4, true, false));
                this.fDescription = new Link(this.fDescriptionComposite, 0);
                GridData gridData = new GridData(4, 0x1000000, true, false);
                gridData.horizontalIndent = 5;
                this.fDescription.setLayoutData((Object)gridData);
                this.fDescription.setText(label);
                Label separator = new Label(this.fDescriptionComposite, 258);
                separator.setLayoutData((Object)new GridData(4, 4, true, false));
                this.fPageContent.layout();
            } else {
                this.fDescription.setText(label);
            }
        }
    }

    public ISearchResult getCurrentSearchResult() {
        return this.fCurrentSearch;
    }

    public void createPartControl(Composite parent) {
        this.createActions();
        this.fPageContent = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        this.fPageContent.setLayout((Layout)layout);
        this.fDescriptionComposite = null;
        super.createPartControl(this.fPageContent);
        this.getPageBook().setLayoutData((Object)new GridData(4, 4, true, true));
        this.fDefaultPartName = this.getPartName();
        this.initializeToolBar();
        InternalSearchUI.getInstance().getSearchManager().addQueryListener(this);
        this.initializePageSwitcher();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.search.new_search_view_context");
        this.restorePageFromMemento();
        this.showLatestSearch();
    }

    private void initializePageSwitcher() {
        new PageSwitcher((IWorkbenchPart)this){

            public void activatePage(Object page) {
                ISearchResult searchResult = ((ISearchQuery)page).getSearchResult();
                InternalSearchUI.getInstance().showSearchResult(SearchView.this, searchResult, false);
            }

            public ImageDescriptor getImageDescriptor(Object page) {
                ISearchResult searchResult = ((ISearchQuery)page).getSearchResult();
                return searchResult.getImageDescriptor();
            }

            public String getName(Object page) {
                ISearchResult searchResult = ((ISearchQuery)page).getSearchResult();
                return searchResult.getLabel();
            }

            public Object[] getPages() {
                return NewSearchUI.getQueries();
            }
        };
    }

    private void restorePageFromMemento() {
        if (this.fPageState != null) {
            int bestActivation = -1;
            IMemento restorePageMemento = null;
            IMemento[] children = this.fPageState.getChildren(MEMENTO_TYPE);
            int i = 0;
            while (i < children.length) {
                Integer lastActivation;
                IMemento pageMemento = children[i];
                if (pageMemento.getString(MEMENTO_KEY_RESTORE) != null && (lastActivation = pageMemento.getInteger(MEMENTO_KEY_LAST_ACTIVATION)) != null && lastActivation > bestActivation) {
                    bestActivation = lastActivation;
                    restorePageMemento = pageMemento;
                }
                ++i;
            }
            if (restorePageMemento != null) {
                this.showEmptySearchPage(restorePageMemento.getID());
                String pinned = this.fPageState.getString(MEMENTO_KEY_IS_PINNED);
                if (String.valueOf(true).equals(pinned)) {
                    this.setPinned(true);
                    this.fPinSearchViewAction.update();
                }
            }
        }
    }

    private void initializeToolBar() {
        IToolBarManager tbm = this.getViewSite().getActionBars().getToolBarManager();
        SearchView.createToolBarGroups(tbm);
        tbm.appendToGroup("group.search", (IAction)this.fSearchAgainAction);
        tbm.appendToGroup("group.search", (IAction)this.fCancelAction);
        tbm.appendToGroup("group.search", (IAction)this.fSearchesDropDownAction);
        tbm.appendToGroup("group.search", (IAction)this.fPinSearchViewAction);
        this.getViewSite().getActionBars().updateActionBars();
    }

    private void createActions() {
        this.fSearchesDropDownAction = new SearchHistoryDropDownAction(this);
        this.fSearchesDropDownAction.updateEnablement();
        this.fSearchAgainAction = new SearchAgainAction(this);
        this.fSearchAgainAction.setEnabled(false);
        this.fSearchAgainAction.setActionDefinitionId("org.eclipse.ui.file.refresh");
        this.fCancelAction = new CancelSearchAction(this);
        this.fCancelAction.setEnabled(false);
        this.fPinSearchViewAction = new PinSearchViewAction(this);
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.commands.operations.IUndoContext");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IUndoContext workspaceContext = (IUndoContext)iWorkspace.getAdapter((Class)clazz);
        this.fUndoRedoActionGroup = new UndoRedoActionGroup((IWorkbenchPartSite)this.getViewSite(), workspaceContext, true);
    }

    public void dispose() {
        if (this.fUndoRedoActionGroup != null) {
            this.fUndoRedoActionGroup.dispose();
        }
        InternalSearchUI.getInstance().getSearchViewManager().searchViewClosed(this);
        InternalSearchUI.getInstance().getSearchManager().removeQueryListener(this);
        super.dispose();
    }

    public void queryStarting(ISearchQuery query) {
        if (this.fCurrentSearch != null && this.fCurrentSearch.equals(query.getSearchResult())) {
            this.updateCancelAction();
        }
    }

    public void queryFinished(ISearchQuery query) {
        if (this.fCurrentSearch != null && this.fCurrentSearch.equals(query.getSearchResult())) {
            this.updateCancelAction();
        }
    }

    private void updateCancelAction() {
        ISearchResult result = this.getCurrentSearchResult();
        boolean queryRunning = false;
        if (result != null) {
            queryRunning = InternalSearchUI.getInstance().isQueryRunning(result.getQuery());
        }
        this.fCancelAction.setEnabled(queryRunning);
        this.fSearchAgainAction.setEnabled(!queryRunning && result != null && result.getQuery().canRerun());
    }

    public void queryAdded(ISearchQuery query) {
        this.fSearchesDropDownAction.updateEnablement();
    }

    public void queryRemoved(ISearchQuery query) {
        InternalSearchUI.getInstance().cancelSearch(query);
        if (query.getSearchResult().equals(this.fCurrentSearch)) {
            this.showSearchResult(null);
            this.partActivated(this.fDefaultPart);
        }
        this.fSearchViewStates.remove(query.getSearchResult());
        this.fSearchesDropDownAction.disposeMenu();
        this.fSearchesDropDownAction.updateEnablement();
    }

    public void fillContextMenu(IMenuManager menuManager) {
        ISearchResult result = this.getCurrentSearchResult();
        if (result != null) {
            ISelection sel;
            ShowInContext context;
            IShowInSource showInSource;
            menuManager.appendToGroup("group.search", (IAction)this.fSearchAgainAction);
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.ui.part.IShowInSource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((showInSource = (IShowInSource)this.getAdapter(clazz)) != null && (context = showInSource.getShowInContext()) != null && (sel = context.getSelection()) != null && !sel.isEmpty()) {
                MenuManager showInSubMenu = new MenuManager(this.getShowInMenuLabel());
                showInSubMenu.add(ContributionItemFactory.VIEWS_SHOW_IN.create(this.getViewSite().getWorkbenchWindow()));
                menuManager.appendToGroup("group.open", (IContributionItem)showInSubMenu);
            }
        }
    }

    private String getShowInMenuLabel() {
        IBindingService bindingService;
        String keyBinding = null;
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.ui.keys.IBindingService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((bindingService = (IBindingService)iWorkbench.getAdapter((Class)clazz)) != null) {
            keyBinding = bindingService.getBestActiveBindingFormattedFor("org.eclipse.ui.navigate.showInQuickMenu");
        }
        if (keyBinding == null) {
            keyBinding = "";
        }
        return NLS.bind((String)SearchMessages.SearchView_showIn_menu, (Object)keyBinding);
    }

    public void saveState(IMemento memento) {
        Iterator iter = this.fPagesToParts.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            ISearchResultPage page = (ISearchResultPage)entry.getKey();
            DummyPart part = (DummyPart)entry.getValue();
            IMemento child = memento.createChild(MEMENTO_TYPE, page.getID());
            page.saveState(child);
            child.putInteger(MEMENTO_KEY_LAST_ACTIVATION, part.getLastActivation());
        }
        memento.putString(MEMENTO_KEY_IS_PINNED, String.valueOf(this.isPinned()));
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        IMenuManager menuManager = site.getActionBars().getMenuManager();
        SearchView.createViewMenuGroups(menuManager);
        this.fPageState = memento;
    }

    protected void initPage(IPageBookViewPage page) {
        super.initPage(page);
        IActionBars actionBars = page.getSite().getActionBars();
        actionBars.setGlobalActionHandler(ActionFactory.REFRESH.getId(), (IAction)this.fSearchAgainAction);
        actionBars.updateActionBars();
        this.fUndoRedoActionGroup.fillActionBars(actionBars);
        ISearchResultPage srPage = (ISearchResultPage)page;
        IMemento memento = null;
        if (this.fPageState != null) {
            IMemento[] mementos = this.fPageState.getChildren(MEMENTO_TYPE);
            int i = 0;
            while (i < mementos.length) {
                if (mementos[i].getID().equals(srPage.getID())) {
                    memento = mementos[i];
                    break;
                }
                ++i;
            }
        }
        srPage.restoreState(memento);
    }

    private void showLatestSearch() {
        ISearchQuery[] queries = InternalSearchUI.getInstance().getSearchManager().getQueries();
        if (queries.length > 0) {
            this.showSearchResult(queries[0].getSearchResult());
        }
    }

    public void setFocus() {
        IPage currentPage = this.getCurrentPage();
        if (currentPage != null) {
            currentPage.setFocus();
        } else {
            super.setFocus();
        }
    }

    public ISearchResultPage getActivePage() {
        IPage page = this.getCurrentPage();
        if (page instanceof ISearchResultPage) {
            return (ISearchResultPage)page;
        }
        return null;
    }

    public IWorkbenchSiteProgressService getProgressService() {
        Object siteService;
        IWorkbenchSiteProgressService service = null;
        IWorkbenchPartSite iWorkbenchPartSite = this.getSite();
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.ui.progress.IWorkbenchSiteProgressService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((siteService = iWorkbenchPartSite.getAdapter((Class)clazz)) != null) {
            service = (IWorkbenchSiteProgressService)siteService;
        }
        return service;
    }

    public void showBusy(boolean busy) {
        super.showBusy(busy);
        if (!busy) {
            this.getProgressService().warnOfContentChange();
        }
    }

    public Object getAdapter(Class adapter) {
        Object superAdapter = super.getAdapter(adapter);
        if (superAdapter != null) {
            return superAdapter;
        }
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ui.part.IShowInSource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            return new IShowInSource(){

                public ShowInContext getShowInContext() {
                    return new ShowInContext(null, SearchView.this.getSelectionProvider().getSelection());
                }
            };
        }
        return null;
    }

    public void setPinned(boolean pinned) {
        this.fIsPinned = pinned;
    }

    public boolean isPinned() {
        return this.fIsPinned;
    }

    public void updatePartName() {
    }

    static class DummyPart
    implements IWorkbenchPart {
        private int fLastActivation = 0;

        DummyPart() {
        }

        public void setLastActivation(int lastActivation) {
            this.fLastActivation = lastActivation;
        }

        public int getLastActivation() {
            return this.fLastActivation;
        }

        public void addPropertyListener(IPropertyListener listener) {
        }

        public void createPartControl(Composite parent) {
        }

        public void dispose() {
        }

        public IWorkbenchPartSite getSite() {
            return null;
        }

        public String getTitle() {
            return null;
        }

        public Image getTitleImage() {
            return null;
        }

        public String getTitleToolTip() {
            return null;
        }

        public void removePropertyListener(IPropertyListener listener) {
        }

        public void setFocus() {
        }

        public Object getAdapter(Class adapter) {
            return null;
        }
    }

    static class EmptySearchView
    extends Page
    implements ISearchResultPage {
        private Composite fControl;
        private String fId;

        EmptySearchView() {
        }

        public void createControl(Composite parent) {
            Color background = parent.getDisplay().getSystemColor(25);
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout(1, false));
            composite.setBackground(background);
            Link link = new Link(composite, 0);
            link.setText(SearchMessages.SearchView_empty_search_label);
            link.setLayoutData((Object)new GridData(1, 0x1000000, true, false));
            link.setBackground(background);
            link.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ EmptySearchView this$1;
                {
                    this.this$1 = emptySearchView;
                }

                public void widgetSelected(SelectionEvent e) {
                    new OpenSearchDialogAction().run();
                }
            });
            this.fControl = composite;
        }

        public Control getControl() {
            return this.fControl;
        }

        public void setFocus() {
            if (this.fControl != null) {
                this.fControl.setFocus();
            }
        }

        public void setInput(ISearchResult search, Object viewState) {
        }

        public void setViewPart(ISearchResultViewPart part) {
        }

        public Object getUIState() {
            return null;
        }

        public void init(IPageSite pageSite) {
            super.init(pageSite);
            this.getSite().setSelectionProvider(null);
            IMenuManager menuManager = pageSite.getActionBars().getMenuManager();
            menuManager.appendToGroup("group.properties", (IAction)new OpenSearchPreferencesAction());
        }

        public void saveState(IMemento memento) {
        }

        public void restoreState(IMemento memento) {
        }

        public void setID(String id) {
            this.fId = id;
        }

        public String getID() {
            return this.fId;
        }

        public String getLabel() {
            return "";
        }
    }
}

