/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.resources.api;

import de.rcenvironment.core.component.model.api.ComponentInterface;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public final class ComponentImageManager {
    private static final String SETTING_COMPONENT_ICON_FAILED = "Setting component icon failed.";
    private static ComponentImageManager instance;
    private Map<String, ImageContainer> iconImageMap = new HashMap<String, ImageContainer>();

    private ComponentImageManager() {
    }

    public static ComponentImageManager getInstance() {
        if (instance == null) {
            instance = new ComponentImageManager();
        }
        return instance;
    }

    public Image getIcon16Image(ComponentInterface ci) {
        return this.returnImageContainer(ci).icon16;
    }

    public Image getIcon24Image(ComponentInterface ci) {
        return this.returnImageContainer(ci).icon24;
    }

    public Image getIcon32Image(ComponentInterface ci) {
        return this.returnImageContainer(ci).icon32;
    }

    private ImageContainer returnImageContainer(ComponentInterface ci) {
        if (!this.iconImageMap.containsKey(ci.getIconHash())) {
            ImageContainer tmpContainer = new ImageContainer();
            if (ci.getIcon16() != null) {
                try {
                    tmpContainer.icon16 = new Image((Device)Display.getCurrent(), (InputStream)new ByteArrayInputStream(ci.getIcon16()));
                }
                catch (SWTException e) {
                    LogFactory.getLog(this.getClass()).debug((Object)SETTING_COMPONENT_ICON_FAILED, (Throwable)e);
                }
            }
            if (ci.getIcon24() != null) {
                try {
                    tmpContainer.icon24 = new Image((Device)Display.getCurrent(), (InputStream)new ByteArrayInputStream(ci.getIcon24()));
                }
                catch (SWTException e) {
                    LogFactory.getLog(this.getClass()).debug((Object)SETTING_COMPONENT_ICON_FAILED, (Throwable)e);
                }
            }
            if (ci.getIcon32() != null) {
                try {
                    tmpContainer.icon32 = new Image((Device)Display.getCurrent(), (InputStream)new ByteArrayInputStream(ci.getIcon32()));
                }
                catch (SWTException e) {
                    LogFactory.getLog(this.getClass()).debug((Object)SETTING_COMPONENT_ICON_FAILED, (Throwable)e);
                }
            }
            this.iconImageMap.put(ci.getIconHash(), tmpContainer);
        }
        return this.iconImageMap.get(ci.getIconHash());
    }

    private class ImageContainer {
        private Image icon16 = null;
        private Image icon24 = null;
        private Image icon32 = null;

        private ImageContainer() {
        }
    }
}

