/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.workflow.model.api;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.rcenvironment.core.communication.api.PlatformService;
import de.rcenvironment.core.communication.common.IdentifierException;
import de.rcenvironment.core.communication.common.LogicalNodeId;
import de.rcenvironment.core.communication.common.NodeIdentifierUtils;
import de.rcenvironment.core.component.api.ComponentUtils;
import de.rcenvironment.core.component.api.DistributedComponentKnowledge;
import de.rcenvironment.core.component.api.DistributedComponentKnowledgeService;
import de.rcenvironment.core.component.model.api.ComponentDescription;
import de.rcenvironment.core.component.model.api.ComponentDescriptionFactoryService;
import de.rcenvironment.core.component.model.api.ComponentInstallation;
import de.rcenvironment.core.component.model.api.ComponentInterface;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescriptionsManager;
import de.rcenvironment.core.component.model.endpoint.api.EndpointGroupDescription;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowFileException;
import de.rcenvironment.core.component.workflow.model.api.Connection;
import de.rcenvironment.core.component.workflow.model.api.Location;
import de.rcenvironment.core.component.workflow.model.api.WorkflowDescription;
import de.rcenvironment.core.component.workflow.model.api.WorkflowLabel;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.utils.common.JsonUtils;
import de.rcenvironment.core.utils.common.ServiceUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WorkflowDescriptionPersistenceHandler {
    public static final String COORDINATES = "coordinates";
    public static final String COLOR_RGB_HEADER = "colorHeader";
    public static final String COLOR_RGB_TEXT = "colorText";
    public static final String COLOR_RGB_BACKGROUND = "colorBackground";
    public static final String LABEL_POSITION = "labelPosition";
    public static final String LABEL_POSITION_OLD = "alignmentType";
    public static final String TEXT_ALIGNMENT = "textAlignmentType";
    public static final String HEADER_ALIGNMENT = "headerAlignmentType";
    public static final String ALPHA = "alpha";
    public static final String BORDER = "border";
    public static final String HEADER_SIZE = "headerSize";
    public static final String TEXT_SIZE = "textSize";
    public static final String LABELS = "labels";
    public static final String SIZE = "size";
    public static final String HEADER_TEXT = "headerText";
    public static final String TEXT = "text";
    public static final String Z_INDEX = "zIndex";
    public static final String BENDPOINTS = "bendpoints";
    public static final String INPUT = "input";
    public static final String TARGET = "target";
    public static final String OUTPUT = "output";
    public static final String SOURCE = "source";
    public static final String CONNECTIONS = "connections";
    public static final String CONFIGURATION = "configuration";
    public static final String CONFIGURATIONS = "configurations";
    public static final String CURRENT_CONFIGURATION_IDENTIFIER = "currentConfigurationIdentifier";
    public static final String CONFIGURATION_MAP = "map";
    public static final String STATIC_INPUTS = "staticInputs";
    public static final String DYNAMIC_INPUTS = "dynamicInputs";
    public static final String STATIC_OUTPUTS = "staticOutputs";
    public static final String DYNAMIC_OUTPUTS = "dynamicOutputs";
    public static final String DYNAMIC_INPUT_GROUPS = "dynamicInputGroups";
    public static final String OUTPUT_META_DATA = "outputMetaData";
    public static final String INPUT_META_DATA = "inputMetaData";
    public static final String VERSION = "version";
    public static final String COMPONENT = "component";
    public static final String LOCATION = "location";
    public static final String ACTIVE = "active";
    public static final String NODES = "nodes";
    public static final String PLATFORM = "platform";
    public static final String NAME = "name";
    public static final String METADATA = "metadata";
    public static final String DATATYPE = "datatype";
    public static final String IDENTIFIER = "identifier";
    public static final String GROUP = "group";
    public static final String EP_IDENTIFIER = "epIdentifier";
    public static final String WORKFLOW_VERSION = "workflowVersion";
    public static final String ADDITIONAL_INFORMATION = "additionalInformation";
    public static final String BENDPOINT_SEPARATOR = ",";
    public static final String BENDPOINT_COORDINATE_SEPARATOR = ":";
    protected static PlatformService platformService = (PlatformService)ServiceUtils.createFailingServiceProxy(PlatformService.class);
    protected static DistributedComponentKnowledgeService componentKnowledgeService = (DistributedComponentKnowledgeService)ServiceUtils.createFailingServiceProxy(DistributedComponentKnowledgeService.class);
    protected static ComponentDescriptionFactoryService componentDescriptionFactoryService = (ComponentDescriptionFactoryService)ServiceUtils.createFailingServiceProxy(ComponentDescriptionFactoryService.class);
    private static final String STANDARD_STREAM_ENCODING = StandardCharsets.UTF_8.name();
    private static final JsonEncoding STANDARD_JSON_ENCODING = JsonEncoding.UTF8;
    private static final String ERROR_WHEN_PARSING_WORKFLOW_FILE = "Error when parsing workflow file: ";
    private static final Log LOG = LogFactory.getLog(WorkflowDescriptionPersistenceHandler.class);
    private static final String SEPARATOR = "/";
    private static final ObjectMapper JSON_OBJECT_MAPPER = JsonUtils.getDefaultObjectMapper();
    private static final Random RANDOM = new Random();
    private final Map<String, Map<String, EndpointDescription>> endpointDescs = new HashMap<String, Map<String, EndpointDescription>>();

    protected void bindDistributedComponentKnowledgeService(DistributedComponentKnowledgeService newService) {
        componentKnowledgeService = newService;
    }

    protected void unbindDistributedComponentKnowledgeService(DistributedComponentKnowledgeService oldService) {
        componentKnowledgeService = (DistributedComponentKnowledgeService)ServiceUtils.createFailingServiceProxy(DistributedComponentKnowledgeService.class);
    }

    protected void bindComponentDescriptionFactoryService(ComponentDescriptionFactoryService newService) {
        componentDescriptionFactoryService = newService;
    }

    protected void unbindComponentDescriptionFactoryService(ComponentDescriptionFactoryService oldService) {
        componentDescriptionFactoryService = (ComponentDescriptionFactoryService)ServiceUtils.createFailingServiceProxy(ComponentDescriptionFactoryService.class);
    }

    protected void bindPlatformService(PlatformService newPlatformService) {
        platformService = newPlatformService;
    }

    protected void unbindPlatformService(PlatformService oldPlatformService) {
        platformService = (PlatformService)ServiceUtils.createFailingServiceProxy(PlatformService.class);
    }

    public ByteArrayOutputStream writeWorkflowDescriptionToStream(WorkflowDescription wd) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        JsonFactory f = new JsonFactory();
        JsonGenerator g = f.createGenerator((OutputStream)outputStream, STANDARD_JSON_ENCODING);
        g.setPrettyPrinter((PrettyPrinter)new DefaultPrettyPrinter());
        g.writeStartObject();
        g.writeStringField(IDENTIFIER, wd.getIdentifier());
        g.writeStringField(WORKFLOW_VERSION, String.valueOf(wd.getWorkflowVersion()));
        this.writeOptionalValue(g, NAME, wd.getName());
        if (wd.getControllerNode() != null && !wd.getControllerNode().equals(platformService.getLocalDefaultLogicalNodeId()) && !wd.getIsControllerNodeIdTransient()) {
            this.writeOptionalValue(g, PLATFORM, wd.getControllerNode().getLogicalNodeIdString());
        }
        this.writeOptionalValue(g, ADDITIONAL_INFORMATION, wd.getAdditionalInformation());
        if (wd.getWorkflowNodes().size() > 0) {
            g.writeArrayFieldStart(NODES);
            List<WorkflowNode> nodes = wd.getWorkflowNodes();
            Collections.sort(nodes);
            for (WorkflowNode node : nodes) {
                this.writeWorkflowNode(g, node);
            }
            g.writeEndArray();
        }
        if (wd.getConnections().size() > 0) {
            g.writeArrayFieldStart(CONNECTIONS);
            List<Connection> connections = wd.getConnections();
            Collections.sort(connections);
            for (Connection connection : connections) {
                this.writeConnection(g, connection);
            }
            g.writeEndArray();
            Map<String, String> connectionBendpointMapping = this.calculateUniqueBendpointList(wd.getConnections());
            if (!connectionBendpointMapping.isEmpty()) {
                ByteArrayOutputStream bendpointsStream = new ByteArrayOutputStream();
                JsonGenerator bendpointsGenerator = f.createGenerator((OutputStream)bendpointsStream, STANDARD_JSON_ENCODING);
                bendpointsGenerator.writeStartArray();
                this.writeBendpoints(bendpointsGenerator, connectionBendpointMapping);
                bendpointsGenerator.writeEndArray();
                bendpointsGenerator.close();
                g.writeStringField(BENDPOINTS, bendpointsStream.toString(STANDARD_STREAM_ENCODING));
            }
        }
        if (wd.getWorkflowLabels().size() > 0) {
            ByteArrayOutputStream labelsStream = new ByteArrayOutputStream();
            JsonGenerator labelsGenerator = f.createGenerator((OutputStream)labelsStream, STANDARD_JSON_ENCODING);
            labelsGenerator.writeStartArray();
            List<WorkflowLabel> workflowLabels = wd.getWorkflowLabels();
            Collections.sort(workflowLabels);
            for (WorkflowLabel label : workflowLabels) {
                this.writeLabel(labelsGenerator, label);
            }
            labelsGenerator.writeEndArray();
            labelsGenerator.close();
            g.writeStringField(LABELS, labelsStream.toString(STANDARD_STREAM_ENCODING));
        }
        g.writeEndObject();
        g.close();
        return outputStream;
    }

    public void writeLabel(JsonGenerator g, WorkflowLabel label) throws IOException, JsonGenerationException {
        g.writeStartObject();
        g.writeStringField(IDENTIFIER, label.getIdentifier());
        g.writeStringField(HEADER_TEXT, label.getHeaderText());
        g.writeStringField(TEXT, label.getText());
        g.writeStringField(LOCATION, StringUtils.escapeAndConcat((String[])new String[]{String.valueOf(label.getX()), String.valueOf(label.getY())}));
        g.writeStringField(SIZE, StringUtils.escapeAndConcat((String[])new String[]{String.valueOf(label.getWidth()), String.valueOf(label.getHeight())}));
        g.writeStringField(ALPHA, String.valueOf(label.getAlphaDisplay()));
        g.writeStringField(COLOR_RGB_HEADER, StringUtils.escapeAndConcat((String[])new String[]{String.valueOf(label.getColorHeader()[0]), String.valueOf(label.getColorHeader()[1]), String.valueOf(label.getColorHeader()[2])}));
        g.writeStringField(COLOR_RGB_TEXT, StringUtils.escapeAndConcat((String[])new String[]{String.valueOf(label.getColorText()[0]), String.valueOf(label.getColorText()[1]), String.valueOf(label.getColorText()[2])}));
        g.writeStringField(COLOR_RGB_BACKGROUND, StringUtils.escapeAndConcat((String[])new String[]{String.valueOf(label.getColorBackground()[0]), String.valueOf(label.getColorBackground()[1]), String.valueOf(label.getColorBackground()[2])}));
        g.writeStringField(LABEL_POSITION, label.getLabelPosition().name());
        g.writeStringField(TEXT_ALIGNMENT, label.getTextAlignmentType().name());
        g.writeStringField(HEADER_ALIGNMENT, label.getHeaderAlignmentType().name());
        g.writeStringField(BORDER, String.valueOf(label.hasBorder()));
        g.writeStringField(HEADER_SIZE, String.valueOf(label.getHeaderTextSize()));
        g.writeStringField(TEXT_SIZE, String.valueOf(label.getTextSize()));
        g.writeStringField(Z_INDEX, String.valueOf(label.getZIndex()));
        g.writeEndObject();
    }

    public void writeConnection(JsonGenerator g, Connection connection) throws IOException, JsonGenerationException {
        g.writeStartObject();
        g.writeStringField(SOURCE, connection.getSourceNode().getIdentifier());
        g.writeStringField(OUTPUT, connection.getOutput().getIdentifier());
        g.writeStringField(TARGET, connection.getTargetNode().getIdentifier());
        g.writeStringField(INPUT, connection.getInput().getIdentifier());
        g.writeEndObject();
    }

    public void writeWorkflowNode(JsonGenerator g, WorkflowNode node) throws IOException, JsonGenerationException {
        g.writeStartObject();
        g.writeStringField(IDENTIFIER, node.getIdentifier());
        g.writeStringField(NAME, node.getName());
        g.writeStringField(LOCATION, StringUtils.escapeAndConcat((String[])new String[]{String.valueOf(node.getX()), String.valueOf(node.getY())}));
        g.writeStringField(Z_INDEX, String.valueOf(node.getZIndex()));
        g.writeStringField(ACTIVE, Boolean.toString(node.isEnabled()));
        ComponentDescription cd = node.getComponentDescription();
        LogicalNodeId nodeId = cd.getNode();
        if (nodeId != null && !nodeId.equals(platformService.getLocalDefaultLogicalNodeId()) && !cd.getIsNodeIdTransient()) {
            g.writeStringField(PLATFORM, nodeId.getLogicalNodeIdString());
        }
        g.writeObjectFieldStart(COMPONENT);
        String identifier = cd.getIdentifier();
        if (identifier.startsWith("20ca0171b5e24e10a284af7c1d6d94e9missing_")) {
            identifier = identifier.substring("20ca0171b5e24e10a284af7c1d6d94e9missing_".length());
        }
        g.writeStringField(IDENTIFIER, identifier.split(SEPARATOR)[0]);
        this.writeOptionalValue(g, VERSION, cd.getVersion());
        g.writeStringField(NAME, cd.getName());
        g.writeEndObject();
        this.writeConfiguation(g, node);
        this.writeEndpointDescriptions(g, cd.getInputDescriptionsManager().getStaticEndpointDescriptions(), STATIC_INPUTS);
        this.writeEndpointDescriptions(g, cd.getInputDescriptionsManager().getDynamicEndpointDescriptions(), DYNAMIC_INPUTS);
        this.writeEndpointDescriptions(g, cd.getOutputDescriptionsManager().getStaticEndpointDescriptions(), STATIC_OUTPUTS);
        this.writeEndpointDescriptions(g, cd.getOutputDescriptionsManager().getDynamicEndpointDescriptions(), DYNAMIC_OUTPUTS);
        this.writeEndpointGroupDescriptions(g, cd.getInputDescriptionsManager().getDynamicEndpointGroupDescriptions(), DYNAMIC_INPUT_GROUPS);
        g.writeEndObject();
    }

    private void writeEndpointDescriptions(JsonGenerator g, Set<EndpointDescription> endpoints, String nodeName) throws JsonGenerationException, IOException {
        if (endpoints.size() > 0) {
            g.writeArrayFieldStart(nodeName);
            ArrayList<EndpointDescription> sortedEndpoints = new ArrayList<EndpointDescription>(endpoints);
            Collections.sort(sortedEndpoints);
            for (EndpointDescription desc : sortedEndpoints) {
                g.writeStartObject();
                g.writeStringField(IDENTIFIER, desc.getIdentifier());
                g.writeStringField(NAME, desc.getName());
                if (desc.getDynamicEndpointIdentifier() != null) {
                    g.writeStringField(EP_IDENTIFIER, desc.getDynamicEndpointIdentifier());
                }
                if (desc.getParentGroupName() != null) {
                    g.writeStringField(GROUP, desc.getParentGroupName());
                }
                g.writeStringField(DATATYPE, desc.getDataType().name());
                Map metaData = desc.getMetaData();
                if (metaData.size() > 0) {
                    g.writeObjectFieldStart(METADATA);
                    TreeMap sortedMetaData = new TreeMap(metaData);
                    for (String key : sortedMetaData.keySet()) {
                        g.writeStringField(key, (String)sortedMetaData.get(key));
                    }
                    g.writeEndObject();
                }
                g.writeEndObject();
            }
            g.writeEndArray();
        }
    }

    private void writeEndpointGroupDescriptions(JsonGenerator g, Set<EndpointGroupDescription> endpointGroups, String nodeName) throws JsonGenerationException, IOException {
        if (endpointGroups.size() > 0) {
            g.writeArrayFieldStart(nodeName);
            for (EndpointGroupDescription desc : endpointGroups) {
                g.writeStartObject();
                g.writeStringField(NAME, desc.getName());
                g.writeStringField(EP_IDENTIFIER, desc.getDynamicEndpointIdentifier());
                g.writeEndObject();
            }
            g.writeEndArray();
        }
    }

    private void writeConfiguation(JsonGenerator g, WorkflowNode node) throws IOException {
        Map configuration = node.getComponentDescription().getConfigurationDescription().getConfiguration();
        if (configuration.size() > 0) {
            g.writeObjectFieldStart(CONFIGURATION);
            this.writeConfigurationValues(g, configuration);
            g.writeEndObject();
        }
    }

    private void writeConfigurationValues(JsonGenerator g, Map<String, String> configuration) throws IOException {
        TreeMap<String, String> sortedConfiguration = new TreeMap<String, String>(configuration);
        for (String key : sortedConfiguration.keySet()) {
            String value = (String)sortedConfiguration.get(key);
            if (value == null) continue;
            g.writeStringField(key, value);
        }
    }

    private void writeOptionalValue(JsonGenerator g, String fieldname, String value) throws IOException {
        if (value != null) {
            g.writeStringField(fieldname, value);
        }
    }

    public void writeBendpoints(JsonGenerator g, Map<String, String> connectionBendpointMapping) throws JsonGenerationException, IOException {
        for (String key : connectionBendpointMapping.keySet()) {
            g.writeStartObject();
            g.writeStringField(SOURCE, key.split(BENDPOINT_COORDINATE_SEPARATOR)[0]);
            g.writeStringField(TARGET, key.split(BENDPOINT_COORDINATE_SEPARATOR)[1]);
            g.writeStringField(COORDINATES, connectionBendpointMapping.get(key));
            g.writeEndObject();
        }
    }

    public synchronized WorkflowDescription readWorkflowDescriptionFromStream(InputStream inputStream) throws IOException, WorkflowFileException {
        ParsingFailedFlagHolder parsingFailedFlag = new ParsingFailedFlagHolder();
        WorkflowDescription wd = this.parseWorkflow(inputStream, parsingFailedFlag);
        if (parsingFailedFlag.parsingFailed) {
            throw new WorkflowFileException("Failed to read (parts of) the workflow", wd);
        }
        return wd;
    }

    private ObjectNode workflowFileStreamToJsonNode(InputStream inputStream) throws IOException {
        return (ObjectNode)JSON_OBJECT_MAPPER.readTree(IOUtils.toString((InputStream)inputStream, (String)STANDARD_STREAM_ENCODING));
    }

    private void handleParseFailure(ParsingFailedFlagHolder parsingFailedFlag, String logMessage) {
        LOG.error((Object)(ERROR_WHEN_PARSING_WORKFLOW_FILE + logMessage));
        parsingFailedFlag.parsingFailed = true;
    }

    private void handleParsingExceptions(Exception e, String message, JsonNode jsonNode, ParsingFailedFlagHolder parsingFailedFlag) {
        String logMessage = message;
        if (e != null) {
            logMessage = String.valueOf(logMessage) + "; cause: " + e.toString();
        }
        this.handleParseFailure(parsingFailedFlag, String.valueOf(logMessage) + "; JSON data: " + jsonNode.toString());
    }

    private WorkflowDescription parseWorkflow(InputStream inputStream, ParsingFailedFlagHolder parsingFailedFlag) throws IOException, WorkflowFileException {
        ObjectNode wfRootJsonNode = this.workflowFileStreamToJsonNode(inputStream);
        if (!wfRootJsonNode.has(IDENTIFIER)) {
            throw new WorkflowFileException("Workflow identifier not found: " + wfRootJsonNode.toString());
        }
        WorkflowDescription wd = new WorkflowDescription(wfRootJsonNode.get(IDENTIFIER).asText());
        wd.setWorkflowVersion(0);
        wd.setWorkflowVersion(this.readWorkflowVersionNumber(wfRootJsonNode));
        if (wfRootJsonNode.has(NAME)) {
            wd.setName(wfRootJsonNode.get(NAME).asText());
        }
        if (wfRootJsonNode.has(ADDITIONAL_INFORMATION)) {
            wd.setAdditionalInformation(wfRootJsonNode.get(ADDITIONAL_INFORMATION).asText());
        }
        String wfControllerNodeId = this.readWorkflowControllerNodeId(wfRootJsonNode);
        wd.setControllerNode(NodeIdentifierUtils.parseArbitraryIdStringToLogicalNodeIdWithExceptionWrapping((String)wfControllerNodeId));
        Map<String, WorkflowNode> nodes = null;
        if (wfRootJsonNode.has(NODES) && wfRootJsonNode.get(NODES) instanceof ArrayNode) {
            nodes = this.parseNodesEntry((ArrayNode)wfRootJsonNode.get(NODES), wd, parsingFailedFlag);
        }
        List<Connection> connections = null;
        if (wfRootJsonNode.has(CONNECTIONS) && wfRootJsonNode.get(CONNECTIONS) instanceof ArrayNode) {
            connections = this.parseConnectionsEntry((ArrayNode)wfRootJsonNode.get(CONNECTIONS), nodes, wd, parsingFailedFlag);
        }
        if (wfRootJsonNode.has(BENDPOINTS)) {
            this.parseBendpointsEntry(wfRootJsonNode.get(BENDPOINTS), nodes, connections, parsingFailedFlag);
        }
        if (wfRootJsonNode.has(LABELS)) {
            this.parseLabelsEntry(wfRootJsonNode.get(LABELS), wd, parsingFailedFlag);
        }
        return wd;
    }

    public int readWorkflowVersionNumber(InputStream inputStream) throws IOException {
        return this.readWorkflowVersionNumber(this.workflowFileStreamToJsonNode(inputStream));
    }

    private int readWorkflowVersionNumber(ObjectNode wfRootJsonNode) throws IOException {
        int workflowVersion = 0;
        if (wfRootJsonNode.has(WORKFLOW_VERSION)) {
            workflowVersion = wfRootJsonNode.get(WORKFLOW_VERSION).asInt();
        }
        return workflowVersion;
    }

    public String readWorkflowControllerNodeId(InputStream inputStream) throws IOException {
        return this.readWorkflowControllerNodeId(this.workflowFileStreamToJsonNode(inputStream));
    }

    private String readWorkflowControllerNodeId(ObjectNode wfRootJsonNode) throws IOException {
        String controllerNode = wfRootJsonNode.has(PLATFORM) ? wfRootJsonNode.get(PLATFORM).asText() : platformService.getLocalDefaultLogicalNodeId().getLogicalNodeIdString();
        return controllerNode;
    }

    public Map<String, String> readComponentControllerNodeIds(InputStream inputStream) throws IOException {
        HashMap<String, String> componentControllerNodes = new HashMap<String, String>();
        ArrayNode workflowNodesArrayNode = (ArrayNode)this.workflowFileStreamToJsonNode(inputStream).get(NODES);
        if (workflowNodesArrayNode != null) {
            for (ObjectNode workflowNodeJsonNode : workflowNodesArrayNode) {
                JsonNode identifierJsonNode = workflowNodeJsonNode.get(IDENTIFIER);
                JsonNode controllerJsonNode = workflowNodeJsonNode.get(PLATFORM);
                if (identifierJsonNode == null) continue;
                if (controllerJsonNode != null) {
                    componentControllerNodes.put(identifierJsonNode.asText(), controllerJsonNode.asText());
                    continue;
                }
                componentControllerNodes.put(identifierJsonNode.asText(), platformService.getLocalDefaultLogicalNodeId().getLogicalNodeIdString());
            }
        }
        return componentControllerNodes;
    }

    private Map<String, WorkflowNode> parseNodesEntry(ArrayNode nodesJsonNode, WorkflowDescription wd, ParsingFailedFlagHolder parsingFailedFlag) {
        Map<String, WorkflowNode> nodes = this.parseNodes(nodesJsonNode, parsingFailedFlag);
        wd.addWorkflowNodes(new ArrayList<WorkflowNode>(nodes.values()));
        return nodes;
    }

    public Map<String, WorkflowNode> parseNodes(ArrayNode nodesJsonNode) throws IOException {
        ParsingFailedFlagHolder parsingFailedFlag = new ParsingFailedFlagHolder();
        Map<String, WorkflowNode> nodes = this.parseNodes(nodesJsonNode, parsingFailedFlag);
        if (parsingFailedFlag.parsingFailed) {
            throw new IOException("Failed to parse some of the workflow nodes");
        }
        return nodes;
    }

    private Map<String, WorkflowNode> parseNodes(ArrayNode nodesJsonNode, ParsingFailedFlagHolder parsingFailedFlag) {
        HashMap<String, WorkflowNode> nodes = new HashMap<String, WorkflowNode>();
        Iterator nodeJsonNodeIterator = nodesJsonNode.elements();
        while (nodeJsonNodeIterator.hasNext()) {
            ObjectNode nodeJsonNode = (ObjectNode)nodeJsonNodeIterator.next();
            try {
                WorkflowNode node = this.parseNode(nodeJsonNode, parsingFailedFlag);
                nodes.put(node.getIdentifier(), node);
            }
            catch (WorkflowFileException | RuntimeException e) {
                this.handleParsingExceptions(e, "Failed to parse a workflow node, skipping it", (JsonNode)nodeJsonNode, parsingFailedFlag);
            }
        }
        return nodes;
    }

    private WorkflowNode parseNode(ObjectNode nodeJsonNode, ParsingFailedFlagHolder parsingFailedFlag) throws WorkflowFileException {
        EndpointDescription d;
        Iterator<EndpointDescription> iterator;
        EndpointDescriptionsManager manager;
        LogicalNodeId requestedNodeId = platformService.getLocalDefaultLogicalNodeId();
        if (nodeJsonNode.has(PLATFORM)) {
            try {
                String explicitNodeIdSetting = nodeJsonNode.get(PLATFORM).asText();
                requestedNodeId = NodeIdentifierUtils.parseArbitraryIdStringToLogicalNodeId((String)explicitNodeIdSetting);
            }
            catch (IdentifierException e) {
                throw new WorkflowFileException("Invalid location id: " + e.toString());
            }
        }
        if (!nodeJsonNode.has(COMPONENT)) {
            throw new WorkflowFileException("Component declaration not found");
        }
        ComponentDescription cd = this.parseComponentDescription((ObjectNode)nodeJsonNode.get(COMPONENT), requestedNodeId);
        WorkflowNode node = new WorkflowNode(cd);
        if (!nodeJsonNode.has(IDENTIFIER)) {
            throw new WorkflowFileException("Identifier not found");
        }
        node.setIdentifier(nodeJsonNode.get(IDENTIFIER).asText());
        if (!nodeJsonNode.has(NAME)) {
            throw new WorkflowFileException("Name not found");
        }
        node.setName(nodeJsonNode.get(NAME).asText());
        if (nodeJsonNode.has(LOCATION)) {
            String[] location = StringUtils.splitAndUnescape((String)nodeJsonNode.get(LOCATION).asText());
            try {
                node.setLocation(Integer.parseInt(location[0]), Integer.parseInt(location[1]));
            }
            catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
                LOG.error((Object)("Error when parsing workflow file: Failed to parse location of component; use default: " + e.getMessage()));
            }
        }
        if (nodeJsonNode.has(Z_INDEX)) {
            node.setZIndex(nodeJsonNode.get(Z_INDEX).asInt());
        }
        boolean active = true;
        if (nodeJsonNode.has(ACTIVE)) {
            active = nodeJsonNode.get(ACTIVE).asBoolean();
        }
        node.setEnabled(active);
        if (nodeJsonNode.has(CONFIGURATION)) {
            node.getConfigurationDescription().setConfiguration(this.parseConfigurationValues((ObjectNode)nodeJsonNode.get(CONFIGURATION)));
        }
        HashMap<String, EndpointDescription> wfNodeEndpointDescs = new HashMap<String, EndpointDescription>();
        if (nodeJsonNode.has(STATIC_INPUTS)) {
            manager = node.getComponentDescription().getInputDescriptionsManager();
            iterator = this.parseEndpointDescriptions(wfNodeEndpointDescs, (ArrayNode)nodeJsonNode.get(STATIC_INPUTS), manager, true).iterator();
            while (iterator.hasNext()) {
                EndpointDescription endpointDescription;
                d = endpointDescription = iterator.next();
                if (node.getComponentDescription().getIdentifier().startsWith("20ca0171b5e24e10a284af7c1d6d94e9missing_")) {
                    manager.addStaticEndpointDescription(endpointDescription);
                } else {
                    d = manager.editStaticEndpointDescription(endpointDescription.getName(), endpointDescription.getDataType(), endpointDescription.getMetaData());
                }
                d.setIdentifier(endpointDescription.getIdentifier());
            }
        }
        if (nodeJsonNode.has(STATIC_OUTPUTS)) {
            manager = node.getComponentDescription().getOutputDescriptionsManager();
            iterator = this.parseEndpointDescriptions(wfNodeEndpointDescs, (ArrayNode)nodeJsonNode.get(STATIC_OUTPUTS), manager, true).iterator();
            while (iterator.hasNext()) {
                EndpointDescription endpointDescription;
                d = endpointDescription = iterator.next();
                if (node.getComponentDescription().getIdentifier().startsWith("20ca0171b5e24e10a284af7c1d6d94e9missing_")) {
                    manager.addStaticEndpointDescription(endpointDescription);
                } else {
                    d = manager.editStaticEndpointDescription(endpointDescription.getName(), endpointDescription.getDataType(), endpointDescription.getMetaData());
                }
                d.setIdentifier(endpointDescription.getIdentifier());
            }
        }
        if (nodeJsonNode.has(DYNAMIC_INPUTS)) {
            manager = node.getComponentDescription().getInputDescriptionsManager();
            for (EndpointDescription endpointDescription : this.parseEndpointDescriptions(wfNodeEndpointDescs, (ArrayNode)nodeJsonNode.get(DYNAMIC_INPUTS), manager, false)) {
                manager.addDynamicEndpointDescription(endpointDescription.getDynamicEndpointIdentifier(), endpointDescription.getName(), endpointDescription.getDataType(), endpointDescription.getMetaData(), endpointDescription.getIdentifier(), endpointDescription.getParentGroupName(), !node.getComponentDescription().getIdentifier().startsWith("20ca0171b5e24e10a284af7c1d6d94e9missing_"));
            }
        }
        if (nodeJsonNode.has(DYNAMIC_OUTPUTS)) {
            manager = node.getComponentDescription().getOutputDescriptionsManager();
            for (EndpointDescription endpointDescription : this.parseEndpointDescriptions(wfNodeEndpointDescs, (ArrayNode)nodeJsonNode.get(DYNAMIC_OUTPUTS), manager, false)) {
                manager.addDynamicEndpointDescription(endpointDescription.getDynamicEndpointIdentifier(), endpointDescription.getName(), endpointDescription.getDataType(), endpointDescription.getMetaData(), endpointDescription.getIdentifier(), null, !node.getComponentDescription().getIdentifier().startsWith("20ca0171b5e24e10a284af7c1d6d94e9missing_"));
            }
        }
        if (nodeJsonNode.has(DYNAMIC_INPUT_GROUPS)) {
            manager = node.getComponentDescription().getInputDescriptionsManager();
            for (EndpointGroupDescription endpointGroupDescription : this.parseEndpointGroupDescriptions((ArrayNode)nodeJsonNode.get(DYNAMIC_INPUT_GROUPS), manager)) {
                manager.addDynamicEndpointGroupDescription(endpointGroupDescription.getDynamicEndpointIdentifier(), endpointGroupDescription.getName(), !node.getComponentDescription().getIdentifier().startsWith("20ca0171b5e24e10a284af7c1d6d94e9missing_"));
            }
        }
        this.endpointDescs.put(node.getIdentifier(), wfNodeEndpointDescs);
        return node;
    }

    private ComponentDescription parseComponentDescription(ObjectNode componentJsonNode, LogicalNodeId requestedNodeId) throws WorkflowFileException {
        ComponentDescription cd;
        if (!componentJsonNode.has(IDENTIFIER)) {
            throw new WorkflowFileException("No component identifier found, skipping workflow node");
        }
        String identifier = componentJsonNode.get(IDENTIFIER).asText();
        String version = "";
        if (componentJsonNode.has(VERSION)) {
            version = componentJsonNode.get(VERSION).asText();
        }
        String name = null;
        if (componentJsonNode.has(NAME)) {
            name = componentJsonNode.get(NAME).asText();
        }
        if ((cd = this.getComponentDecription(String.valueOf(identifier) + SEPARATOR + version, version, name, requestedNodeId)) == null) {
            throw new WorkflowFileException("No component registered for: " + identifier);
        }
        return cd;
    }

    private ComponentDescription getComponentDecription(String identifier, String version, String name, LogicalNodeId requestedNodeId) {
        ComponentInterface compInterface;
        DistributedComponentKnowledge compKnowledge = componentKnowledgeService.getCurrentComponentKnowledge();
        ArrayList<ComponentInstallation> matchingInstallations = new ArrayList<ComponentInstallation>();
        ComponentInstallation resultInstallation = null;
        for (ComponentInstallation installation : compKnowledge.getAllInstallations()) {
            compInterface = installation.getComponentRevision().getComponentInterface();
            if (!compInterface.getIdentifiers().contains(identifier) || !compInterface.getVersion().equals(version)) continue;
            if (installation.getNodeId() != null && installation.getNodeId().equals(requestedNodeId.getLogicalNodeIdString())) {
                resultInstallation = installation;
                break;
            }
            matchingInstallations.add(installation);
        }
        if (resultInstallation == null) {
            if (matchingInstallations.isEmpty()) {
                resultInstallation = ComponentUtils.createPlaceholderComponentInstallation((String)identifier, (String)version, (String)name, (LogicalNodeId)requestedNodeId);
                identifier = resultInstallation.getInstallationId();
            } else {
                for (ComponentInstallation inst : matchingInstallations) {
                    compInterface = inst.getComponentRevision().getComponentInterface();
                    if (!compInterface.getIdentifiers().contains(identifier) || !compInterface.getVersion().equals(version) || inst.getNodeId() == null || requestedNodeId == null || !inst.getNodeId().equals(requestedNodeId.getLogicalNodeIdString())) continue;
                    resultInstallation = inst;
                    break;
                }
                if (resultInstallation == null) {
                    String localLogicalNodeIdString = platformService.getLocalDefaultLogicalNodeId().getLogicalNodeIdString();
                    for (ComponentInstallation inst : matchingInstallations) {
                        ComponentInterface compInterface2 = inst.getComponentRevision().getComponentInterface();
                        if (!compInterface2.getIdentifiers().contains(identifier) || !compInterface2.getVersion().equals(version) || inst.getNodeId() == null || !inst.getNodeId().equals(localLogicalNodeIdString)) continue;
                        resultInstallation = inst;
                        break;
                    }
                }
                if (resultInstallation == null) {
                    resultInstallation = (ComponentInstallation)matchingInstallations.get(RANDOM.nextInt(matchingInstallations.size()));
                }
            }
        }
        return componentDescriptionFactoryService.createComponentDescription(resultInstallation);
    }

    private Set<EndpointDescription> parseEndpointDescriptions(Map<String, EndpointDescription> wfNodeEndpointDescs, ArrayNode endpointsJsonNode, EndpointDescriptionsManager endpointDescsManager, boolean isStaticEndpoint) throws WorkflowFileException {
        HashSet<EndpointDescription> endpoints = new HashSet<EndpointDescription>();
        Iterator endpointsJsonNodeIterator = endpointsJsonNode.elements();
        while (endpointsJsonNodeIterator.hasNext()) {
            EndpointDescription endpoint;
            ObjectNode endpointJsonNode = (ObjectNode)endpointsJsonNodeIterator.next();
            if (!endpointJsonNode.has(IDENTIFIER)) {
                throw new WorkflowFileException("Identifier of endpoint not found");
            }
            String identifier = endpointJsonNode.get(IDENTIFIER).asText();
            if (!endpointJsonNode.has(NAME)) {
                throw new WorkflowFileException("Name of endpoint not found");
            }
            String name = endpointJsonNode.get(NAME).asText();
            if (!endpointJsonNode.has(DATATYPE)) {
                throw new WorkflowFileException("Data type of endpoint not found");
            }
            DataType dataType = DataType.valueOf((String)endpointJsonNode.get(DATATYPE).asText());
            String dynEpIdentifier = null;
            if (endpointJsonNode.has(EP_IDENTIFIER)) {
                dynEpIdentifier = endpointJsonNode.get(EP_IDENTIFIER).asText();
            }
            String group = null;
            if (endpointJsonNode.has(GROUP)) {
                group = endpointJsonNode.get(GROUP).asText();
            }
            HashMap<String, String> metaData = new HashMap<String, String>();
            if (endpointJsonNode.has(METADATA)) {
                ObjectNode metaDataJsonNode = (ObjectNode)endpointJsonNode.get(METADATA);
                Iterator metaDataJsonNodeIterator = metaDataJsonNode.fieldNames();
                while (metaDataJsonNodeIterator.hasNext()) {
                    String key = (String)metaDataJsonNodeIterator.next();
                    metaData.put(key, metaDataJsonNode.get(key).asText());
                }
            }
            if (isStaticEndpoint) {
                endpoint = new EndpointDescription(endpointDescsManager.getStaticEndpointDefinition(name), identifier);
                if (endpointDescsManager.getStaticEndpointDefinition(name) == null) {
                    endpoint.setName(name);
                }
            } else {
                endpoint = new EndpointDescription(endpointDescsManager.getDynamicEndpointDefinition(dynEpIdentifier), identifier);
                endpoint.setName(name);
                if (dynEpIdentifier == null || dynEpIdentifier.equals("null")) {
                    endpoint.setDynamicEndpointIdentifier(null);
                } else {
                    endpoint.setDynamicEndpointIdentifier(dynEpIdentifier);
                }
            }
            endpoint.setParentGroupName(group);
            endpoint.setDataType(dataType);
            endpoint.setMetaData(metaData);
            endpoints.add(endpoint);
            wfNodeEndpointDescs.put(identifier, endpoint);
        }
        return endpoints;
    }

    private Set<EndpointGroupDescription> parseEndpointGroupDescriptions(ArrayNode endpointGroupsJsonNode, EndpointDescriptionsManager endpointDescsManager) throws WorkflowFileException {
        HashSet<EndpointGroupDescription> endpointGroups = new HashSet<EndpointGroupDescription>();
        Iterator endpointGroupsJsonNodeIterator = endpointGroupsJsonNode.elements();
        while (endpointGroupsJsonNodeIterator.hasNext()) {
            ObjectNode endpointGroupJsonNode = (ObjectNode)endpointGroupsJsonNodeIterator.next();
            if (!endpointGroupJsonNode.has(NAME)) {
                throw new WorkflowFileException("Name of endpoint group not found");
            }
            String name = endpointGroupJsonNode.get(NAME).asText();
            if (!endpointGroupJsonNode.has(EP_IDENTIFIER)) {
                throw new WorkflowFileException("Endpoint identifier of endpoint group not found");
            }
            String dynEpIdentifier = endpointGroupJsonNode.get(EP_IDENTIFIER).asText();
            EndpointDescription desc = new EndpointDescription(endpointDescsManager.getDynamicEndpointDefinition(dynEpIdentifier), endpointDescsManager.getManagedEndpointType());
            desc.setName(name);
            if (dynEpIdentifier.equals("null")) {
                desc.setDynamicEndpointIdentifier(null);
            } else {
                desc.setDynamicEndpointIdentifier(dynEpIdentifier);
            }
            endpointGroups.add((EndpointGroupDescription)desc);
        }
        return endpointGroups;
    }

    private List<Connection> parseConnectionsEntry(ArrayNode connectionsJsonNode, Map<String, WorkflowNode> nodes, WorkflowDescription wd, ParsingFailedFlagHolder parsingFailedFlag) {
        if (nodes != null) {
            List<Connection> connections = this.parseConnections(connectionsJsonNode, nodes, parsingFailedFlag);
            wd.addConnections(connections);
            return connections;
        }
        this.handleParseFailure(parsingFailedFlag, "Failed to read connections (no workflow nodes defined), skipping them");
        return null;
    }

    public synchronized List<Connection> parseConnections(ArrayNode connectionsJsonNode, Map<String, WorkflowNode> nodes) throws IOException {
        ParsingFailedFlagHolder parsingFailedFlag = new ParsingFailedFlagHolder();
        List<Connection> connections = this.parseConnections(connectionsJsonNode, nodes, parsingFailedFlag);
        if (parsingFailedFlag.parsingFailed) {
            throw new IOException("Failed to parse some of the connections");
        }
        return connections;
    }

    private List<Connection> parseConnections(ArrayNode connectionsJsonNode, Map<String, WorkflowNode> nodes, ParsingFailedFlagHolder parsingFailedFlag) {
        ArrayList<Connection> connections = new ArrayList<Connection>();
        Iterator connectionJsonNodeIterator = connectionsJsonNode.elements();
        while (connectionJsonNodeIterator.hasNext()) {
            ObjectNode connectionJsonNode = (ObjectNode)connectionJsonNodeIterator.next();
            try {
                Connection connection = this.parseConnection(connectionJsonNode, nodes, parsingFailedFlag);
                connections.add(connection);
            }
            catch (WorkflowFileException | RuntimeException e) {
                this.handleParsingExceptions(e, "Failed to parse connection, skipping it", (JsonNode)connectionJsonNode, parsingFailedFlag);
            }
        }
        return connections;
    }

    private Connection parseConnection(ObjectNode connectionJsonNode, Map<String, WorkflowNode> nodes, ParsingFailedFlagHolder parsingFailedFlag) throws WorkflowFileException {
        if (!connectionJsonNode.has(SOURCE)) {
            throw new WorkflowFileException("Source workflow node definition of connection not found");
        }
        WorkflowNode outputNode = nodes.get(connectionJsonNode.get(SOURCE).asText());
        if (outputNode == null) {
            throw new WorkflowFileException("Source workflow node of connection not found: " + connectionJsonNode.get(SOURCE).asText());
        }
        if (!connectionJsonNode.has(OUTPUT)) {
            throw new WorkflowFileException("Output definition of connection not found");
        }
        Map<String, EndpointDescription> outputNodesEpDescs = this.endpointDescs.get(outputNode.getIdentifier());
        if (outputNodesEpDescs == null) {
            throw new WorkflowFileException("Output's workflow node of connection not exists: " + outputNode.getIdentifier());
        }
        EndpointDescription outputEpDesc = outputNodesEpDescs.get(connectionJsonNode.get(OUTPUT).asText());
        if (outputEpDesc == null) {
            throw new WorkflowFileException("Output of connection not exists: " + connectionJsonNode.get(OUTPUT).asText());
        }
        if (!connectionJsonNode.has(TARGET)) {
            throw new WorkflowFileException("Target workflow node definition of connection not found");
        }
        WorkflowNode inputNode = nodes.get(connectionJsonNode.get(TARGET).asText());
        if (inputNode == null) {
            throw new WorkflowFileException("Target workflow node of connection not found: " + connectionJsonNode.get(TARGET).asText());
        }
        if (!connectionJsonNode.has(INPUT)) {
            throw new WorkflowFileException("Input definition of connection not found");
        }
        Map<String, EndpointDescription> inputNodesEpDescs = this.endpointDescs.get(inputNode.getIdentifier());
        if (inputNodesEpDescs == null) {
            throw new WorkflowFileException("Input's workflow node of connection not exists: " + outputNode.getIdentifier());
        }
        EndpointDescription inputEpDesc = inputNodesEpDescs.get(connectionJsonNode.get(INPUT).asText());
        if (inputEpDesc == null) {
            throw new WorkflowFileException("Input of connection not exists: " + connectionJsonNode.get(INPUT).asText());
        }
        return new Connection(outputNode, outputEpDesc, inputNode, inputEpDesc);
    }

    private void parseBendpointsEntry(JsonNode bendpointsJsonNode, Map<String, WorkflowNode> nodes, List<Connection> connections, ParsingFailedFlagHolder parsingFailedFlag) throws IOException {
        if (nodes != null || connections == null) {
            if (bendpointsJsonNode instanceof ArrayNode) {
                this.parseBendpoints((ArrayNode)bendpointsJsonNode, nodes, connections, parsingFailedFlag);
            } else {
                this.parseBendpoints((ArrayNode)JSON_OBJECT_MAPPER.readTree(bendpointsJsonNode.asText()), nodes, connections, parsingFailedFlag);
            }
        } else {
            this.handleParseFailure(parsingFailedFlag, "Failed to read bendpoints (no workflow nodes or connections defined), skipping them");
        }
    }

    public synchronized void parseBendpoints(ArrayNode bendpointsJsonNode, Map<String, WorkflowNode> nodes, List<Connection> connections) throws IOException {
        ParsingFailedFlagHolder parsingFailedFlag = new ParsingFailedFlagHolder();
        this.parseBendpoints(bendpointsJsonNode, nodes, connections, parsingFailedFlag);
        if (parsingFailedFlag.parsingFailed) {
            throw new IOException("Failed to parse bendpoint(s)");
        }
    }

    private void parseBendpoints(ArrayNode bendpointsJsonNode, Map<String, WorkflowNode> nodes, List<Connection> connections, ParsingFailedFlagHolder parsingFailedFlag) {
        Iterator bendpointJsonNodeIterator = bendpointsJsonNode.elements();
        while (bendpointJsonNodeIterator.hasNext()) {
            ObjectNode bendpointJsonNode = (ObjectNode)bendpointJsonNodeIterator.next();
            try {
                this.parseBendpoint(bendpointJsonNode, nodes, connections);
            }
            catch (WorkflowFileException e) {
                this.handleParsingExceptions(e, "Failed to parse bendpoint, skipping it", (JsonNode)bendpointJsonNode, parsingFailedFlag);
            }
        }
    }

    private void parseBendpoint(ObjectNode bendpointJsonNode, Map<String, WorkflowNode> nodes, List<Connection> connections) throws WorkflowFileException {
        if (!bendpointJsonNode.has(SOURCE)) {
            throw new WorkflowFileException("Source of bendpoint not found");
        }
        WorkflowNode outputNode = nodes.get(bendpointJsonNode.get(SOURCE).asText());
        if (outputNode == null) {
            throw new WorkflowFileException("Source workflow node of connection bendpoint not found: " + bendpointJsonNode.get(SOURCE).asText());
        }
        if (!bendpointJsonNode.has(TARGET)) {
            throw new WorkflowFileException("Target of bendpoint not found");
        }
        WorkflowNode inputNode = nodes.get(bendpointJsonNode.get(TARGET).asText());
        if (inputNode == null) {
            throw new WorkflowFileException("Target workflow node of connection bendpoint not found: " + bendpointJsonNode.get(TARGET).asText());
        }
        if (!bendpointJsonNode.has(COORDINATES)) {
            throw new WorkflowFileException("Coordinates of bendpoint not found");
        }
        String bendpointListString = bendpointJsonNode.get(COORDINATES).asText();
        ArrayList<Location> bendpoints = new ArrayList<Location>();
        String[] stringArray = bendpointListString.split(BENDPOINT_SEPARATOR);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String bendpointString = stringArray[n2];
            String[] bendpointParts = bendpointString.split(BENDPOINT_COORDINATE_SEPARATOR);
            try {
                Location bendpoint = new Location(Integer.parseInt(bendpointParts[0]), Integer.parseInt(bendpointParts[1]));
                bendpoints.add(bendpoint);
            }
            catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
                LOG.error((Object)("Error when parsing workflow file: Failed to parse bendpoint, skipping it: " + e.getMessage()));
            }
            ++n2;
        }
        for (Connection connection : connections) {
            if (!connection.getTargetNode().getIdentifier().equals(inputNode.getIdentifier()) || !connection.getSourceNode().getIdentifier().equals(outputNode.getIdentifier())) continue;
            connection.setBendpoints(bendpoints);
        }
    }

    public Map<String, String> calculateUniqueBendpointList(List<Connection> connections) {
        HashMap<String, String> connectionBendpointMapping = new HashMap<String, String>();
        Collections.sort(connections);
        for (Connection c : connections) {
            String sourceId = c.getSourceNode().getIdentifier();
            String targetId = c.getTargetNode().getIdentifier();
            List<Location> bendpoints = c.getBendpoints();
            if (bendpoints.isEmpty()) continue;
            String bendpointString = this.parseListOfBendpointsToString(bendpoints);
            String connectionString = String.valueOf(sourceId) + BENDPOINT_COORDINATE_SEPARATOR + targetId;
            if (connectionBendpointMapping.keySet().contains(connectionString)) continue;
            connectionBendpointMapping.put(connectionString, bendpointString);
        }
        return connectionBendpointMapping;
    }

    private String parseListOfBendpointsToString(List<Location> locations) {
        String assembledBendpointString = "";
        for (Location location : locations) {
            assembledBendpointString = String.valueOf(assembledBendpointString) + location.x;
            assembledBendpointString = String.valueOf(assembledBendpointString) + BENDPOINT_COORDINATE_SEPARATOR;
            assembledBendpointString = String.valueOf(assembledBendpointString) + location.y;
            assembledBendpointString = String.valueOf(assembledBendpointString) + BENDPOINT_SEPARATOR;
        }
        assembledBendpointString = assembledBendpointString.substring(0, assembledBendpointString.length() - 1);
        return assembledBendpointString;
    }

    private void parseLabelsEntry(JsonNode labelsJsonNode, WorkflowDescription wd, ParsingFailedFlagHolder parsingFailedFlag) throws IOException {
        if (labelsJsonNode instanceof ArrayNode) {
            for (WorkflowLabel label : this.parseLabels((ArrayNode)labelsJsonNode, parsingFailedFlag)) {
                wd.addWorkflowLabel(label);
            }
        } else {
            for (WorkflowLabel label : this.parseLabels((ArrayNode)JSON_OBJECT_MAPPER.readTree(labelsJsonNode.asText()), parsingFailedFlag)) {
                wd.addWorkflowLabel(label);
            }
        }
    }

    private Map<String, String> parseConfigurationValues(ObjectNode configurationJsonNode) {
        HashMap<String, String> configuration = new HashMap<String, String>();
        Iterator configurationJsonNodeIterator = configurationJsonNode.fieldNames();
        while (configurationJsonNodeIterator.hasNext()) {
            String key = (String)configurationJsonNodeIterator.next();
            configuration.put(key, configurationJsonNode.get(key).asText());
        }
        return configuration;
    }

    public Set<WorkflowLabel> parseLabels(ArrayNode labelsJsonNode) throws IOException {
        ParsingFailedFlagHolder parsingFailedFlag = new ParsingFailedFlagHolder();
        Set<WorkflowLabel> labels = this.parseLabels(labelsJsonNode, parsingFailedFlag);
        if (parsingFailedFlag.parsingFailed) {
            throw new IOException("Failed to parse some of the bendpoints");
        }
        return labels;
    }

    private Set<WorkflowLabel> parseLabels(ArrayNode labelsJsonNode, ParsingFailedFlagHolder parsingFailedFlag) {
        LinkedHashSet<WorkflowLabel> labels = new LinkedHashSet<WorkflowLabel>();
        Iterator labelsJsonNodeIterator = labelsJsonNode.elements();
        while (labelsJsonNodeIterator.hasNext()) {
            ObjectNode labelJsonNode = (ObjectNode)labelsJsonNodeIterator.next();
            try {
                WorkflowLabel label = this.parseLabel(labelJsonNode);
                labels.add(label);
            }
            catch (WorkflowFileException e) {
                this.handleParsingExceptions(e, "Failed to parse label, skipping it", (JsonNode)labelJsonNode, parsingFailedFlag);
            }
        }
        return labels;
    }

    private WorkflowLabel parseLabel(ObjectNode labelJsonNode) throws WorkflowFileException {
        WorkflowLabel.LabelPosition labelPosition;
        int[] color;
        String[] colorString;
        if (!labelJsonNode.has(TEXT)) {
            throw new WorkflowFileException("Text for workflow label not found");
        }
        WorkflowLabel label = new WorkflowLabel(labelJsonNode.get(TEXT).asText());
        if (labelJsonNode.has(IDENTIFIER)) {
            label.setIdentifier(labelJsonNode.get(IDENTIFIER).asText());
        }
        if (labelJsonNode.has(HEADER_TEXT)) {
            label.setHeaderText(labelJsonNode.get(HEADER_TEXT).asText());
        }
        if (labelJsonNode.has(LOCATION)) {
            String[] location = StringUtils.splitAndUnescape((String)labelJsonNode.get(LOCATION).asText());
            try {
                label.setLocation(Integer.parseInt(location[0]), Integer.parseInt(location[1]));
            }
            catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
                LOG.error((Object)("Error when parsing workflow file: Failed to parse location of label; use default: " + e.getMessage()));
            }
        }
        if (labelJsonNode.has(SIZE)) {
            String[] size = StringUtils.splitAndUnescape((String)labelJsonNode.get(SIZE).asText());
            try {
                label.setSize(Integer.parseInt(size[0]), Integer.parseInt(size[1]));
            }
            catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
                LOG.error((Object)("Error when parsing workflow file: Failed to parse size of label; use default: " + e.getMessage()));
            }
        }
        if (labelJsonNode.has(ALPHA)) {
            label.setAlpha(labelJsonNode.get(ALPHA).asInt());
        }
        if (labelJsonNode.has(COLOR_RGB_HEADER)) {
            colorString = StringUtils.splitAndUnescape((String)labelJsonNode.get(COLOR_RGB_HEADER).asText());
            try {
                color = new int[]{Integer.parseInt(colorString[0]), Integer.parseInt(colorString[1]), Integer.parseInt(colorString[2])};
                label.setColorHeader(color);
            }
            catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
                LOG.error((Object)("Error when parsing workflow file: Failed to parse text color of label; use default: " + e.getMessage()));
            }
        }
        if (labelJsonNode.has(COLOR_RGB_TEXT)) {
            colorString = StringUtils.splitAndUnescape((String)labelJsonNode.get(COLOR_RGB_TEXT).asText());
            try {
                color = new int[]{Integer.parseInt(colorString[0]), Integer.parseInt(colorString[1]), Integer.parseInt(colorString[2])};
                label.setColorText(color);
            }
            catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
                LOG.error((Object)("Error when parsing workflow file: Failed to parse text color of label; use default: " + e.getMessage()));
            }
        }
        if (labelJsonNode.has(COLOR_RGB_BACKGROUND)) {
            colorString = StringUtils.splitAndUnescape((String)labelJsonNode.get(COLOR_RGB_BACKGROUND).asText());
            try {
                color = new int[]{Integer.parseInt(colorString[0]), Integer.parseInt(colorString[1]), Integer.parseInt(colorString[2])};
                label.setColorBackground(color);
            }
            catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
                LOG.error((Object)("Error when parsing workflow file: Failed to parse background color of label; use default: " + e.getMessage()));
            }
        }
        if (labelJsonNode.has(LABEL_POSITION)) {
            labelPosition = WorkflowLabel.LabelPosition.valueOf(labelJsonNode.get(LABEL_POSITION).asText());
            label.setLabelPosition(labelPosition);
        } else if (labelJsonNode.has(LABEL_POSITION_OLD)) {
            labelPosition = WorkflowLabel.LabelPosition.valueOf(labelJsonNode.get(LABEL_POSITION_OLD).asText());
            label.setLabelPosition(labelPosition);
        }
        if (labelJsonNode.has(TEXT_ALIGNMENT)) {
            WorkflowLabel.TextAlignmentType textAlignmentType = WorkflowLabel.TextAlignmentType.valueOf(labelJsonNode.get(TEXT_ALIGNMENT).asText());
            label.setTextAlignmentType(textAlignmentType);
        }
        if (labelJsonNode.has(HEADER_ALIGNMENT)) {
            WorkflowLabel.TextAlignmentType headerAlignmentType = WorkflowLabel.TextAlignmentType.valueOf(labelJsonNode.get(HEADER_ALIGNMENT).asText());
            label.setHeaderAlignmentType(headerAlignmentType);
        }
        if (labelJsonNode.has(BORDER)) {
            label.setHasBorder(labelJsonNode.get(BORDER).asBoolean());
        }
        if (labelJsonNode.has(HEADER_SIZE)) {
            label.setHeaderTextSize(labelJsonNode.get(HEADER_SIZE).asInt());
        }
        if (labelJsonNode.has(TEXT_SIZE)) {
            label.setTextSize(labelJsonNode.get(TEXT_SIZE).asInt());
        }
        if (labelJsonNode.has(Z_INDEX)) {
            label.setZIndex(labelJsonNode.get(Z_INDEX).asInt());
        }
        return label;
    }

    public class ParsingFailedFlagHolder {
        public boolean parsingFailed = false;
    }
}

