/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.workflow.execution.internal;

import de.rcenvironment.core.communication.common.CommunicationException;
import de.rcenvironment.core.communication.common.LogicalNodeId;
import de.rcenvironment.core.communication.common.ResolvableNodeId;
import de.rcenvironment.core.component.execution.api.ComponentExecutionException;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionContext;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionException;
import de.rcenvironment.core.component.workflow.model.api.WorkflowDescription;
import de.rcenvironment.core.component.workflow.model.api.WorkflowDescriptionPersistenceHandler;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.datamanagement.DataManagementIdMapping;
import de.rcenvironment.core.datamanagement.DataManagementService;
import de.rcenvironment.core.datamanagement.backend.MetaDataBackendService;
import de.rcenvironment.core.datamanagement.commons.ComponentInstance;
import de.rcenvironment.core.datamanagement.commons.EndpointInstance;
import de.rcenvironment.core.datamanagement.commons.MetaData;
import de.rcenvironment.core.datamanagement.commons.MetaDataSet;
import de.rcenvironment.core.datamodel.api.EndpointType;
import de.rcenvironment.core.datamodel.api.FinalWorkflowState;
import de.rcenvironment.core.datamodel.api.TimelineIntervalType;
import de.rcenvironment.core.datamodel.api.TypedDatum;
import de.rcenvironment.core.datamodel.api.TypedDatumService;
import de.rcenvironment.core.datamodel.types.api.FileReferenceTD;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.TempFileServiceAccess;
import de.rcenvironment.core.utils.common.rpc.RemoteOperationException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.LogFactory;

public class WorkflowExecutionStorageBridge {
    private static MetaDataBackendService metaDataBackendService;
    private static DataManagementService dataManagementService;
    private static TypedDatumService typedDatumService;
    private String errorMessageSuffix;
    private volatile long workflowDmId;
    private Map<String, Long> compInstDmIds;
    private Map<String, Map<String, Long>> inputDmIds = new HashMap<String, Map<String, Long>>();
    private Map<String, Map<String, Long>> outputDmIds = new HashMap<String, Map<String, Long>>();
    private Map<String, Long> intervalTypeDmIds = Collections.synchronizedMap(new HashMap());

    @Deprecated
    public WorkflowExecutionStorageBridge() {
    }

    public WorkflowExecutionStorageBridge(WorkflowExecutionContext wfExeCtx) {
        this.errorMessageSuffix = StringUtils.format((String)" of workflow '%s' (%s)", (Object[])new Object[]{wfExeCtx.getInstanceName(), wfExeCtx.getExecutionIdentifier()});
    }

    protected DataManagementIdsHolder addWorkflowExecution(WorkflowExecutionContext wfExeCtx, WorkflowDescription fullWorkflowDescription) throws WorkflowExecutionException {
        try {
            this.workflowDmId = metaDataBackendService.addWorkflowRun(wfExeCtx.getInstanceName(), DataManagementIdMapping.mapLogicalNodeIdToDbString((LogicalNodeId)wfExeCtx.getNodeId()), DataManagementIdMapping.mapLogicalNodeIdToDbString((LogicalNodeId)wfExeCtx.getDefaultStorageNodeId()), Long.valueOf(System.currentTimeMillis()));
            if (wfExeCtx.getAdditionalInformationProvidedAtStart() != null) {
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put("additionalInformation", wfExeCtx.getAdditionalInformationProvidedAtStart());
                metaDataBackendService.addWorkflowRunProperties(Long.valueOf(this.workflowDmId), properties);
            }
            try {
                MetaDataSet mds = new MetaDataSet();
                MetaData mdWorkflowRunId = new MetaData("rce.common.workflow_run_id", true, true);
                mds.setValue(mdWorkflowRunId, String.valueOf(this.workflowDmId));
                WorkflowDescriptionPersistenceHandler persistenceHandler = new WorkflowDescriptionPersistenceHandler();
                ByteArrayOutputStream content = persistenceHandler.writeWorkflowDescriptionToStream(fullWorkflowDescription);
                String wfFileName = wfExeCtx.getWorkflowDescription().getFileName();
                if (wfFileName == null) {
                    wfFileName = "workflow.wf";
                }
                File wfFile = TempFileServiceAccess.getInstance().createTempFileWithFixedFilename(wfFileName);
                FileUtils.writeByteArrayToFile((File)wfFile, (byte[])content.toByteArray());
                String wfFileReference = dataManagementService.createReferenceFromLocalFile(wfFile, mds, (ResolvableNodeId)wfExeCtx.getNodeId());
                FileReferenceTD fileRefTD = typedDatumService.getFactory().createFileReference(wfFileReference, wfFile.getName());
                metaDataBackendService.addWorkflowFileToWorkflowRun(Long.valueOf(this.workflowDmId), typedDatumService.getSerializer().serialize((TypedDatum)fileRefTD));
            }
            catch (CommunicationException | IOException | InterruptedException e) {
                throw new WorkflowExecutionException("Failed to store workflow file" + this.errorMessageSuffix, (Exception)e);
            }
        }
        catch (RemoteOperationException | RuntimeException e) {
            throw new WorkflowExecutionException("Failed to store workflow execution" + this.errorMessageSuffix, (Exception)e);
        }
        HashMap compInputInstances = new HashMap();
        HashMap compOutputInstances = new HashMap();
        HashSet<ComponentInstance> componentInstances = new HashSet<ComponentInstance>();
        for (WorkflowNode wn : wfExeCtx.getWorkflowDescription().getWorkflowNodes()) {
            HashMap<String, String> metaData;
            HashSet<EndpointInstance> endpointInstances = new HashSet<EndpointInstance>();
            String compExeId = wfExeCtx.getCompExeIdByWfNodeId(wn.getIdentifier());
            componentInstances.add(new ComponentInstance(compExeId, wn.getComponentDescription().getIdentifier(), wn.getName(), null));
            for (EndpointDescription ep : wn.getComponentDescription().getInputDescriptionsManager().getEndpointDescriptions()) {
                metaData = new HashMap<String, String>();
                metaData.put("rce.common.data_type", ep.getDataType().getShortName());
                endpointInstances.add(new EndpointInstance(ep.getName(), EndpointType.INPUT, metaData));
            }
            compInputInstances.put(compExeId, endpointInstances);
            endpointInstances = new HashSet();
            for (EndpointDescription ep : wn.getComponentDescription().getOutputDescriptionsManager().getEndpointDescriptions()) {
                metaData = new HashMap();
                metaData.put("rce.common.data_type", ep.getDataType().getShortName());
                endpointInstances.add(new EndpointInstance(ep.getName(), EndpointType.OUTPUT, metaData));
            }
            compOutputInstances.put(compExeId, endpointInstances);
        }
        try {
            this.compInstDmIds = metaDataBackendService.addComponentInstances(Long.valueOf(this.workflowDmId), componentInstances);
        }
        catch (RemoteOperationException | RuntimeException e) {
            throw new WorkflowExecutionException("Failed to store component instances" + this.errorMessageSuffix, (Exception)e);
        }
        for (String dmId : compInputInstances.keySet()) {
            try {
                this.inputDmIds.put(dmId, metaDataBackendService.addEndpointInstances(this.compInstDmIds.get(dmId), (Collection)compInputInstances.get(dmId)));
            }
            catch (RemoteOperationException | RuntimeException e) {
                throw new WorkflowExecutionException("Failed to store component input instances" + this.errorMessageSuffix, (Exception)e);
            }
        }
        for (String compExeId : compOutputInstances.keySet()) {
            try {
                this.outputDmIds.put(compExeId, metaDataBackendService.addEndpointInstances(this.compInstDmIds.get(compExeId), (Collection)compOutputInstances.get(compExeId)));
            }
            catch (RemoteOperationException | RuntimeException e) {
                throw new WorkflowExecutionException("Failed to store component output instances" + this.errorMessageSuffix, (Exception)e);
            }
        }
        for (WorkflowNode wn : wfExeCtx.getWorkflowDescription().getWorkflowNodes()) {
            String compExeId = wfExeCtx.getCompExeIdByWfNodeId(wn.getIdentifier());
            try {
                for (EndpointDescription ep : wn.getComponentDescription().getInputDescriptionsManager().getEndpointDescriptions()) {
                    metaDataBackendService.addEndpointInstanceProperties(this.inputDmIds.get(compExeId).get(ep.getName()), ep.getMetaDataToPersist());
                }
                for (EndpointDescription ep : wn.getComponentDescription().getOutputDescriptionsManager().getEndpointDescriptions()) {
                    metaDataBackendService.addEndpointInstanceProperties(this.outputDmIds.get(compExeId).get(ep.getName()), ep.getMetaDataToPersist());
                }
            }
            catch (RemoteOperationException | RuntimeException e) {
                throw new WorkflowExecutionException("Failed to store meta data for component output instances" + this.errorMessageSuffix, (Exception)e);
            }
        }
        return new DataManagementIdsHolder(this.compInstDmIds, this.inputDmIds, this.outputDmIds);
    }

    protected void addWorkflowErrorLog(File logfile, String fileName) throws WorkflowExecutionException {
        try {
            MetaDataSet mds = new MetaDataSet();
            MetaData mdWorkflowRunId = new MetaData("rce.common.workflow_run_id", true, true);
            mds.setValue(mdWorkflowRunId, String.valueOf(this.workflowDmId));
            String logFileReference = dataManagementService.createReferenceFromLocalFile(logfile, mds, null);
            FileReferenceTD fileReference = typedDatumService.getFactory().createFileReference(logFileReference, fileName);
            fileReference.setFileSize(FileUtils.sizeOf((File)logfile));
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("wfErrorLogFile", typedDatumService.getSerializer().serialize((TypedDatum)fileReference));
            metaDataBackendService.addWorkflowRunProperties(Long.valueOf(this.workflowDmId), properties);
        }
        catch (CommunicationException | RemoteOperationException | IOException | InterruptedException | RuntimeException e) {
            throw new WorkflowExecutionException("Failed to store error log file." + this.errorMessageSuffix, (Exception)e);
        }
    }

    protected void setWorkflowExecutionFinished(FinalWorkflowState finalState) throws WorkflowExecutionException {
        try {
            metaDataBackendService.setWorkflowRunFinished(Long.valueOf(this.workflowDmId), Long.valueOf(System.currentTimeMillis()), finalState);
        }
        catch (RemoteOperationException | RuntimeException e) {
            throw new WorkflowExecutionException("Failed to store final state" + this.errorMessageSuffix, (Exception)e);
        }
        if (!this.intervalTypeDmIds.isEmpty()) {
            LogFactory.getLog(WorkflowExecutionStorageBridge.class).warn((Object)("Timeline interval ids left which were not used for setting timeline interval to finished: " + this.intervalTypeDmIds));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addComponentTimelineInterval(TimelineIntervalType intervalType, long startTime, String compRunDmId) throws WorkflowExecutionException {
        Long intervalTypeDmId;
        Map<String, Long> map = this.intervalTypeDmIds;
        synchronized (map) {
            if (this.intervalTypeDmIds.containsKey(this.createTimelineIntervalMapKey(intervalType, compRunDmId))) {
                throw new WorkflowExecutionException("Timeline interval already written within this component run: " + this.intervalTypeDmIds);
            }
        }
        try {
            intervalTypeDmId = metaDataBackendService.addTimelineInterval(Long.valueOf(this.workflowDmId), intervalType, startTime, Long.valueOf(compRunDmId));
        }
        catch (RemoteOperationException | RuntimeException e) {
            throw new WorkflowExecutionException("Failed to store start of timeline interval" + this.errorMessageSuffix, (Exception)e);
        }
        Map<String, Long> map2 = this.intervalTypeDmIds;
        synchronized (map2) {
            this.intervalTypeDmIds.put(this.createTimelineIntervalMapKey(intervalType, compRunDmId), intervalTypeDmId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setComponentTimelineIntervalFinished(TimelineIntervalType intervalType, long endTime, String compRunDmId) throws WorkflowExecutionException {
        Map<String, Long> map = this.intervalTypeDmIds;
        synchronized (map) {
            Long dmId = this.intervalTypeDmIds.remove(this.createTimelineIntervalMapKey(intervalType, compRunDmId));
            if (dmId != null) {
                try {
                    metaDataBackendService.setTimelineIntervalFinished(dmId, endTime);
                }
                catch (RemoteOperationException | RuntimeException e) {
                    throw new WorkflowExecutionException("Failed to store end of timeline interval" + this.errorMessageSuffix, (Exception)e);
                }
            } else {
                throw new WorkflowExecutionException(StringUtils.format((String)"Failed to store end of timeline interval '%s' for component '%s' as no valid dm id exists", (Object[])new Object[]{intervalType.name(), compRunDmId}));
            }
        }
    }

    private String createTimelineIntervalMapKey(TimelineIntervalType intervalType, String compRunDmId) {
        return StringUtils.escapeAndConcat((String[])new String[]{compRunDmId, intervalType.name()});
    }

    protected void addComponentCompleteLog(File completeLogfile, String fileName, String compRunDmId) throws ComponentExecutionException {
        this.addComponentLog(completeLogfile, fileName, compRunDmId, "compLogFile");
    }

    protected void addComponentErrorLog(File errorLogfile, String fileName, String compRunDmId) throws ComponentExecutionException {
        this.addComponentLog(errorLogfile, fileName, compRunDmId, "compErrorLogFile");
    }

    private void addComponentLog(File logfile, String fileName, String compRunDmId, String logFilePropertyKey) throws ComponentExecutionException {
        try {
            MetaDataSet mds = new MetaDataSet();
            MetaData compRunId = new MetaData("rce.common.component_run_id", true, true);
            mds.setValue(compRunId, compRunDmId);
            String logFileReference = dataManagementService.createReferenceFromLocalFile(logfile, mds, null);
            FileReferenceTD fileReference = typedDatumService.getFactory().createFileReference(logFileReference, fileName);
            fileReference.setFileSize(FileUtils.sizeOf((File)logfile));
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put(logFilePropertyKey, typedDatumService.getSerializer().serialize((TypedDatum)fileReference));
            metaDataBackendService.addComponentRunProperties(Long.valueOf(compRunDmId), properties);
        }
        catch (CommunicationException | RemoteOperationException | IOException | InterruptedException | RuntimeException e) {
            throw new ComponentExecutionException("Failed to store component log file" + this.errorMessageSuffix, e);
        }
    }

    protected Long getWorkflowInstanceDataManamagementId() {
        return this.workflowDmId;
    }

    protected void bindMetaDataService(MetaDataBackendService newService) {
        metaDataBackendService = newService;
    }

    protected void bindDataManagementService(DataManagementService newService) {
        dataManagementService = newService;
    }

    protected void bindTypedDatumService(TypedDatumService newService) {
        typedDatumService = newService;
    }

    class DataManagementIdsHolder {
        public final Map<String, Long> compInstDmIds;
        public final Map<String, Map<String, Long>> inputDmIds;
        public final Map<String, Map<String, Long>> outputDmIds;

        DataManagementIdsHolder(Map<String, Long> compInstDmIds, Map<String, Map<String, Long>> inputDmIds, Map<String, Map<String, Long>> outputDmIds) {
            this.compInstDmIds = compInstDmIds;
            this.inputDmIds = inputDmIds;
            this.outputDmIds = outputDmIds;
        }
    }
}

