/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.workflow.execution.internal;

import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionContext;
import de.rcenvironment.core.component.workflow.execution.internal.ComponentStatesChangedEntirelyVerifier;
import de.rcenvironment.core.component.workflow.execution.internal.WorkflowExecutionControllerImpl;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.incubator.DebugSettings;
import de.rcenvironment.toolkit.modules.concurrency.api.TaskDescription;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ComponentLostWatcher
implements Runnable {
    public static final int DEFAULT_MAX_HEA7RTBEAT_INTERVAL_MSEC = 140000;
    protected static int maxHeartbeatIntervalMsec = 140000;
    private static final Log LOG = LogFactory.getLog(WorkflowExecutionControllerImpl.class);
    private static final boolean VERBOSE_LOGGING = DebugSettings.getVerboseLoggingEnabled(ComponentLostWatcher.class);
    private final Map<String, Long> componentHeartbeatTimestamps = Collections.synchronizedMap(new HashMap());
    private final ComponentStatesChangedEntirelyVerifier compStatesEntirelyChangedVerifier;
    private final String logMessage;

    public ComponentLostWatcher(ComponentStatesChangedEntirelyVerifier compStatesEntirelyChangedVerifier, WorkflowExecutionContext wfExeCtx) {
        this.compStatesEntirelyChangedVerifier = compStatesEntirelyChangedVerifier;
        this.logMessage = StringUtils.format((String)"Checking component heartbeats for workflow '%s' (%s)", (Object[])new Object[]{wfExeCtx.getInstanceName(), wfExeCtx.getExecutionIdentifier()});
    }

    public void announceComponentHeartbeat(String compExecutionId) {
        this.componentHeartbeatTimestamps.put(compExecutionId, System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @TaskDescription(value="Check heartbeats of components")
    public void run() {
        if (VERBOSE_LOGGING) {
            LOG.debug((Object)this.logMessage);
        }
        long currentTimestamp = System.currentTimeMillis();
        HashSet<String> compExeIdsLost = new HashSet<String>();
        Map<String, Long> map = this.componentHeartbeatTimestamps;
        synchronized (map) {
            for (String compExeId : this.componentHeartbeatTimestamps.keySet()) {
                if (currentTimestamp - this.componentHeartbeatTimestamps.get(compExeId) <= (long)maxHeartbeatIntervalMsec || this.compStatesEntirelyChangedVerifier.isComponentInFinalState(compExeId)) continue;
                compExeIdsLost.add(compExeId);
            }
        }
        if (!compExeIdsLost.isEmpty()) {
            this.compStatesEntirelyChangedVerifier.announceLostComponents(compExeIdsLost);
        }
    }
}

