/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.workflow.execution.headless.api;

import de.rcenvironment.core.component.execution.api.SingleConsoleRowsProcessor;
import de.rcenvironment.core.component.workflow.execution.headless.api.HeadlessWorkflowExecutionContext;
import de.rcenvironment.core.component.workflow.execution.headless.api.HeadlessWorkflowExecutionService;
import de.rcenvironment.core.component.workflow.execution.headless.internal.HeadlessWorkflowExecutionContextImpl;
import de.rcenvironment.core.utils.common.CrossPlatformFilenameUtils;
import de.rcenvironment.core.utils.common.InvalidFilenameException;
import de.rcenvironment.core.utils.common.textstream.TextOutputReceiver;
import java.io.File;

public final class HeadlessWorkflowExecutionContextBuilder {
    private HeadlessWorkflowExecutionContextImpl headlessWfExeCtx = new HeadlessWorkflowExecutionContextImpl();

    public HeadlessWorkflowExecutionContextBuilder(File wfFile, File logDirectory) throws InvalidFilenameException {
        this.headlessWfExeCtx.setWfFile(wfFile);
        CrossPlatformFilenameUtils.throwExceptionIfFilenameNotValid((String)wfFile.getName());
        this.headlessWfExeCtx.setLogDirectory(logDirectory);
    }

    public HeadlessWorkflowExecutionContextBuilder setPlaceholdersFile(File placeholdersFile) {
        this.headlessWfExeCtx.setPlaceholdersFile(placeholdersFile);
        return this;
    }

    public HeadlessWorkflowExecutionContextBuilder setTextOutputReceiver(TextOutputReceiver outputReceiver) {
        this.headlessWfExeCtx.setTextOutputReceiver(outputReceiver);
        return this;
    }

    public HeadlessWorkflowExecutionContextBuilder setTextOutputReceiver(TextOutputReceiver outputReceiver, boolean isCompactOutput) {
        this.headlessWfExeCtx.setTextOutputReceiver(outputReceiver);
        this.headlessWfExeCtx.setIsCompactOutput(isCompactOutput);
        return this;
    }

    public HeadlessWorkflowExecutionContextBuilder setSingleConsoleRowsProcessor(SingleConsoleRowsProcessor consoleRowsProcessor) {
        this.headlessWfExeCtx.setSingleConsoleRowsProcessor(consoleRowsProcessor);
        return this;
    }

    public HeadlessWorkflowExecutionContextBuilder setDisposalBehavior(HeadlessWorkflowExecutionService.DisposalBehavior disposalBehavior) {
        this.headlessWfExeCtx.setDisposeBehavior(disposalBehavior);
        return this;
    }

    public HeadlessWorkflowExecutionContextBuilder setDeletionBehavior(HeadlessWorkflowExecutionService.DeletionBehavior delete) {
        this.headlessWfExeCtx.setDeletionBehavior(delete);
        return this;
    }

    public void setAbortIfWorkflowUpdateRequired(boolean value) {
        this.headlessWfExeCtx.setAbortIfWorkflowUpdateRequired(value);
    }

    public HeadlessWorkflowExecutionContext build() {
        return this.headlessWfExeCtx;
    }
}

