/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.script.execution.validator;

import de.rcenvironment.components.script.execution.Messages;
import de.rcenvironment.core.component.model.api.ComponentDescription;
import de.rcenvironment.core.component.validation.api.ComponentValidationMessage;
import de.rcenvironment.core.component.validation.spi.AbstractComponentValidator;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.textstream.TextOutputReceiver;
import de.rcenvironment.core.utils.common.textstream.TextStreamWatcher;
import de.rcenvironment.core.utils.common.textstream.receivers.CapturingTextOutReceiver;
import de.rcenvironment.core.utils.executor.LocalApacheCommandLineExecutor;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncTaskService;
import de.rcenvironment.toolkit.modules.concurrency.api.TaskDescription;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections4.map.PassiveExpiringMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ScriptComponentValidator
extends AbstractComponentValidator {
    private static final String PYTHON_VALIDATION_ERROR = "Validation of python path failed.";
    private static final Long PYTHON_TEST_TIMEOUT = 1L;
    private static final int MINUS_ONE = -1;
    private static final String COLON = ": ";
    private static Log logger = LogFactory.getLog(ScriptComponentValidator.class);
    private ExecutionOutputCache executionOutputCache = this.createExecutionOutputCache();

    public String getIdentifier() {
        return "de.rcenvironment.script";
    }

    protected List<ComponentValidationMessage> validateComponentSpecific(ComponentDescription componentDescription) {
        ArrayList<ComponentValidationMessage> messages = new ArrayList<ComponentValidationMessage>();
        String script = this.getProperty(componentDescription, "script");
        if (script == null || script.isEmpty()) {
            ComponentValidationMessage noScriptMessage = new ComponentValidationMessage(ComponentValidationMessage.Type.ERROR, "script", Messages.noScript, String.valueOf(Messages.noScript) + " defined");
            messages.add(noScriptMessage);
        } else if (script.endsWith("sys.stderr.flush()")) {
            ComponentValidationMessage defaultScriptMessage = new ComponentValidationMessage(ComponentValidationMessage.Type.WARNING, "script", Messages.defaultScriptMessage, Messages.defaultScriptMessage);
            messages.add(defaultScriptMessage);
        } else if (!this.checkScriptIndentationConsistency(script)) {
            ComponentValidationMessage inconsistentScriptMessage = new ComponentValidationMessage(ComponentValidationMessage.Type.WARNING, "script", Messages.scriptInconsistentIndentation, String.valueOf(Messages.scriptInconsistentIndentation) + COLON + "script");
            messages.add(inconsistentScriptMessage);
        }
        return messages;
    }

    private boolean checkScriptIndentationConsistency(String script) {
        String regexWs = "^ +([\\S].*)$";
        String regexWsOnly = "^( +)$";
        String regexTab = "^\\t+([\\S].*)$";
        String regexTabOnly = "^(\\t+)$";
        String eol = System.getProperty("line.separator");
        String[] scriptLines = script.split(eol);
        boolean ws = false;
        boolean tab = false;
        int i = 0;
        while (i < scriptLines.length) {
            if (!ws) {
                boolean bl = ws = scriptLines[i].matches(regexWs) || scriptLines[i].matches(regexWsOnly);
            }
            if (!tab) {
                boolean bl = tab = scriptLines[i].matches(regexTab) || scriptLines[i].matches(regexTabOnly);
            }
            if (scriptLines[i].matches("^(( +\\t+)|(\\t+ +)).*")) {
                return false;
            }
            ++i;
        }
        return !ws || !tab;
    }

    protected List<ComponentValidationMessage> validateOnWorkflowStartComponentSpecific(ComponentDescription componentDescription) {
        return null;
    }

    public List<ComponentValidationMessage> validateOnWorkflowStart(ComponentDescription componentDescription) {
        String pythonInstallation;
        ArrayList<ComponentValidationMessage> messages = new ArrayList<ComponentValidationMessage>();
        if (this.getProperty(componentDescription, "scriptLanguage").equals("Python") && !(pythonInstallation = this.getProperty(componentDescription, "pythonExecutionPath")).isEmpty()) {
            PythonVersionRegexValidator validator = new PythonVersionRegexValidator();
            if (this.executionOutputCache.containsKey(pythonInstallation)) {
                this.replayValidationWithCachedExecutionOutput(pythonInstallation, validator);
            } else {
                this.executeAndValidate(pythonInstallation, validator);
            }
            this.processPythonValidationResult(validator, messages, pythonInstallation);
        }
        return messages;
    }

    private void replayValidationWithCachedExecutionOutput(String pythonInstallation, PythonVersionRegexValidator validator) {
        for (String output : this.executionOutputCache.get(pythonInstallation)) {
            validator.validatePythonVersion(output);
        }
    }

    private void executeAndValidate(String pythonInstallation, final PythonVersionRegexValidator validator) {
        String command = "\"" + pythonInstallation + "\"" + " --version";
        try {
            block9: {
                final LocalApacheCommandLineExecutor executor = this.createCommandLineExecutor(new File("/"));
                executor.start(command);
                final TextStreamWatcher stdOutTextStreamWatcher = new TextStreamWatcher(executor.getStdout(), ConcurrencyUtils.getAsyncTaskService(), new TextOutputReceiver[]{new CapturingTextOutReceiver(){

                    public synchronized void addOutput(String line) {
                        super.addOutput(line);
                        validator.validatePythonVersion(this.getBufferedOutput());
                    }
                }});
                final TextStreamWatcher stdErrTextStreamWatcher = new TextStreamWatcher(executor.getStderr(), ConcurrencyUtils.getAsyncTaskService(), new TextOutputReceiver[]{new CapturingTextOutReceiver(){

                    public synchronized void addOutput(String line) {
                        super.addOutput(line);
                        validator.validatePythonVersion(this.getBufferedOutput());
                    }
                }});
                stdOutTextStreamWatcher.start();
                stdErrTextStreamWatcher.start();
                AsyncTaskService asyncTaskService = ConcurrencyUtils.getAsyncTaskService();
                Future task = asyncTaskService.submit(new Runnable(){

                    @Override
                    @TaskDescription(value="Waits for python validation to finish")
                    public void run() {
                        try {
                            executor.waitForTermination();
                            stdOutTextStreamWatcher.waitForTermination();
                            stdErrTextStreamWatcher.waitForTermination();
                        }
                        catch (IOException e) {
                            logger.error((Object)ScriptComponentValidator.PYTHON_VALIDATION_ERROR, (Throwable)e);
                        }
                        catch (InterruptedException e) {
                            logger.error((Object)ScriptComponentValidator.PYTHON_VALIDATION_ERROR, (Throwable)e);
                        }
                    }
                });
                try {
                    task.get(PYTHON_TEST_TIMEOUT, TimeUnit.SECONDS);
                }
                catch (TimeoutException timeoutException) {
                    executor.cancel();
                    executor.cancel();
                    break block9;
                }
                catch (ExecutionException e) {
                    try {
                        logger.error((Object)PYTHON_VALIDATION_ERROR, (Throwable)e);
                        break block9;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        executor.cancel();
                    }
                }
                executor.cancel();
            }
            this.executionOutputCache.put(pythonInstallation, validator.getOutputValidated());
        }
        catch (IOException | InterruptedException e) {
            logger.error((Object)PYTHON_VALIDATION_ERROR, (Throwable)e);
        }
    }

    private void processPythonValidationResult(PythonVersionRegexValidator validator, List<ComponentValidationMessage> messages, String path) {
        if (!validator.isPythonExecutionSuccessful() && validator.getMajorPythonVersion() == -1) {
            ComponentValidationMessage message = new ComponentValidationMessage(ComponentValidationMessage.Type.ERROR, "pythonExecutionPath", Messages.pythonExecutionTestErrorRelative, StringUtils.format((String)Messages.pythonExecutionTestErrorRelative, (Object[])new Object[]{path}));
            messages.add(message);
        } else if (!validator.isPythonExecutionSuccessful() && validator.getMinorPythonVersion() < 6 && validator.getMajorPythonVersion() >= 2) {
            ComponentValidationMessage message = new ComponentValidationMessage(ComponentValidationMessage.Type.ERROR, "pythonExecutionPath", Messages.pythonExecutionUnsupportedVersionRelative, Messages.pythonExecutionUnsupportedVersionRelative);
            messages.add(message);
        } else if (validator.isPythonExecutionSuccessful()) {
            this.logPythonExecutionSuccessfulMessage(validator);
        }
    }

    private void logPythonExecutionSuccessfulMessage(PythonVersionRegexValidator validator) {
        LogFactory.getLog(((Object)((Object)this)).getClass()).debug((Object)("Python Version Used: " + validator.getMajorPythonVersion() + "." + validator.getMinorPythonVersion() + "." + validator.getMicroPythonVersion()));
    }

    protected PythonVersionRegexValidator createPythonVersionRegexValidator() {
        return new PythonVersionRegexValidator();
    }

    protected LocalApacheCommandLineExecutor createCommandLineExecutor(File workDirPath) throws IOException {
        return new LocalApacheCommandLineExecutor(workDirPath);
    }

    protected ExecutionOutputCache createExecutionOutputCache() {
        return new ExecutionOutputCache();
    }

    protected static class ExecutionOutputCache {
        private static final int CACHE_EVICTION_TIME_MILLIS = 3000;
        private PassiveExpiringMap<String, List<String>> cachedExecutionOutput = new PassiveExpiringMap(3000L);

        protected ExecutionOutputCache() {
        }

        protected void put(String key, List<String> output) {
            this.cachedExecutionOutput.put((Object)key, output);
        }

        protected List<String> get(String key) {
            return (List)this.cachedExecutionOutput.get((Object)key);
        }

        protected boolean containsKey(String key) {
            return this.cachedExecutionOutput.containsKey((Object)key);
        }
    }

    protected static class PythonVersionRegexValidator {
        private static final int MINUS_ONE = -1;
        private static final Pattern MATCH_PATTERN = Pattern.compile("^Python\\s([0-9]+)\\.([0-9]+)\\.([0-9]+)");
        private volatile int majorPythonVersion = -1;
        private volatile int minorPythonVersion = -1;
        private volatile int microPythonVersion = -1;
        private volatile boolean pythonExecutionSuccessful = false;
        private List<String> outputValidated = Collections.synchronizedList(new ArrayList());

        protected PythonVersionRegexValidator() {
        }

        public synchronized void validatePythonVersion(String bufferedOutput) {
            this.outputValidated.add(bufferedOutput);
            Matcher matcher = MATCH_PATTERN.matcher(bufferedOutput);
            if (matcher.find()) {
                this.majorPythonVersion = Integer.parseInt(matcher.group(1));
                this.minorPythonVersion = Integer.parseInt(matcher.group(2));
                this.microPythonVersion = Integer.parseInt(matcher.group(3));
            }
            if (this.majorPythonVersion == 3 || this.majorPythonVersion == 2 && this.minorPythonVersion >= 6) {
                this.pythonExecutionSuccessful = true;
            }
        }

        public boolean isPythonExecutionSuccessful() {
            return this.pythonExecutionSuccessful;
        }

        public List<String> getOutputValidated() {
            return this.outputValidated;
        }

        public int getMajorPythonVersion() {
            return this.majorPythonVersion;
        }

        public int getMinorPythonVersion() {
            return this.minorPythonVersion;
        }

        public int getMicroPythonVersion() {
            return this.microPythonVersion;
        }
    }
}

