/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.database.gui;

import de.rcenvironment.components.database.common.jdbc.JDBCDriverInformation;
import de.rcenvironment.components.database.common.jdbc.JDBCDriverService;
import de.rcenvironment.core.gui.resources.api.ImageManager;
import de.rcenvironment.core.gui.resources.api.ImageSource;
import de.rcenvironment.core.gui.resources.api.StandardImages;
import de.rcenvironment.core.gui.workflow.editor.properties.ValidatingWorkflowNodePropertySection;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import de.rcenvironment.core.utils.incubator.ServiceRegistryAccess;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class DatabaseConnectionSection
extends ValidatingWorkflowNodePropertySection {
    private static JDBCDriverService jdbcDriverService;
    private static final Integer MINIMUM_TEXTFIELD_WIDTH;
    private CCombo databaseConnectorCombo;
    private ServiceRegistryAccess serviceRegistryAccess = ServiceRegistry.createAccessFor((Object)((Object)this));

    static {
        MINIMUM_TEXTFIELD_WIDTH = 150;
    }

    public DatabaseConnectionSection() {
        jdbcDriverService = (JDBCDriverService)this.serviceRegistryAccess.getService(JDBCDriverService.class);
    }

    protected void createCompositeContent(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createCompositeContent(parent, aTabbedPropertySheetPage);
        TabbedPropertySheetWidgetFactory factory = aTabbedPropertySheetPage.getWidgetFactory();
        Section sectionDatabase = factory.createSection(parent, 320);
        sectionDatabase.setText("Database Connection");
        sectionDatabase.marginWidth = 5;
        sectionDatabase.marginHeight = 5;
        Composite mainComposite = new Composite((Composite)sectionDatabase, 0);
        mainComposite.setLayout((Layout)new GridLayout(1, false));
        mainComposite.setBackground(Display.getCurrent().getSystemColor(1));
        GridData mainData = new GridData(1808);
        mainComposite.setLayoutData((Object)mainData);
        Composite informationLabelComposite = new Composite(mainComposite, 0);
        informationLabelComposite.setLayout((Layout)new GridLayout(2, false));
        GridData informationLabelData = new GridData(1808);
        informationLabelData.horizontalSpan = 2;
        informationLabelComposite.setLayoutData((Object)informationLabelData);
        CLabel informationLabel = new CLabel(informationLabelComposite, 16416);
        informationLabel.setText("Please define the database for this component to use:");
        Composite databaseSelectionComposite = new Composite(mainComposite, 0);
        databaseSelectionComposite.setLayout((Layout)new GridLayout(1, false));
        GridData databaseSelectionData = new GridData(1552);
        databaseSelectionComposite.setLayoutData((Object)databaseSelectionData);
        Group databaseSelectionGroup = new Group(databaseSelectionComposite, 0);
        databaseSelectionGroup.setText("Database");
        databaseSelectionGroup.setLayout((Layout)new GridLayout(2, false));
        GridData databaseSelectionGroupData = new GridData(1552);
        databaseSelectionGroup.setLayoutData((Object)databaseSelectionGroupData);
        Label databaseNameLabel = new Label((Composite)databaseSelectionGroup, 0);
        databaseNameLabel.setText("Database Name: ");
        GridData databaseNameLabelData = new GridData(2);
        databaseNameLabel.setLayoutData((Object)databaseNameLabelData);
        Text databaseNameText = new Text((Composite)databaseSelectionGroup, 2048);
        GridData databaseNameTextData = new GridData(2);
        databaseNameTextData.minimumWidth = MINIMUM_TEXTFIELD_WIDTH;
        databaseNameTextData.widthHint = MINIMUM_TEXTFIELD_WIDTH;
        databaseNameText.setLayoutData((Object)databaseNameTextData);
        databaseNameText.setData("property.control", (Object)"databaseName");
        Label databaseConnectorLabel = new Label((Composite)databaseSelectionGroup, 0);
        databaseConnectorLabel.setText("Database Type: ");
        GridData databaseConnectorLabelData = new GridData(2);
        databaseConnectorLabel.setLayoutData((Object)databaseConnectorLabelData);
        this.databaseConnectorCombo = new CCombo((Composite)databaseSelectionGroup, 2056);
        GridData databaseConnectorData = new GridData(2);
        databaseConnectorData.minimumWidth = MINIMUM_TEXTFIELD_WIDTH;
        databaseConnectorData.widthHint = MINIMUM_TEXTFIELD_WIDTH;
        this.databaseConnectorCombo.setLayoutData((Object)databaseConnectorData);
        this.databaseConnectorCombo.setData("property.control", (Object)"databaseConnector");
        for (JDBCDriverInformation jdbcDriver : jdbcDriverService.getRegisteredJDBCDrivers()) {
            this.databaseConnectorCombo.add(jdbcDriver.getDisplayName());
        }
        if (this.databaseConnectorCombo.getItemCount() > 0) {
            this.databaseConnectorCombo.select(0);
        }
        Label databaseHostLabel = new Label((Composite)databaseSelectionGroup, 0);
        databaseHostLabel.setText("Database Host: ");
        GridData databaseHostLabelData = new GridData(2);
        databaseHostLabel.setLayoutData((Object)databaseHostLabelData);
        Text databaseHostText = new Text((Composite)databaseSelectionGroup, 2048);
        GridData databaseHostTextData = new GridData(2);
        databaseHostTextData.minimumWidth = MINIMUM_TEXTFIELD_WIDTH;
        databaseHostTextData.widthHint = MINIMUM_TEXTFIELD_WIDTH;
        databaseHostText.setLayoutData((Object)databaseHostTextData);
        databaseHostText.setData("property.control", (Object)"databaseHost");
        Label databasePortLabel = new Label((Composite)databaseSelectionGroup, 0);
        databasePortLabel.setText("Database Port: ");
        GridData databasePortLabelData = new GridData(2);
        databasePortLabel.setLayoutData((Object)databasePortLabelData);
        Text databasePortText = new Text((Composite)databaseSelectionGroup, 2048);
        GridData databasePortTextData = new GridData(2);
        databasePortTextData.minimumWidth = MINIMUM_TEXTFIELD_WIDTH;
        databasePortTextData.widthHint = MINIMUM_TEXTFIELD_WIDTH;
        databasePortText.setLayoutData((Object)databasePortTextData);
        databasePortText.setData("property.control", (Object)"databasePort");
        Label databaseSchemeLabel = new Label((Composite)databaseSelectionGroup, 0);
        databaseSchemeLabel.setText("Default Scheme: ");
        GridData databaseSchemeLabelData = new GridData(2);
        databaseSchemeLabel.setLayoutData((Object)databaseSchemeLabelData);
        Text databaseSchemeText = new Text((Composite)databaseSelectionGroup, 2048);
        GridData databaseSchemeTextData = new GridData(2);
        databaseSchemeTextData.minimumWidth = MINIMUM_TEXTFIELD_WIDTH;
        databaseSchemeTextData.widthHint = MINIMUM_TEXTFIELD_WIDTH;
        databaseSchemeText.setLayoutData((Object)databaseSchemeTextData);
        databaseSchemeText.setData("property.control", (Object)"databaseScheme");
        CLabel databaseSchemeInformationLabel = new CLabel(mainComposite, 0);
        databaseSchemeInformationLabel.setText("Please note: 'Default Scheme' is the scheme you would define using the 'USE <scheme_name>' command.");
        databaseSchemeInformationLabel.setImage(ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.INFORMATION_16));
        GridData databaseSchemeInformationLabelData = new GridData(2);
        databaseSchemeInformationLabel.setLayoutData((Object)databaseSchemeInformationLabelData);
        sectionDatabase.setClient((Control)mainComposite);
    }
}

