/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.protocol;

import de.rcenvironment.core.utils.common.StringUtils;
import org.apache.commons.logging.LogFactory;

public final class ProtocolConstants {
    public static final String PROTOCOL_COMPATIBILITY_VERSION = "8.0.0-final";
    public static final String VALUE_MESSAGE_TYPE_RPC = "rpc";
    public static final String VALUE_MESSAGE_TYPE_HEALTH_CHECK = "healthCheck";
    @Deprecated
    public static final String VALUE_MESSAGE_TYPE_LSA = "lsa";
    public static final String VALUE_MESSAGE_TYPE_NODE_PROPERTIES_UPDATE = "np";
    public static final String VALUE_MESSAGE_TYPE_TEST = "test";
    public static final long JMS_MESSAGES_TTL_MSEC = 60000L;
    private static final String DESTINATION_MAY_HAVE_BECOME_UNREACHABLE_TEXT = "the destination instance may have become unreachable";

    private ProtocolConstants() {
    }

    public static enum ResultCode {
        UNDEFINED(0, null),
        SUCCESS(1, null),
        EXCEPTION_AT_DESTINATION(102, "An internal error occured on the destination node while processing this request; more information may be available in the destination node's log files"),
        EXCEPTION_DURING_DELIVERY(103, "There was an error while delivering the request to the destination node"),
        NO_ROUTE_TO_DESTINATION_WHILE_FORWARDING(104, "An instance between sender and destination was unable to forward the request; the destination instance may have become unreachable"),
        CHANNEL_CLOSED_OR_BROKEN_BEFORE_SENDING_REQUEST(105, "A network connection between sender and destination has been closed (by user action or an error) while sending/forwarding the request; the destination instance may have become unreachable"),
        CHANNEL_OR_RESPONSE_LISTENER_SHUT_DOWN_WHILE_WAITING_FOR_RESPONSE(106, "A network connection between sender and destination has been closed (by user action or an error) while awaiting the response; the destination instance may have become unreachable"),
        NO_ROUTE_TO_DESTINATION_AT_SENDER(107, "The destination instance for this request is unreachable; it was probably contacted because it was reachable at an earlier time"),
        TIMEOUT_WAITING_FOR_RESPONSE(108, "The destination instance for this request did not answer in time, or the response got lost because of a network error"),
        INVALID_RESULT_CODE(999, null);

        private final int code;
        private final String stringForm;

        private ResultCode(int code, String userMessage) {
            this.code = code;
            this.stringForm = userMessage != null ? StringUtils.format((String)"%s (error code %d)", (Object[])new Object[]{userMessage, code}) : StringUtils.format((String)"%s (error code %d)", (Object[])new Object[]{this.name(), code});
        }

        public int getCode() {
            return this.code;
        }

        public static ResultCode fromCode(int code) {
            ResultCode[] resultCodeArray = ResultCode.values();
            int n = resultCodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ResultCode rc = resultCodeArray[n2];
                if (rc.code == code) {
                    return rc;
                }
                ++n2;
            }
            LogFactory.getLog(ProtocolConstants.class).error((Object)("Received an invalid result code: " + code));
            return INVALID_RESULT_CODE;
        }

        public String toString() {
            return this.stringForm;
        }
    }
}

