/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.nodeproperties.internal;

import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import de.rcenvironment.core.communication.nodeproperties.NodeProperty;
import de.rcenvironment.core.communication.nodeproperties.internal.CompositeNodePropertyKey;
import de.rcenvironment.core.communication.nodeproperties.internal.NodePropertyImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NodePropertiesRegistry {
    private final Map<CompositeNodePropertyKey, NodePropertyImpl> knowledgeMap;
    private final Log log = LogFactory.getLog(this.getClass());

    public NodePropertiesRegistry() {
        this.knowledgeMap = new HashMap<CompositeNodePropertyKey, NodePropertyImpl>();
    }

    public Map<String, String> getNodeProperties(InstanceNodeSessionId nodeId) {
        String nodeIdString = nodeId.getInstanceNodeSessionIdString();
        HashMap<String, String> result = new HashMap<String, String>();
        for (NodePropertyImpl entry : this.knowledgeMap.values()) {
            CompositeNodePropertyKey key = entry.getCompositeKey();
            if (!key.getInstanceNodeSessionIdString().equals(nodeIdString)) continue;
            result.put(key.getDataKey(), entry.getValue());
        }
        return result;
    }

    public NodeProperty getNodeProperty(InstanceNodeSessionId nodeId, String dataKey) {
        CompositeNodePropertyKey ckey = new CompositeNodePropertyKey(nodeId.getInstanceNodeSessionIdString(), dataKey);
        return this.knowledgeMap.get(ckey);
    }

    public String getNodePropertyValue(InstanceNodeSessionId nodeId, String dataKey) {
        NodeProperty property = this.getNodeProperty(nodeId, dataKey);
        if (property != null) {
            return property.getValue();
        }
        return null;
    }

    public Map<InstanceNodeSessionId, Map<String, String>> getAllNodeProperties() {
        HashMap<InstanceNodeSessionId, Map<String, String>> result = new HashMap<InstanceNodeSessionId, Map<String, String>>();
        for (NodePropertyImpl entry : this.knowledgeMap.values()) {
            CompositeNodePropertyKey key = entry.getCompositeKey();
            InstanceNodeSessionId nodeId = entry.getInstanceNodeSessionId();
            HashMap<String, String> nodeMap = (HashMap<String, String>)result.get(nodeId);
            if (!result.containsKey(nodeId)) {
                nodeMap = new HashMap<String, String>();
                result.put(nodeId, nodeMap);
            }
            nodeMap.put(key.getDataKey(), entry.getValue());
        }
        return result;
    }

    public Map<InstanceNodeSessionId, Map<String, String>> getAllNodeProperties(Collection<InstanceNodeSessionId> nodeIds) {
        HashMap<InstanceNodeSessionId, Map<String, String>> result = new HashMap<InstanceNodeSessionId, Map<String, String>>();
        for (InstanceNodeSessionId nodeId : nodeIds) {
            result.put(nodeId, this.getNodeProperties(nodeId));
        }
        return result;
    }

    public void mergeUnchecked(Collection<NodePropertyImpl> update) {
        for (NodePropertyImpl entry : update) {
            this.knowledgeMap.put(entry.getCompositeKey(), entry);
        }
    }

    public Collection<NodePropertyImpl> mergeAndGetEffectiveSubset(Collection<NodePropertyImpl> update) {
        ArrayList<NodePropertyImpl> effectiveSubset = new ArrayList<NodePropertyImpl>();
        for (NodePropertyImpl entry : update) {
            CompositeNodePropertyKey ckey = entry.getCompositeKey();
            NodePropertyImpl existing = this.knowledgeMap.get(ckey);
            if (existing != null && existing.getSequenceNo() >= entry.getSequenceNo()) continue;
            this.knowledgeMap.put(ckey, entry);
            effectiveSubset.add(entry);
        }
        return effectiveSubset;
    }

    public Collection<NodePropertyImpl> getDetachedCopyOfEntries() {
        return Collections.unmodifiableCollection(new ArrayList<NodePropertyImpl>(this.knowledgeMap.values()));
    }

    public Collection<NodePropertyImpl> getComplementingKnowledge(Collection<NodePropertyImpl> input) {
        HashMap<CompositeNodePropertyKey, NodePropertyImpl> inputMap = new HashMap<CompositeNodePropertyKey, NodePropertyImpl>();
        for (NodePropertyImpl entry : input) {
            CompositeNodePropertyKey ckey = entry.getCompositeKey();
            NodeProperty existing = (NodeProperty)inputMap.get(ckey);
            if (existing == null) {
                inputMap.put(ckey, entry);
                continue;
            }
            this.log.warn((Object)("Received node property update with more than one entry for key " + ckey + "; falling back to full knowledge response"));
            return this.getDetachedCopyOfEntries();
        }
        ArrayList<NodePropertyImpl> response = new ArrayList<NodePropertyImpl>();
        for (NodePropertyImpl ownEntry : this.knowledgeMap.values()) {
            CompositeNodePropertyKey ckey = ownEntry.getCompositeKey();
            NodePropertyImpl correspondingInput = (NodePropertyImpl)inputMap.get(ckey);
            if (correspondingInput != null && correspondingInput.getSequenceNo() >= ownEntry.getSequenceNo()) continue;
            response.add(ownEntry);
        }
        return Collections.unmodifiableCollection(response);
    }

    public int getEntryCount() {
        return this.knowledgeMap.size();
    }
}

