/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.stores;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateEncodingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.gsi.CredentialException;
import org.globus.gsi.X509Credential;
import org.globus.gsi.stores.AbstractResourceSecurityWrapper;
import org.globus.gsi.stores.CredentialWrapper;
import org.globus.gsi.stores.ResourceStoreException;
import org.springframework.core.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceProxyCredential
extends AbstractResourceSecurityWrapper<X509Credential>
implements CredentialWrapper {
    private Log logger = LogFactory.getLog(this.getClass().getCanonicalName());

    public ResourceProxyCredential(String locationPattern) throws ResourceStoreException {
        this.init(locationPattern);
    }

    public ResourceProxyCredential(Resource resource) throws ResourceStoreException {
        this.init(resource);
    }

    public ResourceProxyCredential(String filename, X509Credential object) throws ResourceStoreException {
        this.init(filename, object);
    }

    public ResourceProxyCredential(Resource resource, X509Credential object) throws ResourceStoreException {
        this.init(resource, object);
    }

    @Override
    public X509Credential getCredential() throws ResourceStoreException {
        return (X509Credential)this.getSecurityObject();
    }

    @Override
    protected X509Credential create(Resource resource) throws ResourceStoreException {
        BufferedInputStream keyInputStream = null;
        InputStream certInputStream = null;
        try {
            keyInputStream = new BufferedInputStream(resource.getInputStream());
            certInputStream = new BufferedInputStream(resource.getInputStream());
            X509Credential x509Credential = new X509Credential(keyInputStream, certInputStream);
            return x509Credential;
        }
        catch (IOException e) {
            throw new ResourceStoreException(e);
        }
        catch (CredentialException e) {
            throw new ResourceStoreException(e);
        }
        finally {
            if (keyInputStream != null) {
                try {
                    ((InputStream)keyInputStream).close();
                }
                catch (Exception e) {
                    this.logger.warn("Unable to close stream.");
                }
            }
            if (certInputStream != null) {
                try {
                    certInputStream.close();
                }
                catch (Exception e) {
                    this.logger.warn("Unable to close stream.");
                }
            }
        }
    }

    @Override
    public void store() throws ResourceStoreException {
        try {
            X509Credential credential = this.getCredential();
            credential.writeToFile(this.resource.getFile());
        }
        catch (IOException ioe) {
            throw new ResourceStoreException(ioe);
        }
        catch (CertificateEncodingException e) {
            throw new ResourceStoreException(e);
        }
    }
}

