/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.stores;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.cert.X509CRL;
import org.globus.gsi.stores.AbstractResourceSecurityWrapper;
import org.globus.gsi.stores.ResourceStoreException;
import org.globus.gsi.util.CertificateLoadUtil;
import org.springframework.core.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceCRL
extends AbstractResourceSecurityWrapper<X509CRL> {
    public ResourceCRL(String fileName) throws ResourceStoreException {
        this.init(this.resolver.getResource(fileName));
    }

    public ResourceCRL(Resource resource) throws ResourceStoreException {
        this.init(resource);
    }

    public ResourceCRL(String fileName, X509CRL crl) throws ResourceStoreException {
        this.init(this.resolver.getResource(fileName), crl);
    }

    public X509CRL getCrl() throws ResourceStoreException {
        return (X509CRL)this.getSecurityObject();
    }

    @Override
    protected X509CRL create(Resource resource) throws ResourceStoreException {
        try {
            return CertificateLoadUtil.loadCrl(resource.getInputStream());
        }
        catch (IOException e) {
            throw new ResourceStoreException(e);
        }
        catch (GeneralSecurityException e) {
            throw new ResourceStoreException(e);
        }
    }

    @Override
    public void store() throws ResourceStoreException {
    }
}

