/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.jsse;

import java.io.ByteArrayInputStream;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.auth.Subject;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GlobusTLSContext {
    private static ThreadLocal<Subject> containerSubjectHolder = new ThreadLocal();
    private Subject containerSubject;
    private Subject peerSubject;
    private X509Certificate[] localCertChain;
    private X509Certificate[] peerCertChain;
    private Principal localPrincipal;
    private Principal peerPrincipal;
    private Date creationTime;
    private String sessionId;
    private String cipherSuite;
    private String protocol;
    private String peerHost;
    private int peerPort;
    private Log logger = LogFactory.getLog(this.getClass().getCanonicalName());

    public GlobusTLSContext(SSLSession sslSession) {
        this.containerSubject = new Subject();
        this.containerSubject.getPrincipals().add(sslSession.getLocalPrincipal());
        this.containerSubject.getPublicCredentials().add(this.getLocalCertChain(sslSession));
        containerSubjectHolder.set(this.containerSubject);
        this.peerSubject = new Subject();
        try {
            this.peerSubject.getPrincipals().add(sslSession.getPeerPrincipal());
        }
        catch (SSLPeerUnverifiedException e) {
            this.logger.warn(e.getLocalizedMessage(), e);
        }
        this.peerSubject.getPublicCredentials().add(this.getPeerCertChain(sslSession));
        this.creationTime = new Date(sslSession.getCreationTime());
        try {
            this.sessionId = Hex.encodeHexString(sslSession.getId());
        }
        catch (Exception e) {
            this.logger.warn(e.getLocalizedMessage(), e);
        }
        this.cipherSuite = sslSession.getCipherSuite();
        this.protocol = sslSession.getProtocol();
        this.peerHost = sslSession.getPeerHost();
        this.peerPort = sslSession.getPeerPort();
    }

    public static Subject getCurrentContainerSubject() {
        return containerSubjectHolder.get();
    }

    public X509Certificate[] getLocalCertChain() {
        return this.localCertChain;
    }

    public X509Certificate[] getPeerCertChain() {
        return this.peerCertChain;
    }

    public Principal getLocalPrincipal() {
        return this.localPrincipal;
    }

    public Principal getPeerPrincipal() {
        return this.peerPrincipal;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getCipherSuite() {
        return this.cipherSuite;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getPeerHost() {
        return this.peerHost;
    }

    public int getPeerPort() {
        return this.peerPort;
    }

    private X509Certificate[] getLocalCertChain(SSLSession sslSession) {
        try {
            Certificate[] javaxCerts = sslSession.getLocalCertificates();
            return this.processCerts(javaxCerts);
        }
        catch (Exception e) {
            this.logger.warn(e.getLocalizedMessage(), e);
            return null;
        }
    }

    private X509Certificate[] getPeerCertChain(SSLSession sslSession) {
        try {
            Certificate[] javaxCerts = sslSession.getPeerCertificates();
            return this.processCerts(javaxCerts);
        }
        catch (SSLPeerUnverifiedException e) {
            this.logger.warn(e.getLocalizedMessage(), e);
            return null;
        }
        catch (CertificateEncodingException e) {
            this.logger.warn(e.getLocalizedMessage(), e);
            return null;
        }
        catch (CertificateException e) {
            this.logger.warn(e.getLocalizedMessage(), e);
            return null;
        }
    }

    private X509Certificate[] processCerts(Certificate[] javaxCerts) throws CertificateException, CertificateEncodingException {
        if (javaxCerts == null || javaxCerts.length == 0) {
            return null;
        }
        int length = javaxCerts.length;
        X509Certificate[] javaCerts = new X509Certificate[length];
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        for (int i = 0; i < length; ++i) {
            byte[] bytes = javaxCerts[i].getEncoded();
            ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
            javaCerts[i] = (X509Certificate)cf.generateCertificate(stream);
        }
        return javaCerts;
    }
}

