/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi;

import java.io.File;
import java.io.FilenameFilter;
import java.io.Serializable;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.common.CoGProperties;
import org.globus.gsi.ProviderLoader;
import org.globus.gsi.SigningPolicy;
import org.globus.gsi.provider.KeyStoreParametersFactory;
import org.globus.gsi.stores.ResourceSigningPolicyStore;
import org.globus.gsi.stores.ResourceSigningPolicyStoreParameters;
import org.globus.gsi.util.CertificateUtil;
import org.globus.gsi.util.KeyStoreUtil;

public class TrustedCertificates
implements Serializable {
    private static Log logger = LogFactory.getLog(TrustedCertificates.class.getName());
    public static final CertFilter certFileFilter;
    private static TrustedCertificates trustedCertificates;
    private Map certSubjectDNMap;
    private Map policyDNMap;
    private Vector certList;
    private boolean changed;
    public static String SIGNING_POLICY_FILE_SUFFIX;

    protected TrustedCertificates() {
    }

    public TrustedCertificates(X509Certificate[] certs) {
        this(certs, null);
    }

    public TrustedCertificates(X509Certificate[] certs, SigningPolicy[] policies) {
        int i;
        this.certSubjectDNMap = new HashMap();
        for (i = 0; i < certs.length; ++i) {
            if (certs[i] == null) continue;
            String dn = ((Object)certs[i].getSubjectDN()).toString();
            this.certSubjectDNMap.put(dn, certs[i]);
        }
        if (policies != null) {
            this.policyDNMap = new HashMap();
            for (i = 0; i < policies.length; ++i) {
                if (policies[i] == null) continue;
                this.policyDNMap.put(CertificateUtil.toGlobusID(policies[i].getCASubjectDN()), policies[i]);
            }
        }
    }

    public X509Certificate[] getCertificates() {
        if (this.certSubjectDNMap == null) {
            return null;
        }
        Collection certs = this.certSubjectDNMap.values();
        return certs.toArray(new X509Certificate[certs.size()]);
    }

    public X509Certificate getCertificate(String subject) {
        if (this.certSubjectDNMap == null) {
            return null;
        }
        return (X509Certificate)this.certSubjectDNMap.get(subject);
    }

    public SigningPolicy[] getSigningPolicies() {
        if (this.policyDNMap == null) {
            return null;
        }
        Collection values = this.policyDNMap.values();
        return this.policyDNMap.values().toArray(new SigningPolicy[values.size()]);
    }

    public SigningPolicy getSigningPolicy(String subject) {
        if (this.policyDNMap == null) {
            return null;
        }
        return (SigningPolicy)this.policyDNMap.get(subject);
    }

    public static X509Certificate[] loadCertificates(String locations) {
        TrustedCertificates tc = TrustedCertificates.load(locations);
        return tc == null ? null : tc.getCertificates();
    }

    public static TrustedCertificates load(String locations) {
        TrustedCertificates tc = new TrustedCertificates();
        tc.reload(locations);
        return tc;
    }

    public static FilenameFilter getCertFilter() {
        return certFileFilter;
    }

    public void refresh() {
        this.reload(null);
    }

    public synchronized void reload(String locations) {
        if (locations == null) {
            return;
        }
        this.changed = false;
        StringTokenizer tokens = new StringTokenizer(locations, ",");
        File caDir = null;
        HashMap<String, X509Certificate> newCertSubjectDNMap = new HashMap<String, X509Certificate>();
        HashMap<String, SigningPolicy> newSigningDNMap = new HashMap<String, SigningPolicy>();
        while (tokens.hasMoreTokens()) {
            caDir = new File(tokens.nextToken().toString().trim());
            if (!caDir.canRead()) {
                logger.debug("Cannot read: " + caDir.getAbsolutePath());
                continue;
            }
            String caCertLocation = "file:" + caDir.getAbsolutePath();
            String sigPolPattern = caCertLocation + "/*.signing_policy";
            if (!caDir.isDirectory()) {
                sigPolPattern = this.getPolicyFileName(caCertLocation);
            }
            KeyStore keyStore = null;
            try {
                keyStore = KeyStore.getInstance("PEMFilebasedKeyStore", "Globus");
                keyStore.load(KeyStoreParametersFactory.createTrustStoreParameters(caCertLocation));
                Collection<? extends Certificate> caCerts = KeyStoreUtil.getTrustedCertificates(keyStore, new X509CertSelector());
                for (X509Certificate x509Certificate : caCerts) {
                    newCertSubjectDNMap.put(((Object)x509Certificate.getSubjectDN()).toString(), x509Certificate);
                }
            }
            catch (Exception e) {
                logger.warn("Failed to create trust store", e);
            }
            try {
                ResourceSigningPolicyStore sigPolStore = new ResourceSigningPolicyStore(new ResourceSigningPolicyStoreParameters(sigPolPattern));
                Collection<? extends Certificate> caCerts = KeyStoreUtil.getTrustedCertificates(keyStore, new X509CertSelector());
                for (X509Certificate x509Certificate : caCerts) {
                    X500Principal principal = x509Certificate.getSubjectX500Principal();
                    SigningPolicy policy = sigPolStore.getSigningPolicy(principal);
                    if (policy != null) {
                        newSigningDNMap.put(CertificateUtil.toGlobusID(policy.getCASubjectDN()), policy);
                        continue;
                    }
                    logger.warn("no signing policy for ca cert " + x509Certificate.getSubjectDN());
                }
            }
            catch (Exception e) {
                logger.warn("Failed to create signing policy store", e);
            }
        }
        this.changed = true;
        this.certSubjectDNMap = newCertSubjectDNMap;
        this.policyDNMap = newSigningDNMap;
        if (this.changed) {
            this.certList = null;
        }
    }

    private String getPolicyFileName(String caFileName) {
        return caFileName.substring(0, caFileName.lastIndexOf(".")) + SIGNING_POLICY_FILE_SUFFIX;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public static synchronized TrustedCertificates getDefaultTrustedCertificates() {
        return TrustedCertificates.getDefault();
    }

    public static void setDefaultTrustedCertificates(TrustedCertificates trusted) {
        trustedCertificates = trusted;
    }

    public static synchronized TrustedCertificates getDefault() {
        if (trustedCertificates == null) {
            trustedCertificates = new DefaultTrustedCertificates();
        }
        trustedCertificates.refresh();
        return trustedCertificates;
    }

    public String toString() {
        String returnStr = "";
        returnStr = this.certSubjectDNMap == null ? "Certificate list is empty." : this.certSubjectDNMap.toString();
        returnStr = this.policyDNMap == null ? returnStr + "Signing policy list is empty." : returnStr + this.policyDNMap.toString();
        return returnStr;
    }

    static {
        new ProviderLoader();
        certFileFilter = new CertFilter();
        trustedCertificates = null;
        SIGNING_POLICY_FILE_SUFFIX = ".signing_policy";
    }

    private static class DefaultTrustedCertificates
    extends TrustedCertificates {
        private DefaultTrustedCertificates() {
        }

        public void refresh() {
            this.reload(CoGProperties.getDefault().getCaCertLocations());
        }
    }

    public static class CertFilter
    implements FilenameFilter {
        public boolean accept(File dir, String file) {
            int length = file.length();
            return length > 2 && file.charAt(length - 2) == '.' && file.charAt(length - 1) >= '0' && file.charAt(length - 1) <= '9';
        }
    }
}

