/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi;

import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.x500.X500Principal;
import org.globus.gsi.SigningPolicyParser;
import org.globus.gsi.util.CertificateUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SigningPolicy {
    private X500Principal caSubject;
    private List<Pattern> allowedDNs;

    public SigningPolicy(X500Principal caSubjectDN, String[] allowedDNs) {
        if (caSubjectDN == null || allowedDNs == null) {
            throw new IllegalArgumentException();
        }
        this.caSubject = caSubjectDN;
        int numberOfDNs = allowedDNs.length;
        this.allowedDNs = new Vector<Pattern>(numberOfDNs);
        for (String anAllowedDNs : allowedDNs) {
            this.allowedDNs.add(SigningPolicyParser.getPattern(anAllowedDNs));
        }
    }

    public SigningPolicy(X500Principal caSubjectDN, List<Pattern> allowedDNs) {
        if (caSubjectDN == null || allowedDNs == null) {
            throw new IllegalArgumentException();
        }
        this.caSubject = caSubjectDN;
        this.allowedDNs = allowedDNs;
    }

    public X500Principal getCASubjectDN() {
        return this.caSubject;
    }

    public boolean isValidSubject(X500Principal subject) {
        if (subject == null) {
            throw new IllegalArgumentException();
        }
        String subjectDN = CertificateUtil.toGlobusID(subject);
        if (this.allowedDNs == null || this.allowedDNs.size() < 1) {
            return true;
        }
        int size = this.allowedDNs.size();
        for (int i = 0; i < size; ++i) {
            Pattern pattern = this.allowedDNs.get(i);
            Matcher matcher = pattern.matcher(subjectDN);
            boolean valid = matcher.matches();
            if (!valid) continue;
            return true;
        }
        return false;
    }

    public List<Pattern> getAllowedDNs() {
        return this.allowedDNs;
    }

    public boolean isPolicyAvailable() {
        return this.allowedDNs != null && this.allowedDNs.size() >= 1;
    }
}

